package software.amazon.awsconstructs.services.kinesisstreamslambda;

/**
 * The properties for the KinesisStreamsToLambda class.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-02T03:16:57.155Z")
@software.amazon.jsii.Jsii(module = software.amazon.awsconstructs.services.kinesisstreamslambda.$Module.class, fqn = "@aws-solutions-constructs/aws-kinesisstreams-lambda.KinesisStreamsToLambdaProps")
@software.amazon.jsii.Jsii.Proxy(KinesisStreamsToLambdaProps.Jsii$Proxy.class)
public interface KinesisStreamsToLambdaProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether to create recommended CloudWatch alarms.
     * <p>
     * Default: - Alarms are created
     */
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCreateCloudWatchAlarms() {
        return null;
    }

    /**
     * Whether to deploy a SQS dead letter queue when a data record reaches the Maximum Retry Attempts or Maximum Record Age, its metadata like shard ID and stream ARN will be sent to an SQS queue.
     * <p>
     * Default: - true.
     */
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDeploySqsDlqQueue() {
        return null;
    }

    /**
     * Existing instance of Lambda Function object, providing both this and `lambdaFunctionProps` will cause an error.
     * <p>
     * Default: - None
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.Function getExistingLambdaObj() {
        return null;
    }

    /**
     * Existing instance of Kinesis Stream, providing both this and `kinesisStreamProps` will cause an error.
     * <p>
     * Default: - None
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesis.Stream getExistingStreamObj() {
        return null;
    }

    /**
     * Optional user-provided props to override the default props for the Lambda event source mapping.
     * <p>
     * Default: - Default props are used.
     */
    default @org.jetbrains.annotations.Nullable java.lang.Object getKinesisEventSourceProps() {
        return null;
    }

    /**
     * Optional user-provided props to override the default props for the Kinesis stream.
     * <p>
     * Default: - Default props are used.
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesis.StreamProps getKinesisStreamProps() {
        return null;
    }

    /**
     * User provided props to override the default props for the Lambda function.
     * <p>
     * Default: - Default props are used.
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.FunctionProps getLambdaFunctionProps() {
        return null;
    }

    /**
     * Optional user provided properties for the SQS dead letter queue.
     * <p>
     * Default: - Default props are used
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sqs.QueueProps getSqsDlqQueueProps() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link KinesisStreamsToLambdaProps}
     */
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link KinesisStreamsToLambdaProps}
     */
    public static final class Builder implements software.amazon.jsii.Builder<KinesisStreamsToLambdaProps> {
        java.lang.Boolean createCloudWatchAlarms;
        java.lang.Boolean deploySqsDlqQueue;
        software.amazon.awscdk.services.lambda.Function existingLambdaObj;
        software.amazon.awscdk.services.kinesis.Stream existingStreamObj;
        java.lang.Object kinesisEventSourceProps;
        software.amazon.awscdk.services.kinesis.StreamProps kinesisStreamProps;
        software.amazon.awscdk.services.lambda.FunctionProps lambdaFunctionProps;
        software.amazon.awscdk.services.sqs.QueueProps sqsDlqQueueProps;

        /**
         * Sets the value of {@link KinesisStreamsToLambdaProps#getCreateCloudWatchAlarms}
         * @param createCloudWatchAlarms Whether to create recommended CloudWatch alarms.
         * @return {@code this}
         */
        public Builder createCloudWatchAlarms(java.lang.Boolean createCloudWatchAlarms) {
            this.createCloudWatchAlarms = createCloudWatchAlarms;
            return this;
        }

        /**
         * Sets the value of {@link KinesisStreamsToLambdaProps#getDeploySqsDlqQueue}
         * @param deploySqsDlqQueue Whether to deploy a SQS dead letter queue when a data record reaches the Maximum Retry Attempts or Maximum Record Age, its metadata like shard ID and stream ARN will be sent to an SQS queue.
         * @return {@code this}
         */
        public Builder deploySqsDlqQueue(java.lang.Boolean deploySqsDlqQueue) {
            this.deploySqsDlqQueue = deploySqsDlqQueue;
            return this;
        }

        /**
         * Sets the value of {@link KinesisStreamsToLambdaProps#getExistingLambdaObj}
         * @param existingLambdaObj Existing instance of Lambda Function object, providing both this and `lambdaFunctionProps` will cause an error.
         * @return {@code this}
         */
        public Builder existingLambdaObj(software.amazon.awscdk.services.lambda.Function existingLambdaObj) {
            this.existingLambdaObj = existingLambdaObj;
            return this;
        }

        /**
         * Sets the value of {@link KinesisStreamsToLambdaProps#getExistingStreamObj}
         * @param existingStreamObj Existing instance of Kinesis Stream, providing both this and `kinesisStreamProps` will cause an error.
         * @return {@code this}
         */
        public Builder existingStreamObj(software.amazon.awscdk.services.kinesis.Stream existingStreamObj) {
            this.existingStreamObj = existingStreamObj;
            return this;
        }

        /**
         * Sets the value of {@link KinesisStreamsToLambdaProps#getKinesisEventSourceProps}
         * @param kinesisEventSourceProps Optional user-provided props to override the default props for the Lambda event source mapping.
         * @return {@code this}
         */
        public Builder kinesisEventSourceProps(java.lang.Object kinesisEventSourceProps) {
            this.kinesisEventSourceProps = kinesisEventSourceProps;
            return this;
        }

        /**
         * Sets the value of {@link KinesisStreamsToLambdaProps#getKinesisStreamProps}
         * @param kinesisStreamProps Optional user-provided props to override the default props for the Kinesis stream.
         * @return {@code this}
         */
        public Builder kinesisStreamProps(software.amazon.awscdk.services.kinesis.StreamProps kinesisStreamProps) {
            this.kinesisStreamProps = kinesisStreamProps;
            return this;
        }

        /**
         * Sets the value of {@link KinesisStreamsToLambdaProps#getLambdaFunctionProps}
         * @param lambdaFunctionProps User provided props to override the default props for the Lambda function.
         * @return {@code this}
         */
        public Builder lambdaFunctionProps(software.amazon.awscdk.services.lambda.FunctionProps lambdaFunctionProps) {
            this.lambdaFunctionProps = lambdaFunctionProps;
            return this;
        }

        /**
         * Sets the value of {@link KinesisStreamsToLambdaProps#getSqsDlqQueueProps}
         * @param sqsDlqQueueProps Optional user provided properties for the SQS dead letter queue.
         * @return {@code this}
         */
        public Builder sqsDlqQueueProps(software.amazon.awscdk.services.sqs.QueueProps sqsDlqQueueProps) {
            this.sqsDlqQueueProps = sqsDlqQueueProps;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link KinesisStreamsToLambdaProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @Override
        public KinesisStreamsToLambdaProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link KinesisStreamsToLambdaProps}
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisStreamsToLambdaProps {
        private final java.lang.Boolean createCloudWatchAlarms;
        private final java.lang.Boolean deploySqsDlqQueue;
        private final software.amazon.awscdk.services.lambda.Function existingLambdaObj;
        private final software.amazon.awscdk.services.kinesis.Stream existingStreamObj;
        private final java.lang.Object kinesisEventSourceProps;
        private final software.amazon.awscdk.services.kinesis.StreamProps kinesisStreamProps;
        private final software.amazon.awscdk.services.lambda.FunctionProps lambdaFunctionProps;
        private final software.amazon.awscdk.services.sqs.QueueProps sqsDlqQueueProps;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.createCloudWatchAlarms = software.amazon.jsii.Kernel.get(this, "createCloudWatchAlarms", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.deploySqsDlqQueue = software.amazon.jsii.Kernel.get(this, "deploySqsDlqQueue", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.existingLambdaObj = software.amazon.jsii.Kernel.get(this, "existingLambdaObj", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Function.class));
            this.existingStreamObj = software.amazon.jsii.Kernel.get(this, "existingStreamObj", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesis.Stream.class));
            this.kinesisEventSourceProps = software.amazon.jsii.Kernel.get(this, "kinesisEventSourceProps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kinesisStreamProps = software.amazon.jsii.Kernel.get(this, "kinesisStreamProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesis.StreamProps.class));
            this.lambdaFunctionProps = software.amazon.jsii.Kernel.get(this, "lambdaFunctionProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.FunctionProps.class));
            this.sqsDlqQueueProps = software.amazon.jsii.Kernel.get(this, "sqsDlqQueueProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sqs.QueueProps.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.createCloudWatchAlarms = builder.createCloudWatchAlarms;
            this.deploySqsDlqQueue = builder.deploySqsDlqQueue;
            this.existingLambdaObj = builder.existingLambdaObj;
            this.existingStreamObj = builder.existingStreamObj;
            this.kinesisEventSourceProps = builder.kinesisEventSourceProps;
            this.kinesisStreamProps = builder.kinesisStreamProps;
            this.lambdaFunctionProps = builder.lambdaFunctionProps;
            this.sqsDlqQueueProps = builder.sqsDlqQueueProps;
        }

        @Override
        public final java.lang.Boolean getCreateCloudWatchAlarms() {
            return this.createCloudWatchAlarms;
        }

        @Override
        public final java.lang.Boolean getDeploySqsDlqQueue() {
            return this.deploySqsDlqQueue;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.Function getExistingLambdaObj() {
            return this.existingLambdaObj;
        }

        @Override
        public final software.amazon.awscdk.services.kinesis.Stream getExistingStreamObj() {
            return this.existingStreamObj;
        }

        @Override
        public final java.lang.Object getKinesisEventSourceProps() {
            return this.kinesisEventSourceProps;
        }

        @Override
        public final software.amazon.awscdk.services.kinesis.StreamProps getKinesisStreamProps() {
            return this.kinesisStreamProps;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.FunctionProps getLambdaFunctionProps() {
            return this.lambdaFunctionProps;
        }

        @Override
        public final software.amazon.awscdk.services.sqs.QueueProps getSqsDlqQueueProps() {
            return this.sqsDlqQueueProps;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCreateCloudWatchAlarms() != null) {
                data.set("createCloudWatchAlarms", om.valueToTree(this.getCreateCloudWatchAlarms()));
            }
            if (this.getDeploySqsDlqQueue() != null) {
                data.set("deploySqsDlqQueue", om.valueToTree(this.getDeploySqsDlqQueue()));
            }
            if (this.getExistingLambdaObj() != null) {
                data.set("existingLambdaObj", om.valueToTree(this.getExistingLambdaObj()));
            }
            if (this.getExistingStreamObj() != null) {
                data.set("existingStreamObj", om.valueToTree(this.getExistingStreamObj()));
            }
            if (this.getKinesisEventSourceProps() != null) {
                data.set("kinesisEventSourceProps", om.valueToTree(this.getKinesisEventSourceProps()));
            }
            if (this.getKinesisStreamProps() != null) {
                data.set("kinesisStreamProps", om.valueToTree(this.getKinesisStreamProps()));
            }
            if (this.getLambdaFunctionProps() != null) {
                data.set("lambdaFunctionProps", om.valueToTree(this.getLambdaFunctionProps()));
            }
            if (this.getSqsDlqQueueProps() != null) {
                data.set("sqsDlqQueueProps", om.valueToTree(this.getSqsDlqQueueProps()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-solutions-constructs/aws-kinesisstreams-lambda.KinesisStreamsToLambdaProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            KinesisStreamsToLambdaProps.Jsii$Proxy that = (KinesisStreamsToLambdaProps.Jsii$Proxy) o;

            if (this.createCloudWatchAlarms != null ? !this.createCloudWatchAlarms.equals(that.createCloudWatchAlarms) : that.createCloudWatchAlarms != null) return false;
            if (this.deploySqsDlqQueue != null ? !this.deploySqsDlqQueue.equals(that.deploySqsDlqQueue) : that.deploySqsDlqQueue != null) return false;
            if (this.existingLambdaObj != null ? !this.existingLambdaObj.equals(that.existingLambdaObj) : that.existingLambdaObj != null) return false;
            if (this.existingStreamObj != null ? !this.existingStreamObj.equals(that.existingStreamObj) : that.existingStreamObj != null) return false;
            if (this.kinesisEventSourceProps != null ? !this.kinesisEventSourceProps.equals(that.kinesisEventSourceProps) : that.kinesisEventSourceProps != null) return false;
            if (this.kinesisStreamProps != null ? !this.kinesisStreamProps.equals(that.kinesisStreamProps) : that.kinesisStreamProps != null) return false;
            if (this.lambdaFunctionProps != null ? !this.lambdaFunctionProps.equals(that.lambdaFunctionProps) : that.lambdaFunctionProps != null) return false;
            return this.sqsDlqQueueProps != null ? this.sqsDlqQueueProps.equals(that.sqsDlqQueueProps) : that.sqsDlqQueueProps == null;
        }

        @Override
        public final int hashCode() {
            int result = this.createCloudWatchAlarms != null ? this.createCloudWatchAlarms.hashCode() : 0;
            result = 31 * result + (this.deploySqsDlqQueue != null ? this.deploySqsDlqQueue.hashCode() : 0);
            result = 31 * result + (this.existingLambdaObj != null ? this.existingLambdaObj.hashCode() : 0);
            result = 31 * result + (this.existingStreamObj != null ? this.existingStreamObj.hashCode() : 0);
            result = 31 * result + (this.kinesisEventSourceProps != null ? this.kinesisEventSourceProps.hashCode() : 0);
            result = 31 * result + (this.kinesisStreamProps != null ? this.kinesisStreamProps.hashCode() : 0);
            result = 31 * result + (this.lambdaFunctionProps != null ? this.lambdaFunctionProps.hashCode() : 0);
            result = 31 * result + (this.sqsDlqQueueProps != null ? this.sqsDlqQueueProps.hashCode() : 0);
            return result;
        }
    }
}
