package software.amazon.awsconstructs.services.lambdakinesisstreams;

/**
 * The properties for the LambdaToKinesisStreams class.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.102.0 (build e354887)", date = "2024-08-27T01:32:30.466Z")
@software.amazon.jsii.Jsii(module = software.amazon.awsconstructs.services.lambdakinesisstreams.$Module.class, fqn = "@aws-solutions-constructs/aws-lambda-kinesisstreams.LambdaToKinesisStreamsProps")
@software.amazon.jsii.Jsii.Proxy(LambdaToKinesisStreamsProps.Jsii$Proxy.class)
public interface LambdaToKinesisStreamsProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether to create recommended CloudWatch alarms for the Kinesis Stream.
     * <p>
     * Default: - Alarms are created
     */
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCreateCloudWatchAlarms() {
        return null;
    }

    /**
     * Whether to deploy a new VPC.
     * <p>
     * Default: - false
     */
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDeployVpc() {
        return null;
    }

    /**
     * Existing instance of Lambda Function object, providing both this and <code>lambdaFunctionProps</code> will cause an error.
     * <p>
     * Default: - None
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.Function getExistingLambdaObj() {
        return null;
    }

    /**
     * Existing instance of Kinesis Stream, providing both this and <code>kinesisStreamProps</code> will cause an error.
     * <p>
     * Default: - None
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesis.Stream getExistingStreamObj() {
        return null;
    }

    /**
     * An existing VPC for the construct to use (construct will NOT create a new VPC in this case).
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getExistingVpc() {
        return null;
    }

    /**
     * Optional user-provided props to override the default props for the Kinesis stream.
     * <p>
     * Default: - Default props are used.
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesis.StreamProps getKinesisStreamProps() {
        return null;
    }

    /**
     * User provided props to override the default props for the Lambda function.
     * <p>
     * Default: - Default props are used.
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.FunctionProps getLambdaFunctionProps() {
        return null;
    }

    /**
     * Optional Name to override the Lambda Function default environment variable name that holds the Kinesis Data Stream name value.
     * <p>
     * Default: - KINESIS_DATASTREAM_NAME
     */
    default @org.jetbrains.annotations.Nullable java.lang.String getStreamEnvironmentVariableName() {
        return null;
    }

    /**
     * Properties to override default properties if deployVpc is true.
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.VpcProps getVpcProps() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LambdaToKinesisStreamsProps}
     */
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LambdaToKinesisStreamsProps}
     */
    public static final class Builder implements software.amazon.jsii.Builder<LambdaToKinesisStreamsProps> {
        java.lang.Boolean createCloudWatchAlarms;
        java.lang.Boolean deployVpc;
        software.amazon.awscdk.services.lambda.Function existingLambdaObj;
        software.amazon.awscdk.services.kinesis.Stream existingStreamObj;
        software.amazon.awscdk.services.ec2.IVpc existingVpc;
        software.amazon.awscdk.services.kinesis.StreamProps kinesisStreamProps;
        software.amazon.awscdk.services.lambda.FunctionProps lambdaFunctionProps;
        java.lang.String streamEnvironmentVariableName;
        software.amazon.awscdk.services.ec2.VpcProps vpcProps;

        /**
         * Sets the value of {@link LambdaToKinesisStreamsProps#getCreateCloudWatchAlarms}
         * @param createCloudWatchAlarms Whether to create recommended CloudWatch alarms for the Kinesis Stream.
         * @return {@code this}
         */
        public Builder createCloudWatchAlarms(java.lang.Boolean createCloudWatchAlarms) {
            this.createCloudWatchAlarms = createCloudWatchAlarms;
            return this;
        }

        /**
         * Sets the value of {@link LambdaToKinesisStreamsProps#getDeployVpc}
         * @param deployVpc Whether to deploy a new VPC.
         * @return {@code this}
         */
        public Builder deployVpc(java.lang.Boolean deployVpc) {
            this.deployVpc = deployVpc;
            return this;
        }

        /**
         * Sets the value of {@link LambdaToKinesisStreamsProps#getExistingLambdaObj}
         * @param existingLambdaObj Existing instance of Lambda Function object, providing both this and <code>lambdaFunctionProps</code> will cause an error.
         * @return {@code this}
         */
        public Builder existingLambdaObj(software.amazon.awscdk.services.lambda.Function existingLambdaObj) {
            this.existingLambdaObj = existingLambdaObj;
            return this;
        }

        /**
         * Sets the value of {@link LambdaToKinesisStreamsProps#getExistingStreamObj}
         * @param existingStreamObj Existing instance of Kinesis Stream, providing both this and <code>kinesisStreamProps</code> will cause an error.
         * @return {@code this}
         */
        public Builder existingStreamObj(software.amazon.awscdk.services.kinesis.Stream existingStreamObj) {
            this.existingStreamObj = existingStreamObj;
            return this;
        }

        /**
         * Sets the value of {@link LambdaToKinesisStreamsProps#getExistingVpc}
         * @param existingVpc An existing VPC for the construct to use (construct will NOT create a new VPC in this case).
         * @return {@code this}
         */
        public Builder existingVpc(software.amazon.awscdk.services.ec2.IVpc existingVpc) {
            this.existingVpc = existingVpc;
            return this;
        }

        /**
         * Sets the value of {@link LambdaToKinesisStreamsProps#getKinesisStreamProps}
         * @param kinesisStreamProps Optional user-provided props to override the default props for the Kinesis stream.
         * @return {@code this}
         */
        public Builder kinesisStreamProps(software.amazon.awscdk.services.kinesis.StreamProps kinesisStreamProps) {
            this.kinesisStreamProps = kinesisStreamProps;
            return this;
        }

        /**
         * Sets the value of {@link LambdaToKinesisStreamsProps#getLambdaFunctionProps}
         * @param lambdaFunctionProps User provided props to override the default props for the Lambda function.
         * @return {@code this}
         */
        public Builder lambdaFunctionProps(software.amazon.awscdk.services.lambda.FunctionProps lambdaFunctionProps) {
            this.lambdaFunctionProps = lambdaFunctionProps;
            return this;
        }

        /**
         * Sets the value of {@link LambdaToKinesisStreamsProps#getStreamEnvironmentVariableName}
         * @param streamEnvironmentVariableName Optional Name to override the Lambda Function default environment variable name that holds the Kinesis Data Stream name value.
         * @return {@code this}
         */
        public Builder streamEnvironmentVariableName(java.lang.String streamEnvironmentVariableName) {
            this.streamEnvironmentVariableName = streamEnvironmentVariableName;
            return this;
        }

        /**
         * Sets the value of {@link LambdaToKinesisStreamsProps#getVpcProps}
         * @param vpcProps Properties to override default properties if deployVpc is true.
         * @return {@code this}
         */
        public Builder vpcProps(software.amazon.awscdk.services.ec2.VpcProps vpcProps) {
            this.vpcProps = vpcProps;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LambdaToKinesisStreamsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @Override
        public LambdaToKinesisStreamsProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LambdaToKinesisStreamsProps}
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaToKinesisStreamsProps {
        private final java.lang.Boolean createCloudWatchAlarms;
        private final java.lang.Boolean deployVpc;
        private final software.amazon.awscdk.services.lambda.Function existingLambdaObj;
        private final software.amazon.awscdk.services.kinesis.Stream existingStreamObj;
        private final software.amazon.awscdk.services.ec2.IVpc existingVpc;
        private final software.amazon.awscdk.services.kinesis.StreamProps kinesisStreamProps;
        private final software.amazon.awscdk.services.lambda.FunctionProps lambdaFunctionProps;
        private final java.lang.String streamEnvironmentVariableName;
        private final software.amazon.awscdk.services.ec2.VpcProps vpcProps;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.createCloudWatchAlarms = software.amazon.jsii.Kernel.get(this, "createCloudWatchAlarms", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.deployVpc = software.amazon.jsii.Kernel.get(this, "deployVpc", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.existingLambdaObj = software.amazon.jsii.Kernel.get(this, "existingLambdaObj", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Function.class));
            this.existingStreamObj = software.amazon.jsii.Kernel.get(this, "existingStreamObj", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesis.Stream.class));
            this.existingVpc = software.amazon.jsii.Kernel.get(this, "existingVpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.kinesisStreamProps = software.amazon.jsii.Kernel.get(this, "kinesisStreamProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesis.StreamProps.class));
            this.lambdaFunctionProps = software.amazon.jsii.Kernel.get(this, "lambdaFunctionProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.FunctionProps.class));
            this.streamEnvironmentVariableName = software.amazon.jsii.Kernel.get(this, "streamEnvironmentVariableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpcProps = software.amazon.jsii.Kernel.get(this, "vpcProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.VpcProps.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.createCloudWatchAlarms = builder.createCloudWatchAlarms;
            this.deployVpc = builder.deployVpc;
            this.existingLambdaObj = builder.existingLambdaObj;
            this.existingStreamObj = builder.existingStreamObj;
            this.existingVpc = builder.existingVpc;
            this.kinesisStreamProps = builder.kinesisStreamProps;
            this.lambdaFunctionProps = builder.lambdaFunctionProps;
            this.streamEnvironmentVariableName = builder.streamEnvironmentVariableName;
            this.vpcProps = builder.vpcProps;
        }

        @Override
        public final java.lang.Boolean getCreateCloudWatchAlarms() {
            return this.createCloudWatchAlarms;
        }

        @Override
        public final java.lang.Boolean getDeployVpc() {
            return this.deployVpc;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.Function getExistingLambdaObj() {
            return this.existingLambdaObj;
        }

        @Override
        public final software.amazon.awscdk.services.kinesis.Stream getExistingStreamObj() {
            return this.existingStreamObj;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getExistingVpc() {
            return this.existingVpc;
        }

        @Override
        public final software.amazon.awscdk.services.kinesis.StreamProps getKinesisStreamProps() {
            return this.kinesisStreamProps;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.FunctionProps getLambdaFunctionProps() {
            return this.lambdaFunctionProps;
        }

        @Override
        public final java.lang.String getStreamEnvironmentVariableName() {
            return this.streamEnvironmentVariableName;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.VpcProps getVpcProps() {
            return this.vpcProps;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCreateCloudWatchAlarms() != null) {
                data.set("createCloudWatchAlarms", om.valueToTree(this.getCreateCloudWatchAlarms()));
            }
            if (this.getDeployVpc() != null) {
                data.set("deployVpc", om.valueToTree(this.getDeployVpc()));
            }
            if (this.getExistingLambdaObj() != null) {
                data.set("existingLambdaObj", om.valueToTree(this.getExistingLambdaObj()));
            }
            if (this.getExistingStreamObj() != null) {
                data.set("existingStreamObj", om.valueToTree(this.getExistingStreamObj()));
            }
            if (this.getExistingVpc() != null) {
                data.set("existingVpc", om.valueToTree(this.getExistingVpc()));
            }
            if (this.getKinesisStreamProps() != null) {
                data.set("kinesisStreamProps", om.valueToTree(this.getKinesisStreamProps()));
            }
            if (this.getLambdaFunctionProps() != null) {
                data.set("lambdaFunctionProps", om.valueToTree(this.getLambdaFunctionProps()));
            }
            if (this.getStreamEnvironmentVariableName() != null) {
                data.set("streamEnvironmentVariableName", om.valueToTree(this.getStreamEnvironmentVariableName()));
            }
            if (this.getVpcProps() != null) {
                data.set("vpcProps", om.valueToTree(this.getVpcProps()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-solutions-constructs/aws-lambda-kinesisstreams.LambdaToKinesisStreamsProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LambdaToKinesisStreamsProps.Jsii$Proxy that = (LambdaToKinesisStreamsProps.Jsii$Proxy) o;

            if (this.createCloudWatchAlarms != null ? !this.createCloudWatchAlarms.equals(that.createCloudWatchAlarms) : that.createCloudWatchAlarms != null) return false;
            if (this.deployVpc != null ? !this.deployVpc.equals(that.deployVpc) : that.deployVpc != null) return false;
            if (this.existingLambdaObj != null ? !this.existingLambdaObj.equals(that.existingLambdaObj) : that.existingLambdaObj != null) return false;
            if (this.existingStreamObj != null ? !this.existingStreamObj.equals(that.existingStreamObj) : that.existingStreamObj != null) return false;
            if (this.existingVpc != null ? !this.existingVpc.equals(that.existingVpc) : that.existingVpc != null) return false;
            if (this.kinesisStreamProps != null ? !this.kinesisStreamProps.equals(that.kinesisStreamProps) : that.kinesisStreamProps != null) return false;
            if (this.lambdaFunctionProps != null ? !this.lambdaFunctionProps.equals(that.lambdaFunctionProps) : that.lambdaFunctionProps != null) return false;
            if (this.streamEnvironmentVariableName != null ? !this.streamEnvironmentVariableName.equals(that.streamEnvironmentVariableName) : that.streamEnvironmentVariableName != null) return false;
            return this.vpcProps != null ? this.vpcProps.equals(that.vpcProps) : that.vpcProps == null;
        }

        @Override
        public final int hashCode() {
            int result = this.createCloudWatchAlarms != null ? this.createCloudWatchAlarms.hashCode() : 0;
            result = 31 * result + (this.deployVpc != null ? this.deployVpc.hashCode() : 0);
            result = 31 * result + (this.existingLambdaObj != null ? this.existingLambdaObj.hashCode() : 0);
            result = 31 * result + (this.existingStreamObj != null ? this.existingStreamObj.hashCode() : 0);
            result = 31 * result + (this.existingVpc != null ? this.existingVpc.hashCode() : 0);
            result = 31 * result + (this.kinesisStreamProps != null ? this.kinesisStreamProps.hashCode() : 0);
            result = 31 * result + (this.lambdaFunctionProps != null ? this.lambdaFunctionProps.hashCode() : 0);
            result = 31 * result + (this.streamEnvironmentVariableName != null ? this.streamEnvironmentVariableName.hashCode() : 0);
            result = 31 * result + (this.vpcProps != null ? this.vpcProps.hashCode() : 0);
            return result;
        }
    }
}
