/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awsconstructs.services.lambdakinesisstreams;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.services.cloudwatch.Alarm;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.VpcProps;
import software.amazon.awscdk.services.kinesis.Stream;
import software.amazon.awscdk.services.kinesis.StreamProps;
import software.amazon.awscdk.services.lambda.Function;
import software.amazon.awscdk.services.lambda.FunctionProps;
import software.amazon.awsconstructs.services.lambdakinesisstreams.$Module;
import software.amazon.awsconstructs.services.lambdakinesisstreams.LambdaToKinesisStreamsProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="@aws-solutions-constructs/aws-lambda-kinesisstreams.LambdaToKinesisStreams")
public class LambdaToKinesisStreams
extends Construct {
    protected LambdaToKinesisStreams(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LambdaToKinesisStreams(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public LambdaToKinesisStreams(@NotNull Construct scope, @NotNull String id, @NotNull LambdaToKinesisStreamsProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public Stream getKinesisStream() {
        return (Stream)Kernel.get((Object)((Object)this), (String)"kinesisStream", (NativeType)NativeType.forClass(Stream.class));
    }

    @NotNull
    public Function getLambdaFunction() {
        return (Function)Kernel.get((Object)((Object)this), (String)"lambdaFunction", (NativeType)NativeType.forClass(Function.class));
    }

    @Nullable
    public List<Alarm> getCloudwatchAlarms() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"cloudwatchAlarms", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Alarm.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    @Nullable
    public IVpc getVpc() {
        return (IVpc)Kernel.get((Object)((Object)this), (String)"vpc", (NativeType)NativeType.forClass(IVpc.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<LambdaToKinesisStreams> {
        private final Construct scope;
        private final String id;
        private final LambdaToKinesisStreamsProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new LambdaToKinesisStreamsProps.Builder();
        }

        public Builder createCloudWatchAlarms(Boolean createCloudWatchAlarms) {
            this.props.createCloudWatchAlarms(createCloudWatchAlarms);
            return this;
        }

        public Builder deployVpc(Boolean deployVpc) {
            this.props.deployVpc(deployVpc);
            return this;
        }

        public Builder existingLambdaObj(Function existingLambdaObj) {
            this.props.existingLambdaObj(existingLambdaObj);
            return this;
        }

        public Builder existingStreamObj(Stream existingStreamObj) {
            this.props.existingStreamObj(existingStreamObj);
            return this;
        }

        public Builder existingVpc(IVpc existingVpc) {
            this.props.existingVpc(existingVpc);
            return this;
        }

        public Builder kinesisStreamProps(StreamProps kinesisStreamProps) {
            this.props.kinesisStreamProps(kinesisStreamProps);
            return this;
        }

        public Builder lambdaFunctionProps(FunctionProps lambdaFunctionProps) {
            this.props.lambdaFunctionProps(lambdaFunctionProps);
            return this;
        }

        public Builder streamEnvironmentVariableName(String streamEnvironmentVariableName) {
            this.props.streamEnvironmentVariableName(streamEnvironmentVariableName);
            return this;
        }

        public Builder vpcProps(VpcProps vpcProps) {
            this.props.vpcProps(vpcProps);
            return this;
        }

        public LambdaToKinesisStreams build() {
            return new LambdaToKinesisStreams(this.scope, this.id, this.props.build());
        }
    }
}

