package software.amazon.awsconstructs.services.lambdaopensearch;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-02-14T14:04:21.455Z")
@software.amazon.jsii.Jsii(module = software.amazon.awsconstructs.services.lambdaopensearch.$Module.class, fqn = "@aws-solutions-constructs/aws-lambda-opensearch.LambdaToOpenSearchProps")
@software.amazon.jsii.Jsii.Proxy(LambdaToOpenSearchProps.Jsii$Proxy.class)
public interface LambdaToOpenSearchProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Domain name for the OpenSearch Service.
     * <p>
     * Default: - None
     */
    @org.jetbrains.annotations.NotNull java.lang.String getOpenSearchDomainName();

    /**
     * Optional Amazon Cognito domain name.
     * <p>
     * If omitted the Amazon Cognito domain will default to the OpenSearch Service domain name.
     * <p>
     * Default: - the OpenSearch Service domain name
     */
    default @org.jetbrains.annotations.Nullable java.lang.String getCognitoDomainName() {
        return null;
    }

    /**
     * Whether to create recommended CloudWatch alarms.
     * <p>
     * Default: - Alarms are created
     */
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCreateCloudWatchAlarms() {
        return null;
    }

    /**
     * Whether to deploy a new VPC.
     * <p>
     * Default: - false
     */
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDeployVpc() {
        return null;
    }

    /**
     * Optional Name for the Lambda function environment variable set to the domain endpoint.
     * <p>
     * Default: - DOMAIN_ENDPOINT
     */
    default @org.jetbrains.annotations.Nullable java.lang.String getDomainEndpointEnvironmentVariableName() {
        return null;
    }

    /**
     * Existing instance of Lambda Function object, providing both this and `lambdaFunctionProps` will cause an error.
     * <p>
     * Default: - None
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.Function getExistingLambdaObj() {
        return null;
    }

    /**
     * An existing VPC for the construct to use (construct will NOT create a new VPC in this case).
     * <p>
     * Default: - None
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getExistingVpc() {
        return null;
    }

    /**
     * User provided props to override the default props for the Lambda function.
     * <p>
     * Default: - Default props are used
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.FunctionProps getLambdaFunctionProps() {
        return null;
    }

    /**
     * Optional user provided props to override the default props for the OpenSearch Service.
     * <p>
     * Default: - Default props are used
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.opensearchservice.CfnDomainProps getOpenSearchDomainProps() {
        return null;
    }

    /**
     * Properties to override default properties if deployVpc is true.
     * <p>
     * Default: - DefaultIsolatedVpcProps() in vpc-defaults.ts
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.VpcProps getVpcProps() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LambdaToOpenSearchProps}
     */
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LambdaToOpenSearchProps}
     */
    public static final class Builder implements software.amazon.jsii.Builder<LambdaToOpenSearchProps> {
        java.lang.String openSearchDomainName;
        java.lang.String cognitoDomainName;
        java.lang.Boolean createCloudWatchAlarms;
        java.lang.Boolean deployVpc;
        java.lang.String domainEndpointEnvironmentVariableName;
        software.amazon.awscdk.services.lambda.Function existingLambdaObj;
        software.amazon.awscdk.services.ec2.IVpc existingVpc;
        software.amazon.awscdk.services.lambda.FunctionProps lambdaFunctionProps;
        software.amazon.awscdk.services.opensearchservice.CfnDomainProps openSearchDomainProps;
        software.amazon.awscdk.services.ec2.VpcProps vpcProps;

        /**
         * Sets the value of {@link LambdaToOpenSearchProps#getOpenSearchDomainName}
         * @param openSearchDomainName Domain name for the OpenSearch Service. This parameter is required.
         * @return {@code this}
         */
        public Builder openSearchDomainName(java.lang.String openSearchDomainName) {
            this.openSearchDomainName = openSearchDomainName;
            return this;
        }

        /**
         * Sets the value of {@link LambdaToOpenSearchProps#getCognitoDomainName}
         * @param cognitoDomainName Optional Amazon Cognito domain name.
         *                          If omitted the Amazon Cognito domain will default to the OpenSearch Service domain name.
         * @return {@code this}
         */
        public Builder cognitoDomainName(java.lang.String cognitoDomainName) {
            this.cognitoDomainName = cognitoDomainName;
            return this;
        }

        /**
         * Sets the value of {@link LambdaToOpenSearchProps#getCreateCloudWatchAlarms}
         * @param createCloudWatchAlarms Whether to create recommended CloudWatch alarms.
         * @return {@code this}
         */
        public Builder createCloudWatchAlarms(java.lang.Boolean createCloudWatchAlarms) {
            this.createCloudWatchAlarms = createCloudWatchAlarms;
            return this;
        }

        /**
         * Sets the value of {@link LambdaToOpenSearchProps#getDeployVpc}
         * @param deployVpc Whether to deploy a new VPC.
         * @return {@code this}
         */
        public Builder deployVpc(java.lang.Boolean deployVpc) {
            this.deployVpc = deployVpc;
            return this;
        }

        /**
         * Sets the value of {@link LambdaToOpenSearchProps#getDomainEndpointEnvironmentVariableName}
         * @param domainEndpointEnvironmentVariableName Optional Name for the Lambda function environment variable set to the domain endpoint.
         * @return {@code this}
         */
        public Builder domainEndpointEnvironmentVariableName(java.lang.String domainEndpointEnvironmentVariableName) {
            this.domainEndpointEnvironmentVariableName = domainEndpointEnvironmentVariableName;
            return this;
        }

        /**
         * Sets the value of {@link LambdaToOpenSearchProps#getExistingLambdaObj}
         * @param existingLambdaObj Existing instance of Lambda Function object, providing both this and `lambdaFunctionProps` will cause an error.
         * @return {@code this}
         */
        public Builder existingLambdaObj(software.amazon.awscdk.services.lambda.Function existingLambdaObj) {
            this.existingLambdaObj = existingLambdaObj;
            return this;
        }

        /**
         * Sets the value of {@link LambdaToOpenSearchProps#getExistingVpc}
         * @param existingVpc An existing VPC for the construct to use (construct will NOT create a new VPC in this case).
         * @return {@code this}
         */
        public Builder existingVpc(software.amazon.awscdk.services.ec2.IVpc existingVpc) {
            this.existingVpc = existingVpc;
            return this;
        }

        /**
         * Sets the value of {@link LambdaToOpenSearchProps#getLambdaFunctionProps}
         * @param lambdaFunctionProps User provided props to override the default props for the Lambda function.
         * @return {@code this}
         */
        public Builder lambdaFunctionProps(software.amazon.awscdk.services.lambda.FunctionProps lambdaFunctionProps) {
            this.lambdaFunctionProps = lambdaFunctionProps;
            return this;
        }

        /**
         * Sets the value of {@link LambdaToOpenSearchProps#getOpenSearchDomainProps}
         * @param openSearchDomainProps Optional user provided props to override the default props for the OpenSearch Service.
         * @return {@code this}
         */
        public Builder openSearchDomainProps(software.amazon.awscdk.services.opensearchservice.CfnDomainProps openSearchDomainProps) {
            this.openSearchDomainProps = openSearchDomainProps;
            return this;
        }

        /**
         * Sets the value of {@link LambdaToOpenSearchProps#getVpcProps}
         * @param vpcProps Properties to override default properties if deployVpc is true.
         * @return {@code this}
         */
        public Builder vpcProps(software.amazon.awscdk.services.ec2.VpcProps vpcProps) {
            this.vpcProps = vpcProps;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LambdaToOpenSearchProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @Override
        public LambdaToOpenSearchProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LambdaToOpenSearchProps}
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaToOpenSearchProps {
        private final java.lang.String openSearchDomainName;
        private final java.lang.String cognitoDomainName;
        private final java.lang.Boolean createCloudWatchAlarms;
        private final java.lang.Boolean deployVpc;
        private final java.lang.String domainEndpointEnvironmentVariableName;
        private final software.amazon.awscdk.services.lambda.Function existingLambdaObj;
        private final software.amazon.awscdk.services.ec2.IVpc existingVpc;
        private final software.amazon.awscdk.services.lambda.FunctionProps lambdaFunctionProps;
        private final software.amazon.awscdk.services.opensearchservice.CfnDomainProps openSearchDomainProps;
        private final software.amazon.awscdk.services.ec2.VpcProps vpcProps;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.openSearchDomainName = software.amazon.jsii.Kernel.get(this, "openSearchDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cognitoDomainName = software.amazon.jsii.Kernel.get(this, "cognitoDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.createCloudWatchAlarms = software.amazon.jsii.Kernel.get(this, "createCloudWatchAlarms", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.deployVpc = software.amazon.jsii.Kernel.get(this, "deployVpc", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.domainEndpointEnvironmentVariableName = software.amazon.jsii.Kernel.get(this, "domainEndpointEnvironmentVariableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.existingLambdaObj = software.amazon.jsii.Kernel.get(this, "existingLambdaObj", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Function.class));
            this.existingVpc = software.amazon.jsii.Kernel.get(this, "existingVpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.lambdaFunctionProps = software.amazon.jsii.Kernel.get(this, "lambdaFunctionProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.FunctionProps.class));
            this.openSearchDomainProps = software.amazon.jsii.Kernel.get(this, "openSearchDomainProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.CfnDomainProps.class));
            this.vpcProps = software.amazon.jsii.Kernel.get(this, "vpcProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.VpcProps.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.openSearchDomainName = java.util.Objects.requireNonNull(builder.openSearchDomainName, "openSearchDomainName is required");
            this.cognitoDomainName = builder.cognitoDomainName;
            this.createCloudWatchAlarms = builder.createCloudWatchAlarms;
            this.deployVpc = builder.deployVpc;
            this.domainEndpointEnvironmentVariableName = builder.domainEndpointEnvironmentVariableName;
            this.existingLambdaObj = builder.existingLambdaObj;
            this.existingVpc = builder.existingVpc;
            this.lambdaFunctionProps = builder.lambdaFunctionProps;
            this.openSearchDomainProps = builder.openSearchDomainProps;
            this.vpcProps = builder.vpcProps;
        }

        @Override
        public final java.lang.String getOpenSearchDomainName() {
            return this.openSearchDomainName;
        }

        @Override
        public final java.lang.String getCognitoDomainName() {
            return this.cognitoDomainName;
        }

        @Override
        public final java.lang.Boolean getCreateCloudWatchAlarms() {
            return this.createCloudWatchAlarms;
        }

        @Override
        public final java.lang.Boolean getDeployVpc() {
            return this.deployVpc;
        }

        @Override
        public final java.lang.String getDomainEndpointEnvironmentVariableName() {
            return this.domainEndpointEnvironmentVariableName;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.Function getExistingLambdaObj() {
            return this.existingLambdaObj;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getExistingVpc() {
            return this.existingVpc;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.FunctionProps getLambdaFunctionProps() {
            return this.lambdaFunctionProps;
        }

        @Override
        public final software.amazon.awscdk.services.opensearchservice.CfnDomainProps getOpenSearchDomainProps() {
            return this.openSearchDomainProps;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.VpcProps getVpcProps() {
            return this.vpcProps;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("openSearchDomainName", om.valueToTree(this.getOpenSearchDomainName()));
            if (this.getCognitoDomainName() != null) {
                data.set("cognitoDomainName", om.valueToTree(this.getCognitoDomainName()));
            }
            if (this.getCreateCloudWatchAlarms() != null) {
                data.set("createCloudWatchAlarms", om.valueToTree(this.getCreateCloudWatchAlarms()));
            }
            if (this.getDeployVpc() != null) {
                data.set("deployVpc", om.valueToTree(this.getDeployVpc()));
            }
            if (this.getDomainEndpointEnvironmentVariableName() != null) {
                data.set("domainEndpointEnvironmentVariableName", om.valueToTree(this.getDomainEndpointEnvironmentVariableName()));
            }
            if (this.getExistingLambdaObj() != null) {
                data.set("existingLambdaObj", om.valueToTree(this.getExistingLambdaObj()));
            }
            if (this.getExistingVpc() != null) {
                data.set("existingVpc", om.valueToTree(this.getExistingVpc()));
            }
            if (this.getLambdaFunctionProps() != null) {
                data.set("lambdaFunctionProps", om.valueToTree(this.getLambdaFunctionProps()));
            }
            if (this.getOpenSearchDomainProps() != null) {
                data.set("openSearchDomainProps", om.valueToTree(this.getOpenSearchDomainProps()));
            }
            if (this.getVpcProps() != null) {
                data.set("vpcProps", om.valueToTree(this.getVpcProps()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-solutions-constructs/aws-lambda-opensearch.LambdaToOpenSearchProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LambdaToOpenSearchProps.Jsii$Proxy that = (LambdaToOpenSearchProps.Jsii$Proxy) o;

            if (!openSearchDomainName.equals(that.openSearchDomainName)) return false;
            if (this.cognitoDomainName != null ? !this.cognitoDomainName.equals(that.cognitoDomainName) : that.cognitoDomainName != null) return false;
            if (this.createCloudWatchAlarms != null ? !this.createCloudWatchAlarms.equals(that.createCloudWatchAlarms) : that.createCloudWatchAlarms != null) return false;
            if (this.deployVpc != null ? !this.deployVpc.equals(that.deployVpc) : that.deployVpc != null) return false;
            if (this.domainEndpointEnvironmentVariableName != null ? !this.domainEndpointEnvironmentVariableName.equals(that.domainEndpointEnvironmentVariableName) : that.domainEndpointEnvironmentVariableName != null) return false;
            if (this.existingLambdaObj != null ? !this.existingLambdaObj.equals(that.existingLambdaObj) : that.existingLambdaObj != null) return false;
            if (this.existingVpc != null ? !this.existingVpc.equals(that.existingVpc) : that.existingVpc != null) return false;
            if (this.lambdaFunctionProps != null ? !this.lambdaFunctionProps.equals(that.lambdaFunctionProps) : that.lambdaFunctionProps != null) return false;
            if (this.openSearchDomainProps != null ? !this.openSearchDomainProps.equals(that.openSearchDomainProps) : that.openSearchDomainProps != null) return false;
            return this.vpcProps != null ? this.vpcProps.equals(that.vpcProps) : that.vpcProps == null;
        }

        @Override
        public final int hashCode() {
            int result = this.openSearchDomainName.hashCode();
            result = 31 * result + (this.cognitoDomainName != null ? this.cognitoDomainName.hashCode() : 0);
            result = 31 * result + (this.createCloudWatchAlarms != null ? this.createCloudWatchAlarms.hashCode() : 0);
            result = 31 * result + (this.deployVpc != null ? this.deployVpc.hashCode() : 0);
            result = 31 * result + (this.domainEndpointEnvironmentVariableName != null ? this.domainEndpointEnvironmentVariableName.hashCode() : 0);
            result = 31 * result + (this.existingLambdaObj != null ? this.existingLambdaObj.hashCode() : 0);
            result = 31 * result + (this.existingVpc != null ? this.existingVpc.hashCode() : 0);
            result = 31 * result + (this.lambdaFunctionProps != null ? this.lambdaFunctionProps.hashCode() : 0);
            result = 31 * result + (this.openSearchDomainProps != null ? this.openSearchDomainProps.hashCode() : 0);
            result = 31 * result + (this.vpcProps != null ? this.vpcProps.hashCode() : 0);
            return result;
        }
    }
}
