package software.amazon.awsconstructs.services.lambdas3;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-01T20:13:04.283Z")
@software.amazon.jsii.Jsii(module = software.amazon.awsconstructs.services.lambdas3.$Module.class, fqn = "@aws-solutions-constructs/aws-lambda-s3.LambdaToS3Props")
@software.amazon.jsii.Jsii.Proxy(LambdaToS3Props.Jsii$Proxy.class)
public interface LambdaToS3Props extends software.amazon.jsii.JsiiSerializable {

    /**
     * Optional Name for the Lambda function environment variable set to the name of the bucket.
     * <p>
     * Default: - S3_BUCKET_NAME
     */
    default @org.jetbrains.annotations.Nullable java.lang.String getBucketEnvironmentVariableName() {
        return null;
    }

    /**
     * Optional bucket permissions to grant to the Lambda function.
     * <p>
     * One or more of the following may be specified: "Delete", "Put", "Read", "ReadWrite", "Write".
     * <p>
     * Default: - Read/write access is given to the Lambda function if no value is specified.
     */
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getBucketPermissions() {
        return null;
    }

    /**
     * Optional user provided props to override the default props for the S3 Bucket.
     * <p>
     * Default: - Default props are used
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.BucketProps getBucketProps() {
        return null;
    }

    /**
     * Whether to deploy a new VPC.
     * <p>
     * Default: - false
     */
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDeployVpc() {
        return null;
    }

    /**
     * Existing instance of S3 Bucket object, providing both this and `bucketProps` will cause an error.
     * <p>
     * Default: - None
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.IBucket getExistingBucketObj() {
        return null;
    }

    /**
     * Existing instance of Lambda Function object, providing both this and `lambdaFunctionProps` will cause an error.
     * <p>
     * Default: - None
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.Function getExistingLambdaObj() {
        return null;
    }

    /**
     * An existing VPC for the construct to use (construct will NOT create a new VPC in this case).
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getExistingVpc() {
        return null;
    }

    /**
     * Optional user provided props to override the default props for the Lambda function.
     * <p>
     * Default: - Default properties are used.
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.FunctionProps getLambdaFunctionProps() {
        return null;
    }

    /**
     * Optional user provided props to override the default props for the S3 Logging Bucket.
     * <p>
     * Default: - Default props are used
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.BucketProps getLoggingBucketProps() {
        return null;
    }

    /**
     * Whether to turn on Access Logs for the S3 bucket with the associated storage costs.
     * <p>
     * Enabling Access Logging is a best practice.
     * <p>
     * Default: - true
     */
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getLogS3AccessLogs() {
        return null;
    }

    /**
     * Properties to override default properties if deployVpc is true.
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.VpcProps getVpcProps() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LambdaToS3Props}
     */
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LambdaToS3Props}
     */
    public static final class Builder implements software.amazon.jsii.Builder<LambdaToS3Props> {
        java.lang.String bucketEnvironmentVariableName;
        java.util.List<java.lang.String> bucketPermissions;
        software.amazon.awscdk.services.s3.BucketProps bucketProps;
        java.lang.Boolean deployVpc;
        software.amazon.awscdk.services.s3.IBucket existingBucketObj;
        software.amazon.awscdk.services.lambda.Function existingLambdaObj;
        software.amazon.awscdk.services.ec2.IVpc existingVpc;
        software.amazon.awscdk.services.lambda.FunctionProps lambdaFunctionProps;
        software.amazon.awscdk.services.s3.BucketProps loggingBucketProps;
        java.lang.Boolean logS3AccessLogs;
        software.amazon.awscdk.services.ec2.VpcProps vpcProps;

        /**
         * Sets the value of {@link LambdaToS3Props#getBucketEnvironmentVariableName}
         * @param bucketEnvironmentVariableName Optional Name for the Lambda function environment variable set to the name of the bucket.
         * @return {@code this}
         */
        public Builder bucketEnvironmentVariableName(java.lang.String bucketEnvironmentVariableName) {
            this.bucketEnvironmentVariableName = bucketEnvironmentVariableName;
            return this;
        }

        /**
         * Sets the value of {@link LambdaToS3Props#getBucketPermissions}
         * @param bucketPermissions Optional bucket permissions to grant to the Lambda function.
         *                          One or more of the following may be specified: "Delete", "Put", "Read", "ReadWrite", "Write".
         * @return {@code this}
         */
        public Builder bucketPermissions(java.util.List<java.lang.String> bucketPermissions) {
            this.bucketPermissions = bucketPermissions;
            return this;
        }

        /**
         * Sets the value of {@link LambdaToS3Props#getBucketProps}
         * @param bucketProps Optional user provided props to override the default props for the S3 Bucket.
         * @return {@code this}
         */
        public Builder bucketProps(software.amazon.awscdk.services.s3.BucketProps bucketProps) {
            this.bucketProps = bucketProps;
            return this;
        }

        /**
         * Sets the value of {@link LambdaToS3Props#getDeployVpc}
         * @param deployVpc Whether to deploy a new VPC.
         * @return {@code this}
         */
        public Builder deployVpc(java.lang.Boolean deployVpc) {
            this.deployVpc = deployVpc;
            return this;
        }

        /**
         * Sets the value of {@link LambdaToS3Props#getExistingBucketObj}
         * @param existingBucketObj Existing instance of S3 Bucket object, providing both this and `bucketProps` will cause an error.
         * @return {@code this}
         */
        public Builder existingBucketObj(software.amazon.awscdk.services.s3.IBucket existingBucketObj) {
            this.existingBucketObj = existingBucketObj;
            return this;
        }

        /**
         * Sets the value of {@link LambdaToS3Props#getExistingLambdaObj}
         * @param existingLambdaObj Existing instance of Lambda Function object, providing both this and `lambdaFunctionProps` will cause an error.
         * @return {@code this}
         */
        public Builder existingLambdaObj(software.amazon.awscdk.services.lambda.Function existingLambdaObj) {
            this.existingLambdaObj = existingLambdaObj;
            return this;
        }

        /**
         * Sets the value of {@link LambdaToS3Props#getExistingVpc}
         * @param existingVpc An existing VPC for the construct to use (construct will NOT create a new VPC in this case).
         * @return {@code this}
         */
        public Builder existingVpc(software.amazon.awscdk.services.ec2.IVpc existingVpc) {
            this.existingVpc = existingVpc;
            return this;
        }

        /**
         * Sets the value of {@link LambdaToS3Props#getLambdaFunctionProps}
         * @param lambdaFunctionProps Optional user provided props to override the default props for the Lambda function.
         * @return {@code this}
         */
        public Builder lambdaFunctionProps(software.amazon.awscdk.services.lambda.FunctionProps lambdaFunctionProps) {
            this.lambdaFunctionProps = lambdaFunctionProps;
            return this;
        }

        /**
         * Sets the value of {@link LambdaToS3Props#getLoggingBucketProps}
         * @param loggingBucketProps Optional user provided props to override the default props for the S3 Logging Bucket.
         * @return {@code this}
         */
        public Builder loggingBucketProps(software.amazon.awscdk.services.s3.BucketProps loggingBucketProps) {
            this.loggingBucketProps = loggingBucketProps;
            return this;
        }

        /**
         * Sets the value of {@link LambdaToS3Props#getLogS3AccessLogs}
         * @param logS3AccessLogs Whether to turn on Access Logs for the S3 bucket with the associated storage costs.
         *                        Enabling Access Logging is a best practice.
         * @return {@code this}
         */
        public Builder logS3AccessLogs(java.lang.Boolean logS3AccessLogs) {
            this.logS3AccessLogs = logS3AccessLogs;
            return this;
        }

        /**
         * Sets the value of {@link LambdaToS3Props#getVpcProps}
         * @param vpcProps Properties to override default properties if deployVpc is true.
         * @return {@code this}
         */
        public Builder vpcProps(software.amazon.awscdk.services.ec2.VpcProps vpcProps) {
            this.vpcProps = vpcProps;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LambdaToS3Props}
         * @throws NullPointerException if any required attribute was not provided
         */
        @Override
        public LambdaToS3Props build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LambdaToS3Props}
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaToS3Props {
        private final java.lang.String bucketEnvironmentVariableName;
        private final java.util.List<java.lang.String> bucketPermissions;
        private final software.amazon.awscdk.services.s3.BucketProps bucketProps;
        private final java.lang.Boolean deployVpc;
        private final software.amazon.awscdk.services.s3.IBucket existingBucketObj;
        private final software.amazon.awscdk.services.lambda.Function existingLambdaObj;
        private final software.amazon.awscdk.services.ec2.IVpc existingVpc;
        private final software.amazon.awscdk.services.lambda.FunctionProps lambdaFunctionProps;
        private final software.amazon.awscdk.services.s3.BucketProps loggingBucketProps;
        private final java.lang.Boolean logS3AccessLogs;
        private final software.amazon.awscdk.services.ec2.VpcProps vpcProps;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bucketEnvironmentVariableName = software.amazon.jsii.Kernel.get(this, "bucketEnvironmentVariableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bucketPermissions = software.amazon.jsii.Kernel.get(this, "bucketPermissions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.bucketProps = software.amazon.jsii.Kernel.get(this, "bucketProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.BucketProps.class));
            this.deployVpc = software.amazon.jsii.Kernel.get(this, "deployVpc", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.existingBucketObj = software.amazon.jsii.Kernel.get(this, "existingBucketObj", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.existingLambdaObj = software.amazon.jsii.Kernel.get(this, "existingLambdaObj", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Function.class));
            this.existingVpc = software.amazon.jsii.Kernel.get(this, "existingVpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.lambdaFunctionProps = software.amazon.jsii.Kernel.get(this, "lambdaFunctionProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.FunctionProps.class));
            this.loggingBucketProps = software.amazon.jsii.Kernel.get(this, "loggingBucketProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.BucketProps.class));
            this.logS3AccessLogs = software.amazon.jsii.Kernel.get(this, "logS3AccessLogs", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.vpcProps = software.amazon.jsii.Kernel.get(this, "vpcProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.VpcProps.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucketEnvironmentVariableName = builder.bucketEnvironmentVariableName;
            this.bucketPermissions = builder.bucketPermissions;
            this.bucketProps = builder.bucketProps;
            this.deployVpc = builder.deployVpc;
            this.existingBucketObj = builder.existingBucketObj;
            this.existingLambdaObj = builder.existingLambdaObj;
            this.existingVpc = builder.existingVpc;
            this.lambdaFunctionProps = builder.lambdaFunctionProps;
            this.loggingBucketProps = builder.loggingBucketProps;
            this.logS3AccessLogs = builder.logS3AccessLogs;
            this.vpcProps = builder.vpcProps;
        }

        @Override
        public final java.lang.String getBucketEnvironmentVariableName() {
            return this.bucketEnvironmentVariableName;
        }

        @Override
        public final java.util.List<java.lang.String> getBucketPermissions() {
            return this.bucketPermissions;
        }

        @Override
        public final software.amazon.awscdk.services.s3.BucketProps getBucketProps() {
            return this.bucketProps;
        }

        @Override
        public final java.lang.Boolean getDeployVpc() {
            return this.deployVpc;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getExistingBucketObj() {
            return this.existingBucketObj;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.Function getExistingLambdaObj() {
            return this.existingLambdaObj;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getExistingVpc() {
            return this.existingVpc;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.FunctionProps getLambdaFunctionProps() {
            return this.lambdaFunctionProps;
        }

        @Override
        public final software.amazon.awscdk.services.s3.BucketProps getLoggingBucketProps() {
            return this.loggingBucketProps;
        }

        @Override
        public final java.lang.Boolean getLogS3AccessLogs() {
            return this.logS3AccessLogs;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.VpcProps getVpcProps() {
            return this.vpcProps;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBucketEnvironmentVariableName() != null) {
                data.set("bucketEnvironmentVariableName", om.valueToTree(this.getBucketEnvironmentVariableName()));
            }
            if (this.getBucketPermissions() != null) {
                data.set("bucketPermissions", om.valueToTree(this.getBucketPermissions()));
            }
            if (this.getBucketProps() != null) {
                data.set("bucketProps", om.valueToTree(this.getBucketProps()));
            }
            if (this.getDeployVpc() != null) {
                data.set("deployVpc", om.valueToTree(this.getDeployVpc()));
            }
            if (this.getExistingBucketObj() != null) {
                data.set("existingBucketObj", om.valueToTree(this.getExistingBucketObj()));
            }
            if (this.getExistingLambdaObj() != null) {
                data.set("existingLambdaObj", om.valueToTree(this.getExistingLambdaObj()));
            }
            if (this.getExistingVpc() != null) {
                data.set("existingVpc", om.valueToTree(this.getExistingVpc()));
            }
            if (this.getLambdaFunctionProps() != null) {
                data.set("lambdaFunctionProps", om.valueToTree(this.getLambdaFunctionProps()));
            }
            if (this.getLoggingBucketProps() != null) {
                data.set("loggingBucketProps", om.valueToTree(this.getLoggingBucketProps()));
            }
            if (this.getLogS3AccessLogs() != null) {
                data.set("logS3AccessLogs", om.valueToTree(this.getLogS3AccessLogs()));
            }
            if (this.getVpcProps() != null) {
                data.set("vpcProps", om.valueToTree(this.getVpcProps()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-solutions-constructs/aws-lambda-s3.LambdaToS3Props"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LambdaToS3Props.Jsii$Proxy that = (LambdaToS3Props.Jsii$Proxy) o;

            if (this.bucketEnvironmentVariableName != null ? !this.bucketEnvironmentVariableName.equals(that.bucketEnvironmentVariableName) : that.bucketEnvironmentVariableName != null) return false;
            if (this.bucketPermissions != null ? !this.bucketPermissions.equals(that.bucketPermissions) : that.bucketPermissions != null) return false;
            if (this.bucketProps != null ? !this.bucketProps.equals(that.bucketProps) : that.bucketProps != null) return false;
            if (this.deployVpc != null ? !this.deployVpc.equals(that.deployVpc) : that.deployVpc != null) return false;
            if (this.existingBucketObj != null ? !this.existingBucketObj.equals(that.existingBucketObj) : that.existingBucketObj != null) return false;
            if (this.existingLambdaObj != null ? !this.existingLambdaObj.equals(that.existingLambdaObj) : that.existingLambdaObj != null) return false;
            if (this.existingVpc != null ? !this.existingVpc.equals(that.existingVpc) : that.existingVpc != null) return false;
            if (this.lambdaFunctionProps != null ? !this.lambdaFunctionProps.equals(that.lambdaFunctionProps) : that.lambdaFunctionProps != null) return false;
            if (this.loggingBucketProps != null ? !this.loggingBucketProps.equals(that.loggingBucketProps) : that.loggingBucketProps != null) return false;
            if (this.logS3AccessLogs != null ? !this.logS3AccessLogs.equals(that.logS3AccessLogs) : that.logS3AccessLogs != null) return false;
            return this.vpcProps != null ? this.vpcProps.equals(that.vpcProps) : that.vpcProps == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bucketEnvironmentVariableName != null ? this.bucketEnvironmentVariableName.hashCode() : 0;
            result = 31 * result + (this.bucketPermissions != null ? this.bucketPermissions.hashCode() : 0);
            result = 31 * result + (this.bucketProps != null ? this.bucketProps.hashCode() : 0);
            result = 31 * result + (this.deployVpc != null ? this.deployVpc.hashCode() : 0);
            result = 31 * result + (this.existingBucketObj != null ? this.existingBucketObj.hashCode() : 0);
            result = 31 * result + (this.existingLambdaObj != null ? this.existingLambdaObj.hashCode() : 0);
            result = 31 * result + (this.existingVpc != null ? this.existingVpc.hashCode() : 0);
            result = 31 * result + (this.lambdaFunctionProps != null ? this.lambdaFunctionProps.hashCode() : 0);
            result = 31 * result + (this.loggingBucketProps != null ? this.loggingBucketProps.hashCode() : 0);
            result = 31 * result + (this.logS3AccessLogs != null ? this.logS3AccessLogs.hashCode() : 0);
            result = 31 * result + (this.vpcProps != null ? this.vpcProps.hashCode() : 0);
            return result;
        }
    }
}
