/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awsconstructs.services.s3lambda;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.services.lambda.Function;
import software.amazon.awscdk.services.lambda.FunctionProps;
import software.amazon.awscdk.services.lambda.eventsources.S3EventSourceProps;
import software.amazon.awscdk.services.s3.Bucket;
import software.amazon.awscdk.services.s3.BucketProps;
import software.amazon.awsconstructs.services.s3lambda.$Module;
import software.amazon.awsconstructs.services.s3lambda.S3ToLambdaProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=$Module.class, fqn="@aws-solutions-constructs/aws-s3-lambda.S3ToLambda")
public class S3ToLambda
extends Construct {
    protected S3ToLambda(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected S3ToLambda(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public S3ToLambda(@NotNull Construct scope, @NotNull String id, @NotNull S3ToLambdaProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public Function getLambdaFunction() {
        return (Function)this.jsiiGet("lambdaFunction", Function.class);
    }

    @NotNull
    public Bucket getS3Bucket() {
        return (Bucket)this.jsiiGet("s3Bucket", Bucket.class);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<S3ToLambda> {
        private final Construct scope;
        private final String id;
        private final S3ToLambdaProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new S3ToLambdaProps.Builder();
        }

        public Builder deployLambda(Boolean deployLambda) {
            this.props.deployLambda(deployLambda);
            return this;
        }

        public Builder bucketProps(BucketProps bucketProps) {
            this.props.bucketProps(bucketProps);
            return this;
        }

        public Builder deployBucket(Boolean deployBucket) {
            this.props.deployBucket(deployBucket);
            return this;
        }

        public Builder existingBucketObj(Bucket existingBucketObj) {
            this.props.existingBucketObj(existingBucketObj);
            return this;
        }

        public Builder existingLambdaObj(Function existingLambdaObj) {
            this.props.existingLambdaObj(existingLambdaObj);
            return this;
        }

        public Builder lambdaFunctionProps(FunctionProps lambdaFunctionProps) {
            this.props.lambdaFunctionProps(lambdaFunctionProps);
            return this;
        }

        public Builder s3EventSourceProps(S3EventSourceProps s3EventSourceProps) {
            this.props.s3EventSourceProps(s3EventSourceProps);
            return this;
        }

        public S3ToLambda build() {
            return new S3ToLambda(this.scope, this.id, this.props.build());
        }
    }
}

