/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudformation;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.retry.RetryUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONObject;
import org.json.JSONTokener;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.cloudformation.Action;
import software.amazon.cloudformation.exceptions.BaseHandlerException;
import software.amazon.cloudformation.exceptions.CfnInvalidRequestException;
import software.amazon.cloudformation.exceptions.FileScrubberException;
import software.amazon.cloudformation.exceptions.TerminalException;
import software.amazon.cloudformation.injection.CloudWatchLogsProvider;
import software.amazon.cloudformation.injection.CloudWatchProvider;
import software.amazon.cloudformation.injection.CredentialsProvider;
import software.amazon.cloudformation.injection.SessionCredentialsProvider;
import software.amazon.cloudformation.loggers.CloudWatchLogHelper;
import software.amazon.cloudformation.loggers.CloudWatchLogPublisher;
import software.amazon.cloudformation.loggers.LogFilter;
import software.amazon.cloudformation.loggers.LogPublisher;
import software.amazon.cloudformation.metrics.MetricsPublisher;
import software.amazon.cloudformation.metrics.MetricsPublisherImpl;
import software.amazon.cloudformation.proxy.AmazonWebServicesClientProxy;
import software.amazon.cloudformation.proxy.Credentials;
import software.amazon.cloudformation.proxy.DelayFactory;
import software.amazon.cloudformation.proxy.HandlerErrorCode;
import software.amazon.cloudformation.proxy.HandlerRequest;
import software.amazon.cloudformation.proxy.LoggerProxy;
import software.amazon.cloudformation.proxy.MetricsPublisherProxy;
import software.amazon.cloudformation.proxy.OperationStatus;
import software.amazon.cloudformation.proxy.ProgressEvent;
import software.amazon.cloudformation.proxy.ResourceHandlerRequest;
import software.amazon.cloudformation.proxy.WaitStrategy;
import software.amazon.cloudformation.resource.ResourceTypeSchema;
import software.amazon.cloudformation.resource.SchemaValidator;
import software.amazon.cloudformation.resource.Serializer;
import software.amazon.cloudformation.resource.Validator;
import software.amazon.cloudformation.resource.exceptions.ValidationException;

public abstract class AbstractWrapper<ResourceT, CallbackT, ConfigurationT> {
    public static final SdkHttpClient HTTP_CLIENT = ApacheHttpClient.builder().build();
    private static final Set<Action> MUTATING_ACTIONS = ImmutableSet.of((Object)((Object)Action.CREATE), (Object)((Object)Action.DELETE), (Object)((Object)Action.UPDATE));
    private static final Set<Action> VALIDATING_ACTIONS = ImmutableSet.of((Object)((Object)Action.CREATE), (Object)((Object)Action.UPDATE));
    protected final Serializer serializer;
    protected LoggerProxy loggerProxy;
    protected MetricsPublisherProxy metricsPublisherProxy;
    protected LoggerProxy platformLoggerProxy;
    protected LogPublisher platformLogPublisher;
    protected final CredentialsProvider providerCredentialsProvider;
    protected final CloudWatchProvider providerCloudWatchProvider;
    protected final CloudWatchLogsProvider cloudWatchLogsProvider;
    protected final SchemaValidator validator;
    protected final TypeReference<HandlerRequest<ResourceT, CallbackT, ConfigurationT>> typeReference;
    protected MetricsPublisher providerMetricsPublisher;
    protected CloudWatchLogHelper cloudWatchLogHelper;
    protected CloudWatchLogPublisher providerEventsLogger;

    protected AbstractWrapper() {
        this.providerCredentialsProvider = new SessionCredentialsProvider();
        this.providerCloudWatchProvider = new CloudWatchProvider(this.providerCredentialsProvider, HTTP_CLIENT);
        this.cloudWatchLogsProvider = new CloudWatchLogsProvider(this.providerCredentialsProvider, HTTP_CLIENT);
        this.serializer = new Serializer();
        this.validator = new Validator();
        this.typeReference = this.getTypeReference();
        this.platformLoggerProxy = new LoggerProxy();
    }

    public AbstractWrapper(CredentialsProvider providerCredentialsProvider, LogPublisher platformEventsLogger, CloudWatchLogPublisher providerEventsLogger, MetricsPublisher providerMetricsPublisher, SchemaValidator validator, Serializer serializer, SdkHttpClient httpClient) {
        this.providerCredentialsProvider = providerCredentialsProvider;
        this.providerCloudWatchProvider = new CloudWatchProvider(this.providerCredentialsProvider, httpClient);
        this.cloudWatchLogsProvider = new CloudWatchLogsProvider(this.providerCredentialsProvider, httpClient);
        this.platformLogPublisher = platformEventsLogger;
        this.providerEventsLogger = providerEventsLogger;
        this.providerMetricsPublisher = providerMetricsPublisher;
        this.serializer = serializer;
        this.validator = validator;
        this.typeReference = this.getTypeReference();
        this.platformLoggerProxy = new LoggerProxy();
    }

    private void initialiseRuntime(String resourceType, Credentials providerCredentials, String providerLogGroupName) {
        this.metricsPublisherProxy = new MetricsPublisherProxy();
        this.loggerProxy = new LoggerProxy();
        this.loggerProxy.addLogPublisher(this.platformLogPublisher);
        if (providerCredentials != null) {
            if (this.providerCredentialsProvider != null) {
                this.providerCredentialsProvider.setCredentials(providerCredentials);
            }
            if (this.providerMetricsPublisher == null) {
                this.providerMetricsPublisher = new MetricsPublisherImpl(this.providerCloudWatchProvider, this.loggerProxy, resourceType);
            }
            this.metricsPublisherProxy.addMetricsPublisher(this.providerMetricsPublisher);
            this.providerMetricsPublisher.refreshClient();
            if (this.providerEventsLogger == null) {
                this.cloudWatchLogHelper = new CloudWatchLogHelper(this.cloudWatchLogsProvider, providerLogGroupName, this.platformLoggerProxy, this.metricsPublisherProxy);
                this.cloudWatchLogHelper.refreshClient();
                this.providerEventsLogger = new CloudWatchLogPublisher(this.cloudWatchLogsProvider, providerLogGroupName, this.cloudWatchLogHelper.prepareLogStream(), this.platformLoggerProxy, this.metricsPublisherProxy, new LogFilter[0]);
            }
            this.loggerProxy.addLogPublisher(this.providerEventsLogger);
            this.providerEventsLogger.refreshClient();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void processRequest(InputStream inputStream, OutputStream outputStream) throws IOException, TerminalException {
        ProgressEvent handlerResponse = null;
        HandlerRequest<ResourceT, CallbackT, ConfigurationT> request = null;
        this.scrubFiles();
        try {
            if (inputStream == null) {
                throw new TerminalException("No request object received");
            }
            String input = this.serializer.decompress(IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
            JSONObject rawInput = new JSONObject(new JSONTokener(input));
            try {
                request = this.serializer.deserialize(input, this.typeReference);
                handlerResponse = this.processInvocation(rawInput, request);
            }
            catch (MismatchedInputException e) {
                JSONObject resourceSchemaJSONObject = this.provideResourceSchemaJSONObject();
                JSONObject rawModelObject = rawInput.getJSONObject("requestData").getJSONObject("resourceProperties");
                this.validator.validateObject(rawModelObject, resourceSchemaJSONObject);
                handlerResponse = ProgressEvent.defaultFailureHandler(new CfnInvalidRequestException("Resource properties validation failed with invalid configuration", e), HandlerErrorCode.InvalidRequest);
            }
        }
        catch (ValidationException e) {
            String fullExceptionMessage = ValidationException.buildFullExceptionMessage((ValidationException)e);
            String message = !StringUtils.isEmpty((CharSequence)fullExceptionMessage) ? String.format("Model validation failed (%s)", fullExceptionMessage) : "Model validation failed with unknown cause.";
            this.publishExceptionMetric(request == null ? null : request.getAction(), e, HandlerErrorCode.InvalidRequest);
            handlerResponse = ProgressEvent.defaultFailureHandler(new TerminalException(message, e), HandlerErrorCode.InvalidRequest);
            this.writeResponse(outputStream, handlerResponse);
            this.publishExceptionCodeAndCountMetrics(request == null ? null : request.getAction(), handlerResponse.getErrorCode());
        }
        catch (Throwable e2) {
            block10: {
                this.log(ExceptionUtils.getStackTrace((Throwable)e2));
                handlerResponse = ProgressEvent.defaultFailureHandler(e2, HandlerErrorCode.InternalFailure);
                if (request != null && request.getRequestData() != null && MUTATING_ACTIONS.contains((Object)request.getAction())) {
                    handlerResponse.setResourceModel(request.getRequestData().getResourceProperties());
                }
                if (request == null) break block10;
                this.publishExceptionMetric(request.getAction(), e2, HandlerErrorCode.InternalFailure);
                {
                    catch (Throwable throwable) {
                        this.writeResponse(outputStream, handlerResponse);
                        this.publishExceptionCodeAndCountMetrics(request == null ? null : request.getAction(), handlerResponse.getErrorCode());
                        throw throwable;
                    }
                }
            }
            this.writeResponse(outputStream, handlerResponse);
            this.publishExceptionCodeAndCountMetrics(request == null ? null : request.getAction(), handlerResponse.getErrorCode());
        }
        this.writeResponse(outputStream, handlerResponse);
        this.publishExceptionCodeAndCountMetrics(request == null ? null : request.getAction(), handlerResponse.getErrorCode());
    }

    private ProgressEvent<ResourceT, CallbackT> processInvocation(JSONObject rawRequest, HandlerRequest<ResourceT, CallbackT, ConfigurationT> request) throws IOException, TerminalException {
        ProgressEvent<ResourceT, CallbackT> handlerResponse;
        boolean shouldValidate;
        assert (request != null) : "Invalid request object received";
        if (request.getRequestData() == null) {
            throw new TerminalException("Invalid request object received");
        }
        boolean isMutatingAction = MUTATING_ACTIONS.contains((Object)request.getAction());
        if (isMutatingAction && request.getRequestData().getResourceProperties() == null) {
            throw new TerminalException("Invalid resource properties object received");
        }
        this.initialiseRuntime(request.getResourceType(), request.getRequestData().getProviderCredentials(), request.getRequestData().getProviderLogGroupName());
        ResourceHandlerRequest<ResourceT> resourceHandlerRequest = this.transform(request);
        ConfigurationT typeConfiguration = request.getRequestData().getTypeConfiguration();
        if (resourceHandlerRequest != null) {
            resourceHandlerRequest.setPreviousResourceTags(this.getPreviousResourceTags(request));
            resourceHandlerRequest.setStackId(this.getStackId(request));
            resourceHandlerRequest.setSnapshotRequested(request.getSnapshotRequested());
            resourceHandlerRequest.setRollback(request.getRollback());
            resourceHandlerRequest.setDriftable(request.getDriftable());
            resourceHandlerRequest.setFeatures(request.getFeatures());
            if (request.getRequestData() != null) {
                resourceHandlerRequest.setPreviousSystemTags(request.getRequestData().getPreviousSystemTags());
            }
        }
        this.metricsPublisherProxy.publishInvocationMetric(Instant.now(), request.getAction());
        boolean bl = shouldValidate = VALIDATING_ACTIONS.contains((Object)request.getAction()) && request.getCallbackContext() == null;
        if (shouldValidate) {
            JSONObject rawModelObject = rawRequest.getJSONObject("requestData").getJSONObject("resourceProperties");
            try {
                this.validateModel(rawModelObject);
            }
            catch (ValidationException e) {
                StringBuilder validationMessageBuilder = new StringBuilder();
                if (!StringUtils.isEmpty((CharSequence)e.getMessage())) {
                    validationMessageBuilder.append(String.format("Model validation failed (%s)", e.getMessage()));
                } else {
                    validationMessageBuilder.append("Model validation failed with unknown cause.");
                }
                List es = e.getCausingExceptions();
                if (CollectionUtils.isNotEmpty((Collection)es)) {
                    for (RuntimeException cause : es) {
                        if (!(cause instanceof ValidationException)) continue;
                        validationMessageBuilder.append(String.format("%n%s (%s)", cause.getMessage(), ((ValidationException)((Object)cause)).getSchemaPointer()));
                    }
                }
                this.publishExceptionMetric(request.getAction(), e, HandlerErrorCode.InvalidRequest);
                return ProgressEvent.defaultFailureHandler(new TerminalException(validationMessageBuilder.toString(), e), HandlerErrorCode.InvalidRequest);
            }
        }
        CallbackT callbackContext = request.getCallbackContext();
        AmazonWebServicesClientProxy awsClientProxy = null;
        if (request.getRequestData().getCallerCredentials() != null) {
            awsClientProxy = new AmazonWebServicesClientProxy(this.loggerProxy, request.getRequestData().getCallerCredentials(), DelayFactory.CONSTANT_DEFAULT_DELAY_FACTORY, WaitStrategy.scheduleForCallbackStrategy());
        }
        if ((handlerResponse = this.wrapInvocationAndHandleErrors(awsClientProxy, resourceHandlerRequest, request, callbackContext, typeConfiguration)).getStatus() == OperationStatus.IN_PROGRESS && !isMutatingAction) {
            throw new TerminalException("READ and LIST handlers must return synchronously.");
        }
        return handlerResponse;
    }

    private void logUnhandledError(String errorDescription, HandlerRequest<ResourceT, CallbackT, ConfigurationT> request, Throwable e) {
        this.log(String.format("%s in a %s action on a %s: %s%n%s", new Object[]{errorDescription, request.getAction(), request.getResourceType(), e.toString(), ExceptionUtils.getStackTrace((Throwable)e)}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProgressEvent<ResourceT, CallbackT> wrapInvocationAndHandleErrors(AmazonWebServicesClientProxy awsClientProxy, ResourceHandlerRequest<ResourceT> resourceHandlerRequest, HandlerRequest<ResourceT, CallbackT, ConfigurationT> request, CallbackT callbackContext, ConfigurationT typeConfiguration) {
        Date startTime = Date.from(Instant.now());
        try {
            ProgressEvent<ResourceT, CallbackT> handlerResponse = this.invokeHandler(awsClientProxy, resourceHandlerRequest, request.getAction(), callbackContext, typeConfiguration);
            if (handlerResponse == null) {
                this.log("Handler returned null");
                throw new TerminalException("Handler failed to provide a response.");
            }
            this.log(String.format("Handler returned %s", new Object[]{handlerResponse.getStatus()}));
            ProgressEvent<ResourceT, CallbackT> progressEvent = handlerResponse;
            return progressEvent;
        }
        catch (BaseHandlerException e) {
            this.publishExceptionMetric(request.getAction(), e, e.getErrorCode());
            this.logUnhandledError(e.getMessage(), request, e);
            ProgressEvent progressEvent = ProgressEvent.defaultFailureHandler(e, e.getErrorCode());
            return progressEvent;
        }
        catch (AmazonServiceException | AwsServiceException e) {
            if (e instanceof AwsServiceException && ((AwsServiceException)e).isThrottlingException() || e instanceof AmazonServiceException && RetryUtils.isThrottlingException((AmazonServiceException)((AmazonServiceException)e))) {
                this.log(String.format("%s [%s] call throttled by downstream service", new Object[]{request.getResourceType(), request.getAction()}));
                this.publishExceptionMetric(request.getAction(), e, HandlerErrorCode.Throttling);
                ProgressEvent progressEvent = ProgressEvent.defaultFailureHandler(e, HandlerErrorCode.Throttling);
                return progressEvent;
            }
            this.publishExceptionMetric(request.getAction(), e, HandlerErrorCode.GeneralServiceException);
            this.logUnhandledError("A downstream service error occurred", request, e);
            ProgressEvent progressEvent = ProgressEvent.defaultFailureHandler(e, HandlerErrorCode.GeneralServiceException);
            return progressEvent;
        }
        catch (Throwable e) {
            this.publishExceptionMetric(request.getAction(), e, HandlerErrorCode.InternalFailure);
            this.logUnhandledError("An unknown error occurred ", request, e);
            ProgressEvent progressEvent = ProgressEvent.defaultFailureHandler(e, HandlerErrorCode.InternalFailure);
            return progressEvent;
        }
        finally {
            Date endTime = Date.from(Instant.now());
            this.metricsPublisherProxy.publishDurationMetric(Instant.now(), request.getAction(), endTime.getTime() - startTime.getTime());
        }
    }

    protected void writeResponse(OutputStream outputStream, ProgressEvent<ResourceT, CallbackT> response) throws IOException {
        if (response.getResourceModel() != null && response.getStatus() != OperationStatus.IN_PROGRESS) {
            response.setResourceModel(this.sanitizeModel(response.getResourceModel()));
        }
        String output = this.serializer.serialize(response);
        outputStream.write(output.getBytes(StandardCharsets.UTF_8));
        outputStream.flush();
    }

    protected ResourceT sanitizeModel(ResourceT model) throws IOException {
        JSONObject modelObject = new JSONObject(this.serializer.serialize(model));
        ResourceTypeSchema.load((JSONObject)this.provideResourceSchemaJSONObject()).removeWriteOnlyProperties(modelObject);
        return this.serializer.deserializeStrict(modelObject.toString(), this.getModelTypeReference());
    }

    private void validateModel(JSONObject modelObject) throws ValidationException, IOException {
        ResourceT deserializedModel;
        JSONObject resourceSchemaJSONObject = this.provideResourceSchemaJSONObject();
        if (resourceSchemaJSONObject == null) {
            throw new TerminalException("Unable to validate incoming model as no schema was provided.");
        }
        TypeReference<ResourceT> modelTypeReference = this.getModelTypeReference();
        try {
            deserializedModel = this.serializer.deserializeStrict(modelObject.toString(), modelTypeReference);
        }
        catch (UnrecognizedPropertyException e) {
            throw new ValidationException(String.format("#: extraneous key [%s] is not permitted", e.getPropertyName()), "additionalProperties", "#");
        }
        JSONObject serializedModel = new JSONObject(this.serializer.serialize(deserializedModel));
        this.validator.validateObject(serializedModel, resourceSchemaJSONObject);
    }

    protected abstract ResourceHandlerRequest<ResourceT> transform(HandlerRequest<ResourceT, CallbackT, ConfigurationT> var1) throws IOException;

    protected abstract JSONObject provideResourceSchemaJSONObject();

    protected abstract Map<String, String> provideResourceDefinedTags(ResourceT var1);

    public abstract ProgressEvent<ResourceT, CallbackT> invokeHandler(AmazonWebServicesClientProxy var1, ResourceHandlerRequest<ResourceT> var2, Action var3, CallbackT var4, ConfigurationT var5) throws Exception;

    private void publishExceptionMetric(Action action, Throwable ex, HandlerErrorCode handlerErrorCode) {
        if (this.metricsPublisherProxy != null) {
            this.metricsPublisherProxy.publishExceptionMetric(Instant.now(), action, ex, handlerErrorCode);
        } else {
            this.platformLoggerProxy.log(ex.toString());
        }
    }

    private void publishExceptionCodeAndCountMetrics(Action action, HandlerErrorCode handlerErrorCode) {
        if (this.metricsPublisherProxy != null) {
            this.metricsPublisherProxy.publishExceptionByErrorCodeAndCountBulkMetrics(Instant.now(), action, handlerErrorCode);
        }
    }

    private void log(String message) {
        if (this.loggerProxy != null) {
            this.loggerProxy.log(String.format("%s%n", message));
        } else {
            this.platformLoggerProxy.log(message);
        }
    }

    protected abstract TypeReference<HandlerRequest<ResourceT, CallbackT, ConfigurationT>> getTypeReference();

    protected abstract TypeReference<ResourceT> getModelTypeReference();

    protected void scrubFiles() {
        try {
            FileUtils.cleanDirectory((File)FileUtils.getTempDirectory());
        }
        catch (IOException e) {
            this.log(e.getMessage());
            this.publishExceptionMetric(null, new FileScrubberException(e), HandlerErrorCode.InternalFailure);
        }
    }

    @VisibleForTesting
    protected Map<String, String> getDesiredResourceTags(HandlerRequest<ResourceT, CallbackT, ConfigurationT> request) {
        HashMap<String, String> desiredResourceTags = new HashMap<String, String>();
        if (request != null && request.getRequestData() != null) {
            this.replaceInMap(desiredResourceTags, request.getRequestData().getStackTags());
            this.replaceInMap(desiredResourceTags, this.provideResourceDefinedTags(request.getRequestData().getResourceProperties()));
        }
        return desiredResourceTags;
    }

    @VisibleForTesting
    protected Map<String, String> getPreviousResourceTags(HandlerRequest<ResourceT, CallbackT, ConfigurationT> request) {
        HashMap<String, String> previousResourceTags = new HashMap<String, String>();
        if (request != null && request.getRequestData() != null) {
            this.replaceInMap(previousResourceTags, request.getRequestData().getPreviousStackTags());
            if (request.getRequestData().getPreviousResourceProperties() != null) {
                this.replaceInMap(previousResourceTags, this.provideResourceDefinedTags(request.getRequestData().getPreviousResourceProperties()));
            }
        }
        return previousResourceTags;
    }

    @VisibleForTesting
    protected String getStackId(HandlerRequest<ResourceT, CallbackT, ConfigurationT> request) {
        if (request != null) {
            return request.getStackId();
        }
        return null;
    }

    private void replaceInMap(Map<String, String> targetMap, Map<String, String> sourceMap) {
        if (targetMap == null) {
            return;
        }
        if (sourceMap == null || sourceMap.isEmpty()) {
            return;
        }
        targetMap.putAll(sourceMap);
    }
}

