/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudformation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.cloudformation.AbstractWrapper;
import software.amazon.cloudformation.exceptions.TerminalException;
import software.amazon.cloudformation.injection.CredentialsProvider;
import software.amazon.cloudformation.loggers.CloudWatchLogPublisher;
import software.amazon.cloudformation.loggers.JavaLogPublisher;
import software.amazon.cloudformation.loggers.LogFilter;
import software.amazon.cloudformation.loggers.LogPublisher;
import software.amazon.cloudformation.metrics.MetricsPublisher;
import software.amazon.cloudformation.resource.SchemaValidator;
import software.amazon.cloudformation.resource.Serializer;

public abstract class ExecutableWrapper<ResourceT, CallbackT, ConfigurationT>
extends AbstractWrapper<ResourceT, CallbackT, ConfigurationT> {
    private Logger platformLogger = LoggerFactory.getLogger((String)"GLOBAL");

    public ExecutableWrapper() {
    }

    public ExecutableWrapper(CredentialsProvider providerCredentialsProvider, LogPublisher platformEventsLogger, CloudWatchLogPublisher providerEventsLogger, MetricsPublisher providerMetricsPublisher, SchemaValidator validator, Serializer serializer, SdkHttpClient httpClient) {
        super(providerCredentialsProvider, platformEventsLogger, providerEventsLogger, providerMetricsPublisher, validator, serializer, httpClient);
    }

    public void handleRequest(InputStream inputStream, OutputStream outputStream) throws IOException, TerminalException {
        if (this.platformLogPublisher == null) {
            this.platformLogPublisher = new JavaLogPublisher(this.platformLogger, new LogFilter[0]);
        }
        this.platformLoggerProxy.addLogPublisher(this.platformLogPublisher);
        this.processRequest(inputStream, outputStream);
        outputStream.flush();
    }
}

