/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudformation;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.cloudformation.AbstractWrapper;
import software.amazon.cloudformation.exceptions.TerminalException;
import software.amazon.cloudformation.injection.CredentialsProvider;
import software.amazon.cloudformation.loggers.CloudWatchLogPublisher;
import software.amazon.cloudformation.loggers.LambdaLogPublisher;
import software.amazon.cloudformation.loggers.LogFilter;
import software.amazon.cloudformation.loggers.LogPublisher;
import software.amazon.cloudformation.metrics.MetricsPublisher;
import software.amazon.cloudformation.resource.SchemaValidator;
import software.amazon.cloudformation.resource.Serializer;

public abstract class LambdaWrapper<ResourceT, CallbackT, ConfigurationT>
extends AbstractWrapper<ResourceT, CallbackT, ConfigurationT>
implements RequestStreamHandler {
    public LambdaWrapper() {
    }

    public LambdaWrapper(CredentialsProvider providerCredentialsProvider, LogPublisher platformEventsLogger, CloudWatchLogPublisher providerEventsLogger, MetricsPublisher providerMetricsPublisher, SchemaValidator validator, Serializer serializer, SdkHttpClient httpClient) {
        super(providerCredentialsProvider, platformEventsLogger, providerEventsLogger, providerMetricsPublisher, validator, serializer, httpClient);
    }

    public void handleRequest(InputStream inputStream, OutputStream outputStream, Context context) throws IOException, TerminalException {
        if (this.platformLogPublisher == null) {
            this.platformLogPublisher = new LambdaLogPublisher(context.getLogger(), new LogFilter[0]);
        }
        this.platformLoggerProxy.addLogPublisher(this.platformLogPublisher);
        this.processRequest(inputStream, outputStream);
        outputStream.close();
    }
}

