/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudformation.loggers;

import java.time.Instant;
import java.util.UUID;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogGroupRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogStreamRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsResponse;
import software.amazon.cloudformation.injection.CloudWatchLogsProvider;
import software.amazon.cloudformation.proxy.LoggerProxy;
import software.amazon.cloudformation.proxy.MetricsPublisherProxy;

public class CloudWatchLogHelper {
    private final CloudWatchLogsProvider cloudWatchLogsProvider;
    private CloudWatchLogsClient cloudWatchLogsClient;
    private String logGroupName;
    private LoggerProxy platformLogger;
    private MetricsPublisherProxy metricsPublisherProxy;

    public CloudWatchLogHelper(CloudWatchLogsProvider cloudWatchLogsProvider, String logGroupName, LoggerProxy platformLogger, MetricsPublisherProxy metricsPublisherProxy) {
        this.cloudWatchLogsProvider = cloudWatchLogsProvider;
        this.logGroupName = logGroupName;
        this.platformLogger = platformLogger;
        this.metricsPublisherProxy = metricsPublisherProxy;
    }

    public void refreshClient() {
        this.cloudWatchLogsClient = this.cloudWatchLogsProvider.get();
    }

    public String prepareLogStream() {
        assert (this.cloudWatchLogsClient != null) : "cloudWatchLogsClient was not initialised. You must call refreshClient() first.";
        try {
            if (!this.doesLogGroupExist()) {
                this.createLogGroup();
            }
            return this.createLogStream();
        }
        catch (Exception ex) {
            this.log("Initializing logging group setting failed with error: " + ex.toString());
            this.emitMetricsForLoggingFailure(ex);
            return null;
        }
    }

    private boolean doesLogGroupExist() {
        DescribeLogGroupsResponse response = this.cloudWatchLogsClient.describeLogGroups((DescribeLogGroupsRequest)DescribeLogGroupsRequest.builder().logGroupNamePrefix(this.logGroupName).build());
        Boolean logGroupExists = response.logGroups().stream().filter(logGroup -> logGroup.logGroupName().equals(this.logGroupName)).findAny().isPresent();
        this.log(String.format("Log group with name %s does%s exist in resource owner account.", this.logGroupName, logGroupExists != false ? "" : " not"));
        return logGroupExists;
    }

    private void createLogGroup() {
        this.log(String.format("Creating log group with name %s in resource owner account.", this.logGroupName));
        this.cloudWatchLogsClient.createLogGroup((CreateLogGroupRequest)CreateLogGroupRequest.builder().logGroupName(this.logGroupName).build());
    }

    private String createLogStream() {
        String logStreamName = UUID.randomUUID().toString();
        this.log(String.format("Creating Log stream with name %s for log group %s.", logStreamName, this.logGroupName));
        this.cloudWatchLogsClient.createLogStream((CreateLogStreamRequest)CreateLogStreamRequest.builder().logGroupName(this.logGroupName).logStreamName(logStreamName).build());
        return logStreamName;
    }

    private void log(String message) {
        if (this.platformLogger != null) {
            this.platformLogger.log(message);
        }
    }

    private void emitMetricsForLoggingFailure(Exception ex) {
        if (this.metricsPublisherProxy != null) {
            this.metricsPublisherProxy.publishProviderLogDeliveryExceptionMetric(Instant.now(), ex);
        }
    }
}

