/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudformation.loggers;

import java.time.Instant;
import java.util.Date;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.model.InputLogEvent;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutLogEventsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutLogEventsResponse;
import software.amazon.cloudformation.injection.CloudWatchLogsProvider;
import software.amazon.cloudformation.loggers.LogFilter;
import software.amazon.cloudformation.loggers.LogPublisher;
import software.amazon.cloudformation.proxy.LoggerProxy;
import software.amazon.cloudformation.proxy.MetricsPublisherProxy;

public class CloudWatchLogPublisher
extends LogPublisher {
    private final CloudWatchLogsProvider cloudWatchLogsProvider;
    private CloudWatchLogsClient cloudWatchLogsClient;
    private String logGroupName;
    private String logStreamName;
    private LoggerProxy platformLoggerProxy;
    private MetricsPublisherProxy metricsPublisherProxy;
    private String nextSequenceToken = null;

    public CloudWatchLogPublisher(CloudWatchLogsProvider cloudWatchLogsProvider, String logGroupName, String logStreamName, LoggerProxy platformLoggerProxy, MetricsPublisherProxy metricsPublisherProxy, LogFilter ... logFilters) {
        super(logFilters);
        this.cloudWatchLogsProvider = cloudWatchLogsProvider;
        this.logGroupName = logGroupName;
        this.logStreamName = logStreamName;
        this.platformLoggerProxy = platformLoggerProxy;
        this.metricsPublisherProxy = metricsPublisherProxy;
    }

    public void refreshClient() {
        this.cloudWatchLogsClient = this.cloudWatchLogsProvider.get();
    }

    @Override
    protected void publishMessage(String message) {
        try {
            if (this.skipLogging()) {
                return;
            }
            assert (this.cloudWatchLogsClient != null) : "cloudWatchLogsClient was not initialised. You must call refreshClient() first.";
            PutLogEventsResponse putLogEventsResponse = this.cloudWatchLogsClient.putLogEvents((PutLogEventsRequest)PutLogEventsRequest.builder().overrideConfiguration(builder -> {
                AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)builder.putHeader("x-amzn-logs-format", "json/emf");
            }).sequenceToken(this.nextSequenceToken).logGroupName(this.logGroupName).logStreamName(this.logStreamName).logEvents(new InputLogEvent[]{(InputLogEvent)InputLogEvent.builder().message(message).timestamp(Long.valueOf(new Date().getTime())).build()}).build());
            this.nextSequenceToken = putLogEventsResponse.nextSequenceToken();
        }
        catch (Exception ex) {
            this.platformLoggerProxy.log(String.format("An error occurred while putting log events [%s] to resource owner account, with error: %s", message, ex.toString()));
            this.emitMetricsForLoggingFailure(ex);
        }
    }

    private boolean skipLogging() {
        return this.logStreamName == null;
    }

    private void emitMetricsForLoggingFailure(Exception ex) {
        if (this.metricsPublisherProxy != null) {
            this.metricsPublisherProxy.publishProviderLogDeliveryExceptionMetric(Instant.now(), ex);
        }
    }
}

