/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudformation.metrics;

import com.google.common.collect.Sets;
import java.time.Instant;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.MetricDatum;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;
import software.amazon.cloudformation.Action;
import software.amazon.cloudformation.injection.CloudWatchProvider;
import software.amazon.cloudformation.metrics.MetricsPublisher;
import software.amazon.cloudformation.proxy.HandlerErrorCode;
import software.amazon.cloudformation.proxy.Logger;

public class MetricsPublisherImpl
extends MetricsPublisher {
    private final CloudWatchProvider cloudWatchProvider;
    private Logger loggerProxy;
    private CloudWatchClient cloudWatchClient;

    public MetricsPublisherImpl(CloudWatchProvider cloudWatchProvider, Logger loggerProxy, String resourceTypeName) {
        super(resourceTypeName);
        this.cloudWatchProvider = cloudWatchProvider;
        this.loggerProxy = loggerProxy;
    }

    @Override
    public void refreshClient() {
        this.cloudWatchClient = this.cloudWatchProvider.get();
    }

    private String getResourceTypeName() {
        return this.resourceTypeName;
    }

    @Override
    public void publishExceptionMetric(Instant timestamp, Action action, Throwable e, HandlerErrorCode handlerErrorCode) {
        this.publishBulkMetrics((MetricDatum)MetricDatum.builder().timestamp(timestamp).metricName("HandlerException").unit(StandardUnit.COUNT).value(Double.valueOf(1.0)).dimensions((Collection)Sets.newHashSet((Object[])new Dimension[]{(Dimension)Dimension.builder().name("Action").value(action == null ? "NO_ACTION" : action.name()).build(), (Dimension)Dimension.builder().name("ExceptionType").value(e.getClass().toString()).build(), (Dimension)Dimension.builder().name("ResourceType").value(this.getResourceTypeName()).build(), (Dimension)Dimension.builder().name("HandlerErrorCode").value(handlerErrorCode.name()).build()})).build());
    }

    @Override
    public void publishExceptionByErrorCodeAndCountBulkMetrics(Instant timestamp, Action action, HandlerErrorCode handlerErrorCode) {
        HashSet<Object> bulkData = new HashSet<Object>();
        EnumSet.allOf(HandlerErrorCode.class).forEach(errorCode -> bulkData.add(MetricDatum.builder().metricName("HandlerExceptionByErrorCode").unit(StandardUnit.COUNT).value(Double.valueOf(errorCode == handlerErrorCode ? 1.0 : 0.0)).dimensions((Collection)Sets.newHashSet((Object[])new Dimension[]{(Dimension)Dimension.builder().name("Action").value(action == null ? "NO_ACTION" : action.name()).build(), (Dimension)Dimension.builder().name("HandlerErrorCode").value(errorCode.name()).build()})).timestamp(timestamp).build()));
        bulkData.add(MetricDatum.builder().metricName("HandlerExceptionByExceptionCount").unit(StandardUnit.COUNT).value(Double.valueOf(handlerErrorCode == null ? 0.0 : 1.0)).dimensions(new Dimension[]{(Dimension)Dimension.builder().name("Action").value(action == null ? "NO_ACTION" : action.name()).build()}).timestamp(timestamp).build());
        this.publishBulkMetrics(bulkData.toArray(new MetricDatum[bulkData.size()]));
    }

    @Override
    public void publishProviderLogDeliveryExceptionMetric(Instant timestamp, Throwable e) {
        this.publishBulkMetrics((MetricDatum)MetricDatum.builder().metricName("HandlerException").unit(StandardUnit.COUNT).value(Double.valueOf(1.0)).dimensions((Collection)Sets.newHashSet((Object[])new Dimension[]{(Dimension)Dimension.builder().name("Action").value("ProviderLogDelivery").build(), (Dimension)Dimension.builder().name("ExceptionType").value(e.getClass().toString()).build(), (Dimension)Dimension.builder().name("ResourceType").value(this.getResourceTypeName()).build()})).timestamp(timestamp).build());
    }

    @Override
    public void publishInvocationMetric(Instant timestamp, Action action) {
        this.publishBulkMetrics((MetricDatum)MetricDatum.builder().metricName("HandlerInvocationCount").unit(StandardUnit.COUNT).value(Double.valueOf(1.0)).dimensions((Collection)Sets.newHashSet((Object[])new Dimension[]{(Dimension)Dimension.builder().name("Action").value(action == null ? "NO_ACTION" : action.name()).build(), (Dimension)Dimension.builder().name("ResourceType").value(this.getResourceTypeName()).build()})).timestamp(timestamp).build());
    }

    @Override
    public void publishDurationMetric(Instant timestamp, Action action, long milliseconds) {
        this.publishBulkMetrics((MetricDatum)MetricDatum.builder().metricName("HandlerInvocationDuration").unit(StandardUnit.MILLISECONDS).value(Double.valueOf(milliseconds)).dimensions((Collection)Sets.newHashSet((Object[])new Dimension[]{(Dimension)Dimension.builder().name("Action").value(action == null ? "NO_ACTION" : action.name()).build(), (Dimension)Dimension.builder().name("ResourceType").value(this.getResourceTypeName()).build()})).timestamp(timestamp).build());
    }

    private void publishBulkMetrics(MetricDatum ... metricData) {
        assert (this.cloudWatchClient != null) : "CloudWatchEventsClient was not initialised. You must call refreshClient() first.";
        try {
            this.cloudWatchClient.putMetricData((PutMetricDataRequest)PutMetricDataRequest.builder().namespace(String.format("%s/%s", "AWS/CloudFormation", this.resourceNamespace)).metricData(metricData).build());
        }
        catch (Exception e) {
            this.log(String.format("An error occurred while publishing metrics: %s", e.getMessage()));
        }
    }

    private void log(String message) {
        if (this.loggerProxy != null) {
            this.loggerProxy.log(String.format("%s%n", message));
        }
    }
}

