/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudformation.proxy;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicSessionCredentials;
import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.AwsRequest;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.AwsResponse;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.NonRetryableException;
import software.amazon.awssdk.core.exception.RetryableException;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.cloudformation.exceptions.BaseHandlerException;
import software.amazon.cloudformation.exceptions.TerminalException;
import software.amazon.cloudformation.proxy.CallChain;
import software.amazon.cloudformation.proxy.CallGraphNameGenerator;
import software.amazon.cloudformation.proxy.Credentials;
import software.amazon.cloudformation.proxy.Delay;
import software.amazon.cloudformation.proxy.DelayFactory;
import software.amazon.cloudformation.proxy.HandlerErrorCode;
import software.amazon.cloudformation.proxy.Logger;
import software.amazon.cloudformation.proxy.LoggerProxy;
import software.amazon.cloudformation.proxy.ProgressEvent;
import software.amazon.cloudformation.proxy.ProxyClient;
import software.amazon.cloudformation.proxy.StdCallbackContext;
import software.amazon.cloudformation.proxy.WaitStrategy;

public class AmazonWebServicesClientProxy
implements CallChain {
    public static final int HTTP_STATUS_NETWORK_AUTHN_REQUIRED = 511;
    public static final int HTTP_STATUS_GONE = 410;
    private final AWSCredentialsProvider v1CredentialsProvider;
    private final AwsCredentialsProvider v2CredentialsProvider;
    private final LoggerProxy loggerProxy;
    private final DelayFactory override;
    private final WaitStrategy waitStrategy;

    public AmazonWebServicesClientProxy(LoggerProxy loggerProxy, Credentials credentials, Supplier<Long> remainingTimeToExecute) {
        this(loggerProxy, credentials, remainingTimeToExecute, DelayFactory.CONSTANT_DEFAULT_DELAY_FACTORY);
    }

    public AmazonWebServicesClientProxy(LoggerProxy loggerProxy, Credentials credentials, Supplier<Long> remainingTimeToExecute, DelayFactory override) {
        this(loggerProxy, credentials, override, WaitStrategy.newLocalLoopAwaitStrategy(remainingTimeToExecute));
    }

    public AmazonWebServicesClientProxy(LoggerProxy loggerProxy, Credentials credentials, DelayFactory override, WaitStrategy waitStrategy) {
        this.loggerProxy = loggerProxy;
        BasicSessionCredentials basicSessionCredentials = new BasicSessionCredentials(credentials.getAccessKeyId(), credentials.getSecretAccessKey(), credentials.getSessionToken());
        this.v1CredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)basicSessionCredentials);
        AwsSessionCredentials awsSessionCredentials = AwsSessionCredentials.create((String)credentials.getAccessKeyId(), (String)credentials.getSecretAccessKey(), (String)credentials.getSessionToken());
        this.v2CredentialsProvider = StaticCredentialsProvider.create((AwsCredentials)awsSessionCredentials);
        this.override = Objects.requireNonNull(override);
        this.waitStrategy = Objects.requireNonNull(waitStrategy);
    }

    public <ClientT> ProxyClient<ClientT> newProxy(final @Nonnull Supplier<ClientT> client) {
        return new ProxyClient<ClientT>(){

            @Override
            public <RequestT extends AwsRequest, ResponseT extends AwsResponse> ResponseT injectCredentialsAndInvokeV2(RequestT request, Function<RequestT, ResponseT> requestFunction) {
                return AmazonWebServicesClientProxy.this.injectCredentialsAndInvokeV2(request, requestFunction);
            }

            @Override
            public <RequestT extends AwsRequest, ResponseT extends AwsResponse> CompletableFuture<ResponseT> injectCredentialsAndInvokeV2Async(RequestT request, Function<RequestT, CompletableFuture<ResponseT>> requestFunction) {
                return AmazonWebServicesClientProxy.this.injectCredentialsAndInvokeV2Async(request, requestFunction);
            }

            @Override
            public <RequestT extends AwsRequest, ResponseT extends AwsResponse, IterableT extends SdkIterable<ResponseT>> IterableT injectCredentialsAndInvokeIterableV2(RequestT request, Function<RequestT, IterableT> requestFunction) {
                return AmazonWebServicesClientProxy.this.injectCredentialsAndInvokeIterableV2(request, requestFunction);
            }

            @Override
            public <RequestT extends AwsRequest, ResponseT extends AwsResponse> ResponseInputStream<ResponseT> injectCredentialsAndInvokeV2InputStream(RequestT request, Function<RequestT, ResponseInputStream<ResponseT>> requestFunction) {
                return AmazonWebServicesClientProxy.this.injectCredentialsAndInvokeV2InputStream(request, requestFunction);
            }

            @Override
            public <RequestT extends AwsRequest, ResponseT extends AwsResponse> ResponseBytes<ResponseT> injectCredentialsAndInvokeV2Bytes(RequestT request, Function<RequestT, ResponseBytes<ResponseT>> requestFunction) {
                return AmazonWebServicesClientProxy.this.injectCredentialsAndInvokeV2Bytes(request, requestFunction);
            }

            @Override
            public ClientT client() {
                return client.get();
            }
        };
    }

    public <ClientT, ModelT, CallbackT extends StdCallbackContext> CallChain.Initiator<ClientT, ModelT, CallbackT> newInitiator(@Nonnull Supplier<ClientT> client, ModelT model, CallbackT context) {
        return this.newInitiator(this.newProxy(client), model, context);
    }

    @Override
    public <ClientT, ModelT, CallbackT extends StdCallbackContext> CallChain.Initiator<ClientT, ModelT, CallbackT> newInitiator(ProxyClient<ClientT> client, ModelT model, CallbackT context) {
        Preconditions.checkNotNull(client, (Object)"ProxyClient can not be null");
        Preconditions.checkNotNull(model, (Object)"Resource Model can not be null");
        Preconditions.checkNotNull(context, (Object)"cxt can not be null");
        return new StdInitiator(this, client, model, context);
    }

    @Override
    public <ClientT, ModelT, CallbackT extends StdCallbackContext> CallChain.RequestMaker<ClientT, ModelT, CallbackT> initiate(String callGraph, ProxyClient<ClientT> client, ModelT model, CallbackT cxt) {
        Preconditions.checkNotNull((Object)callGraph, (Object)"callGraph can not be null");
        Preconditions.checkNotNull(client, (Object)"ProxyClient can not be null");
        Preconditions.checkNotNull(model, (Object)"Resource Model can not be null");
        Preconditions.checkNotNull(cxt, (Object)"cxt can not be null");
        return new CallContext(this, callGraph, client, model, cxt);
    }

    public <RequestT extends AmazonWebServiceRequest, ResultT extends AmazonWebServiceResult<ResponseMetadata>> ResultT injectCredentialsAndInvoke(RequestT request, Function<RequestT, ResultT> requestFunction) {
        request.setRequestCredentialsProvider(this.v1CredentialsProvider);
        try {
            AmazonWebServiceResult response = (AmazonWebServiceResult)requestFunction.apply(request);
            this.logRequestMetadata(request, response);
            AmazonWebServiceResult amazonWebServiceResult = response;
            return (ResultT)amazonWebServiceResult;
        }
        catch (Throwable e) {
            this.loggerProxy.log(String.format("Failed to execute remote function: {%s}", e.getMessage()));
            throw e;
        }
        finally {
            request.setRequestCredentialsProvider(null);
        }
    }

    public <RequestT extends AmazonWebServiceRequest> void injectCredentialsAndInvoke(RequestT request, Consumer<RequestT> requestFunction) {
        request.setRequestCredentialsProvider(this.v1CredentialsProvider);
        try {
            requestFunction.accept(request);
        }
        catch (Throwable e) {
            this.loggerProxy.log(String.format("Failed to execute remote function: {%s}", e.getMessage()));
            throw e;
        }
        finally {
            request.setRequestCredentialsProvider(null);
        }
    }

    public <RequestT extends AwsRequest, ResultT extends AwsResponse> ResultT injectCredentialsAndInvokeV2(RequestT request, Function<RequestT, ResultT> requestFunction) {
        AwsRequestOverrideConfiguration overrideConfiguration = AwsRequestOverrideConfiguration.builder().credentialsProvider(this.v2CredentialsProvider).build();
        AwsRequest wrappedRequest = request.toBuilder().overrideConfiguration(overrideConfiguration).build();
        try {
            AwsResponse response = (AwsResponse)requestFunction.apply(wrappedRequest);
            this.logRequestMetadataV2(request, response);
            return (ResultT)response;
        }
        catch (Throwable e) {
            this.loggerProxy.log(String.format("Failed to execute remote function: {%s}", e.getMessage()));
            throw e;
        }
    }

    public <RequestT extends AwsRequest, ResultT extends AwsResponse> CompletableFuture<ResultT> injectCredentialsAndInvokeV2Async(RequestT request, Function<RequestT, CompletableFuture<ResultT>> requestFunction) {
        AwsRequestOverrideConfiguration overrideConfiguration = AwsRequestOverrideConfiguration.builder().credentialsProvider(this.v2CredentialsProvider).build();
        AwsRequest wrappedRequest = request.toBuilder().overrideConfiguration(overrideConfiguration).build();
        try {
            CompletionStage response = requestFunction.apply(wrappedRequest).thenApplyAsync(resultT -> {
                this.logRequestMetadataV2(request, resultT);
                return resultT;
            });
            return response;
        }
        catch (Throwable e) {
            this.loggerProxy.log(String.format("Failed to execute remote function: {%s}", e.getMessage()));
            throw e;
        }
    }

    public <RequestT extends AwsRequest, ResultT extends AwsResponse, IterableT extends SdkIterable<ResultT>> IterableT injectCredentialsAndInvokeIterableV2(RequestT request, Function<RequestT, IterableT> requestFunction) {
        AwsRequestOverrideConfiguration overrideConfiguration = AwsRequestOverrideConfiguration.builder().credentialsProvider(this.v2CredentialsProvider).build();
        AwsRequest wrappedRequest = request.toBuilder().overrideConfiguration(overrideConfiguration).build();
        try {
            SdkIterable response = (SdkIterable)requestFunction.apply(wrappedRequest);
            response.forEach(r -> this.logRequestMetadataV2(request, r));
            return (IterableT)response;
        }
        catch (Throwable e) {
            this.loggerProxy.log(String.format("Failed to execute remote function: {%s}", e.getMessage()));
            throw e;
        }
    }

    public <RequestT extends AwsRequest, ResultT extends AwsResponse> ResponseInputStream<ResultT> injectCredentialsAndInvokeV2InputStream(RequestT request, Function<RequestT, ResponseInputStream<ResultT>> requestFunction) {
        AwsRequestOverrideConfiguration overrideConfiguration = AwsRequestOverrideConfiguration.builder().credentialsProvider(this.v2CredentialsProvider).build();
        AwsRequest wrappedRequest = request.toBuilder().overrideConfiguration(overrideConfiguration).build();
        try {
            ResponseInputStream<ResultT> response = requestFunction.apply(wrappedRequest);
            this.logRequestMetadataV2(request, (AwsResponse)response.response());
            return response;
        }
        catch (Throwable e) {
            this.loggerProxy.log(String.format("Failed to execute remote function: {%s}", e.getMessage()));
            throw e;
        }
    }

    public <RequestT extends AwsRequest, ResultT extends AwsResponse> ResponseBytes<ResultT> injectCredentialsAndInvokeV2Bytes(RequestT request, Function<RequestT, ResponseBytes<ResultT>> requestFunction) {
        AwsRequestOverrideConfiguration overrideConfiguration = AwsRequestOverrideConfiguration.builder().credentialsProvider(this.v2CredentialsProvider).build();
        AwsRequest wrappedRequest = request.toBuilder().overrideConfiguration(overrideConfiguration).build();
        try {
            ResponseBytes<ResultT> response = requestFunction.apply(wrappedRequest);
            this.logRequestMetadataV2(request, (AwsResponse)response.response());
            return response;
        }
        catch (Throwable e) {
            this.loggerProxy.log(String.format("Failed to execute remote function: {%s}", e.getMessage()));
            throw e;
        }
    }

    public <RequestT, ClientT, ModelT, CallbackT extends StdCallbackContext> ProgressEvent<ModelT, CallbackT> defaultHandler(RequestT request, Exception e, ClientT client, ModelT model, CallbackT context) throws Exception {
        if (e instanceof NonRetryableException) {
            return ProgressEvent.failed(model, context, HandlerErrorCode.InvalidRequest, e.getMessage());
        }
        if (e instanceof AwsServiceException) {
            AwsServiceException sdkException = (AwsServiceException)((Object)e);
            AwsErrorDetails details = sdkException.awsErrorDetails();
            String errMsg = sdkException.getMessage();
            switch (details.sdkHttpResponse().statusCode()) {
                case 400: {
                    return ProgressEvent.failed(model, context, HandlerErrorCode.InvalidRequest, errMsg);
                }
                case 401: 
                case 403: 
                case 511: {
                    return ProgressEvent.failed(model, context, HandlerErrorCode.AccessDenied, errMsg);
                }
                case 404: 
                case 410: {
                    return ProgressEvent.failed(model, context, HandlerErrorCode.NotFound, errMsg);
                }
                case 429: 
                case 503: 
                case 504: {
                    this.loggerProxy.log("Retrying for error " + details.errorMessage());
                    throw RetryableException.builder().cause((Throwable)e).build();
                }
            }
            return ProgressEvent.failed(model, context, HandlerErrorCode.GeneralServiceException, errMsg);
        }
        return ProgressEvent.failed(model, context, HandlerErrorCode.InternalFailure, e.getMessage());
    }

    private <RequestT extends AmazonWebServiceRequest, ResultT extends AmazonWebServiceResult<ResponseMetadata>> void logRequestMetadata(RequestT request, ResultT response) {
        try {
            String requestName = request.getClass().getSimpleName();
            String requestId = response == null || response.getSdkResponseMetadata() == null ? "" : response.getSdkResponseMetadata().getRequestId();
            this.loggerProxy.log(String.format("{\"apiRequest\": {\"requestId\": \"%s\", \"requestName\": \"%s\"}}", requestId, requestName));
        }
        catch (Exception e) {
            this.loggerProxy.log(e.getMessage());
        }
    }

    private <RequestT extends AwsRequest, ResultT extends AwsResponse> void logRequestMetadataV2(RequestT request, ResultT response) {
        try {
            String requestName = request.getClass().getSimpleName();
            String requestId = response == null || response.responseMetadata() == null ? "" : response.responseMetadata().requestId();
            this.loggerProxy.log(String.format("{\"apiRequest\": {\"requestId\": \"%s\", \"requestName\": \"%s\"}}", requestId, requestName));
        }
        catch (Exception e) {
            this.loggerProxy.log(e.getMessage());
        }
    }

    static class CallContext<ClientT, ModelT, CallbackT extends StdCallbackContext>
    implements CallChain.RequestMaker<ClientT, ModelT, CallbackT> {
        private final String callGraph;
        private final ProxyClient<ClientT> client;
        private final ModelT model;
        private final CallbackT context;
        private Delay delay = null;
        final /* synthetic */ AmazonWebServicesClientProxy this$0;

        CallContext(String callGraph, ProxyClient<ClientT> client, ModelT model, CallbackT context) {
            this.this$0 = this$0;
            this.callGraph = (String)Preconditions.checkNotNull((Object)callGraph);
            this.client = (ProxyClient)Preconditions.checkNotNull(client);
            this.model = Preconditions.checkNotNull(model);
            this.context = context;
        }

        @Override
        public <RequestT> CallChain.Caller<RequestT, ClientT, ModelT, CallbackT> translateToServiceRequest(final Function<ModelT, RequestT> maker) {
            return new CallChain.Caller<RequestT, ClientT, ModelT, CallbackT>(){
                private final CallGraphNameGenerator<ModelT, RequestT, ClientT, CallbackT> generator = (incoming, model_, reqMaker, client_, context_) -> {
                    Object request = reqMaker.apply(model_);
                    String objectHash = String.valueOf(Objects.hashCode(request));
                    String serviceName = client_ == null ? "" : (client_ instanceof SdkClient ? ((SdkClient)client_).serviceName() : client_.getClass().getSimpleName());
                    String requestName = request != null ? request.getClass().getSimpleName().replace("Request", "") : "";
                    String callGraph = serviceName + ":" + requestName + "-" + (incoming != null ? incoming : "") + "-" + objectHash;
                    context_.request(callGraph, ignored -> request).apply(model_);
                    return callGraph;
                };

                @Override
                public CallChain.Caller<RequestT, ClientT, ModelT, CallbackT> backoffDelay(Delay delay) {
                    CallContext.this.delay = delay;
                    return this;
                }

                @Override
                public <ResponseT> CallChain.Stabilizer<RequestT, ResponseT, ClientT, ModelT, CallbackT> makeServiceCall(final BiFunction<RequestT, ProxyClient<ClientT>, ResponseT> caller) {
                    return new CallChain.Stabilizer<RequestT, ResponseT, ClientT, ModelT, CallbackT>(){
                        private CallChain.Callback<RequestT, ResponseT, ClientT, ModelT, CallbackT, Boolean> waitFor;
                        private CallChain.Callback<? super RequestT, Exception, ClientT, ModelT, CallbackT, ProgressEvent<ModelT, CallbackT>> exceptHandler;

                        @Override
                        public CallChain.Exceptional<RequestT, ResponseT, ClientT, ModelT, CallbackT> stabilize(CallChain.Callback<RequestT, ResponseT, ClientT, ModelT, CallbackT, Boolean> callback) {
                            this.waitFor = callback;
                            return this;
                        }

                        @Override
                        public CallChain.Completed<RequestT, ResponseT, ClientT, ModelT, CallbackT> retryErrorFilter(CallChain.Callback<? super RequestT, Exception, ClientT, ModelT, CallbackT, Boolean> retryFilter) {
                            return this.handleError((request, exception, client_, model_, context_) -> {
                                if (((Boolean)retryFilter.invoke(request, exception, client_, model_, context_)).booleanValue()) {
                                    throw RetryableException.builder().build();
                                }
                                return CallContext.this.this$0.defaultHandler(request, exception, client_, model_, context_);
                            });
                        }

                        @Override
                        public CallChain.Completed<RequestT, ResponseT, ClientT, ModelT, CallbackT> handleError(CallChain.ExceptionPropagate<? super RequestT, Exception, ClientT, ModelT, CallbackT, ProgressEvent<ModelT, CallbackT>> handler) {
                            this.getExceptionHandler(handler);
                            return this;
                        }

                        private CallChain.Callback<? super RequestT, Exception, ClientT, ModelT, CallbackT, ProgressEvent<ModelT, CallbackT>> getExceptionHandler(CallChain.ExceptionPropagate<? super RequestT, Exception, ClientT, ModelT, CallbackT, ProgressEvent<ModelT, CallbackT>> handler) {
                            if (this.exceptHandler == null) {
                                this.exceptHandler = (request, exception, client_, model_, context_) -> {
                                    ProgressEvent event = null;
                                    Exception ex = exception;
                                    CallChain.ExceptionPropagate inner = handler;
                                    boolean defaultHandler = false;
                                    do {
                                        try {
                                            event = (ProgressEvent)inner.invoke(request, ex, client_, model_, context_);
                                        }
                                        catch (RetryableException e) {
                                            break;
                                        }
                                        catch (Exception e) {
                                            if (defaultHandler) {
                                                throw new TerminalException("FRAMEWORK ERROR, LOOPING cause " + e, e);
                                            }
                                            defaultHandler = true;
                                            ex = e;
                                            inner = CallContext.this.this$0::defaultHandler;
                                        }
                                    } while (event == null);
                                    return event;
                                };
                            }
                            return this.exceptHandler;
                        }

                        @Override
                        public ProgressEvent<ModelT, CallbackT> done(CallChain.Callback<RequestT, ResponseT, ClientT, ModelT, CallbackT, ProgressEvent<ModelT, CallbackT>> callback) {
                            String callGraph = generator.callGraph(CallContext.this.callGraph, CallContext.this.model, maker, CallContext.this.client.client(), CallContext.this.context);
                            Delay delay = CallContext.this.this$0.override.getDelay(callGraph, CallContext.this.delay);
                            Function reqMaker = CallContext.this.context.request(callGraph, maker);
                            BiFunction resMaker = CallContext.this.context.response(callGraph, caller);
                            if (this.waitFor != null) {
                                this.waitFor = CallContext.this.context.stabilize(callGraph, this.waitFor);
                            }
                            int attempt = CallContext.this.context.attempts(callGraph);
                            Object req = null;
                            Object res = null;
                            ProgressEvent<Object, Object> event = null;
                            CallChain.Callback exceptionHandler = this.getExceptionHandler(CallContext.this.this$0::defaultHandler);
                            try {
                                while (true) {
                                    Instant now = Instant.now();
                                    try {
                                        req = req == null ? (Object)reqMaker.apply(CallContext.this.model) : req;
                                        Object ResponseT = res = res == null ? (Object)resMaker.apply(req, CallContext.this.client) : res;
                                        if (this.waitFor != null) {
                                            if (this.waitFor.invoke(req, res, CallContext.this.client, CallContext.this.model, CallContext.this.context).booleanValue()) {
                                                event = callback.invoke(req, res, CallContext.this.client, CallContext.this.model, CallContext.this.context);
                                            }
                                        } else {
                                            event = callback.invoke(req, res, CallContext.this.client, CallContext.this.model, CallContext.this.context);
                                        }
                                    }
                                    catch (BaseHandlerException e) {
                                        throw e;
                                    }
                                    catch (Exception e) {
                                        event = exceptionHandler.invoke(req, e, CallContext.this.client, CallContext.this.model, CallContext.this.context);
                                    }
                                    if (event != null) {
                                        ProgressEvent e = event;
                                        return e;
                                    }
                                    Instant opTime = Instant.now();
                                    long elapsed = ChronoUnit.MILLIS.between(now, opTime);
                                    Duration next = delay.nextDelay(attempt++);
                                    CallContext.this.context.attempts(callGraph, attempt);
                                    if (next == Duration.ZERO) {
                                        ProgressEvent<Object, StdCallbackContext> progressEvent = ProgressEvent.failed(CallContext.this.model, CallContext.this.context, HandlerErrorCode.NotStabilized, "Exceeded attempts to wait");
                                        return progressEvent;
                                    }
                                    event = CallContext.this.this$0.waitStrategy.await(elapsed, next, CallContext.this.context, CallContext.this.model);
                                    if (event == null) continue;
                                    ProgressEvent<Object, Object> progressEvent = event;
                                    return progressEvent;
                                }
                            }
                            finally {
                                if (res == null) {
                                    CallContext.this.context.evictRequestRecord(callGraph);
                                }
                            }
                        }

                        @Override
                        public ProgressEvent<ModelT, CallbackT> done(Function<ResponseT, ProgressEvent<ModelT, CallbackT>> func) {
                            return this.done((RequestT request1, ResponseT response1, ProxyClient<ClientT> client1, ModelT model1, CallbackT context1) -> (ProgressEvent)func.apply(response1));
                        }
                    };
                }
            };
        }
    }

    private static class StdInitiator<ClientT, ModelT, CallbackT extends StdCallbackContext>
    implements CallChain.Initiator<ClientT, ModelT, CallbackT> {
        private final ProxyClient<ClientT> client;
        private final ModelT model;
        private final CallbackT callback;
        final /* synthetic */ AmazonWebServicesClientProxy this$0;

        private StdInitiator(ProxyClient<ClientT> client, ModelT model, CallbackT callback) {
            this.this$0 = var1_1;
            Preconditions.checkNotNull(client, (Object)"ProxyClient can not be null");
            Preconditions.checkNotNull(model, (Object)"Resource Model can not be null");
            Preconditions.checkNotNull(callback, (Object)"cxt can not be null");
            this.client = client;
            this.model = model;
            this.callback = callback;
        }

        @Override
        public CallChain.RequestMaker<ClientT, ModelT, CallbackT> initiate(String callGraph) {
            return new CallContext(this.this$0, callGraph, this.client, this.model, this.callback);
        }

        @Override
        public <RequestT> CallChain.Caller<RequestT, ClientT, ModelT, CallbackT> translateToServiceRequest(Function<ModelT, RequestT> maker) {
            return this.initiate("").translateToServiceRequest(maker);
        }

        @Override
        public ModelT getResourceModel() {
            return this.model;
        }

        @Override
        public CallbackT getCallbackContext() {
            return this.callback;
        }

        @Override
        public <NewModelT> CallChain.Initiator<ClientT, NewModelT, CallbackT> rebindModel(NewModelT model) {
            Preconditions.checkNotNull(model, (Object)"Resource Model can not be null");
            return new StdInitiator(this.this$0, this.client, model, this.callback);
        }

        @Override
        public <NewCallbackT extends StdCallbackContext> CallChain.Initiator<ClientT, ModelT, NewCallbackT> rebindCallback(NewCallbackT callback) {
            Preconditions.checkNotNull(callback, (Object)"cxt can not be null");
            return new StdInitiator(this.this$0, this.client, this.model, callback);
        }

        @Override
        public Logger getLogger() {
            return this.this$0.loggerProxy;
        }
    }
}

