/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudformation.proxy;

import java.util.function.BiFunction;
import java.util.function.Function;
import software.amazon.cloudformation.proxy.Delay;
import software.amazon.cloudformation.proxy.Logger;
import software.amazon.cloudformation.proxy.ProgressEvent;
import software.amazon.cloudformation.proxy.ProxyClient;
import software.amazon.cloudformation.proxy.StdCallbackContext;

public interface CallChain {
    public <ClientT, ModelT, CallbackT extends StdCallbackContext> Initiator<ClientT, ModelT, CallbackT> newInitiator(ProxyClient<ClientT> var1, ModelT var2, CallbackT var3);

    public <ClientT, ModelT, CallbackT extends StdCallbackContext> RequestMaker<ClientT, ModelT, CallbackT> initiate(String var1, ProxyClient<ClientT> var2, ModelT var3, CallbackT var4);

    public static interface Completed<RequestT, ResponseT, ClientT, ModelT, CallbackT extends StdCallbackContext> {
        public ProgressEvent<ModelT, CallbackT> done(Function<ResponseT, ProgressEvent<ModelT, CallbackT>> var1);

        public ProgressEvent<ModelT, CallbackT> done(Callback<RequestT, ResponseT, ClientT, ModelT, CallbackT, ProgressEvent<ModelT, CallbackT>> var1);

        default public ProgressEvent<ModelT, CallbackT> success() {
            return this.done((RequestT request, ResponseT response, ProxyClient<ClientT> client, ModelT model, CallbackT context) -> ProgressEvent.success(model, context));
        }

        default public ProgressEvent<ModelT, CallbackT> progress() {
            return this.progress(0);
        }

        default public ProgressEvent<ModelT, CallbackT> progress(int callbackDelay) {
            return this.done((RequestT request, ResponseT response, ProxyClient<ClientT> client, ModelT model, CallbackT context) -> ProgressEvent.defaultInProgressHandler(context, callbackDelay, model));
        }
    }

    public static interface Stabilizer<RequestT, ResponseT, ClientT, ModelT, CallbackT extends StdCallbackContext>
    extends Exceptional<RequestT, ResponseT, ClientT, ModelT, CallbackT> {
        public Exceptional<RequestT, ResponseT, ClientT, ModelT, CallbackT> stabilize(Callback<RequestT, ResponseT, ClientT, ModelT, CallbackT, Boolean> var1);
    }

    @FunctionalInterface
    public static interface ExceptionPropagate<RequestT, E extends Exception, ClientT, ModelT, CallbackT extends StdCallbackContext, ReturnT> {
        public ReturnT invoke(RequestT var1, E var2, ProxyClient<ClientT> var3, ModelT var4, CallbackT var5) throws Exception;
    }

    public static interface Exceptional<RequestT, ResponseT, ClientT, ModelT, CallbackT extends StdCallbackContext>
    extends Completed<RequestT, ResponseT, ClientT, ModelT, CallbackT> {
        @Deprecated
        default public Completed<RequestT, ResponseT, ClientT, ModelT, CallbackT> exceptFilter(Callback<? super RequestT, Exception, ClientT, ModelT, CallbackT, Boolean> handler) {
            return this.retryErrorFilter(handler);
        }

        public Completed<RequestT, ResponseT, ClientT, ModelT, CallbackT> retryErrorFilter(Callback<? super RequestT, Exception, ClientT, ModelT, CallbackT, Boolean> var1);

        @Deprecated
        default public Completed<RequestT, ResponseT, ClientT, ModelT, CallbackT> exceptHandler(ExceptionPropagate<? super RequestT, Exception, ClientT, ModelT, CallbackT, ProgressEvent<ModelT, CallbackT>> handler) {
            return this.handleError(handler);
        }

        public Completed<RequestT, ResponseT, ClientT, ModelT, CallbackT> handleError(ExceptionPropagate<? super RequestT, Exception, ClientT, ModelT, CallbackT, ProgressEvent<ModelT, CallbackT>> var1);
    }

    @FunctionalInterface
    public static interface Callback<RequestT, ResponseT, ClientT, ModelT, CallbackT extends StdCallbackContext, ReturnT> {
        public ReturnT invoke(RequestT var1, ResponseT var2, ProxyClient<ClientT> var3, ModelT var4, CallbackT var5);
    }

    public static interface Caller<RequestT, ClientT, ModelT, CallbackT extends StdCallbackContext> {
        @Deprecated
        default public <ResponseT> Stabilizer<RequestT, ResponseT, ClientT, ModelT, CallbackT> call(BiFunction<RequestT, ProxyClient<ClientT>, ResponseT> caller) {
            return this.makeServiceCall(caller);
        }

        public <ResponseT> Stabilizer<RequestT, ResponseT, ClientT, ModelT, CallbackT> makeServiceCall(BiFunction<RequestT, ProxyClient<ClientT>, ResponseT> var1);

        @Deprecated
        default public Caller<RequestT, ClientT, ModelT, CallbackT> retry(Delay delay) {
            return this.backoffDelay(delay);
        }

        public Caller<RequestT, ClientT, ModelT, CallbackT> backoffDelay(Delay var1);
    }

    public static interface RequestMaker<ClientT, ModelT, CallbackT extends StdCallbackContext> {
        @Deprecated
        default public <RequestT> Caller<RequestT, ClientT, ModelT, CallbackT> request(Function<ModelT, RequestT> maker) {
            return this.translateToServiceRequest(maker);
        }

        public <RequestT> Caller<RequestT, ClientT, ModelT, CallbackT> translateToServiceRequest(Function<ModelT, RequestT> var1);
    }

    public static interface Initiator<ClientT, ModelT, CallbackT extends StdCallbackContext>
    extends RequestMaker<ClientT, ModelT, CallbackT> {
        public RequestMaker<ClientT, ModelT, CallbackT> initiate(String var1);

        public ModelT getResourceModel();

        public CallbackT getCallbackContext();

        public Logger getLogger();

        public <NewModelT> Initiator<ClientT, NewModelT, CallbackT> rebindModel(NewModelT var1);

        public <NewCallbackT extends StdCallbackContext> Initiator<ClientT, ModelT, NewCallbackT> rebindCallback(NewCallbackT var1);
    }
}

