/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudformation.proxy;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.UUID;
import org.json.JSONObject;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.model.RecordHandlerProgressRequest;
import software.amazon.awssdk.services.cloudformation.model.RecordHandlerProgressResponse;
import software.amazon.cloudformation.exceptions.TerminalException;
import software.amazon.cloudformation.injection.CloudFormationProvider;
import software.amazon.cloudformation.proxy.CallbackAdapter;
import software.amazon.cloudformation.proxy.HandlerErrorCode;
import software.amazon.cloudformation.proxy.LoggerProxy;
import software.amazon.cloudformation.proxy.OperationStatus;
import software.amazon.cloudformation.resource.ResourceTypeSchema;
import software.amazon.cloudformation.resource.Serializer;

public class CloudFormationCallbackAdapter<T>
implements CallbackAdapter<T> {
    private final CloudFormationProvider cloudFormationProvider;
    private final LoggerProxy loggerProxy;
    private CloudFormationClient client;
    private Serializer serializer;
    private ResourceTypeSchema resourceTypeSchema;

    public CloudFormationCallbackAdapter(CloudFormationProvider cloudFormationProvider, LoggerProxy loggerProxy, Serializer serializer, ResourceTypeSchema resourceTypeSchema) {
        this.cloudFormationProvider = cloudFormationProvider;
        this.loggerProxy = loggerProxy;
        this.serializer = serializer;
        this.resourceTypeSchema = resourceTypeSchema;
    }

    @Override
    public void refreshClient() {
        this.client = this.cloudFormationProvider.get();
    }

    @Override
    public void reportProgress(String bearerToken, HandlerErrorCode errorCode, OperationStatus operationStatus, OperationStatus currentOperationStatus, T resourceModel, String statusMessage) {
        assert (this.client != null) : "CloudWatchEventsClient was not initialised. You must call refreshClient() first.";
        RecordHandlerProgressRequest.Builder requestBuilder = RecordHandlerProgressRequest.builder().bearerToken(bearerToken).operationStatus(this.translate(operationStatus)).statusMessage(statusMessage).clientRequestToken(UUID.randomUUID().toString());
        if (resourceModel != null) {
            try {
                JSONObject jsonModel = new JSONObject(this.serializer.serialize(resourceModel));
                this.resourceTypeSchema.removeWriteOnlyProperties(jsonModel);
                requestBuilder.resourceModel(jsonModel.toString());
            }
            catch (JsonProcessingException e) {
                throw new TerminalException("Unable to serialize resource model for reporting progress", e);
            }
        }
        if (errorCode != null) {
            requestBuilder.errorCode(CloudFormationCallbackAdapter.translate(errorCode));
        }
        if (currentOperationStatus != null) {
            requestBuilder.currentOperationStatus(this.translate(currentOperationStatus));
        }
        RecordHandlerProgressResponse response = this.client.recordHandlerProgress((RecordHandlerProgressRequest)requestBuilder.build());
        this.loggerProxy.log(String.format("Record Handler Progress with Request Id %s and Request: {%s}", response.responseMetadata().requestId(), ((RecordHandlerProgressRequest)requestBuilder.build()).toString()));
    }

    static software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode translate(HandlerErrorCode errorCode) {
        switch (errorCode) {
            case NotUpdatable: {
                return software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.NOT_UPDATABLE;
            }
            case InvalidRequest: {
                return software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.INVALID_REQUEST;
            }
            case AccessDenied: {
                return software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.ACCESS_DENIED;
            }
            case InvalidCredentials: {
                return software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.INVALID_CREDENTIALS;
            }
            case AlreadyExists: {
                return software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.ALREADY_EXISTS;
            }
            case NotFound: {
                return software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.NOT_FOUND;
            }
            case ResourceConflict: {
                return software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.RESOURCE_CONFLICT;
            }
            case Throttling: {
                return software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.THROTTLING;
            }
            case ServiceLimitExceeded: {
                return software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.SERVICE_LIMIT_EXCEEDED;
            }
            case NotStabilized: {
                return software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.NOT_STABILIZED;
            }
            case GeneralServiceException: {
                return software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.GENERAL_SERVICE_EXCEPTION;
            }
            case ServiceInternalError: {
                return software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.SERVICE_INTERNAL_ERROR;
            }
            case NetworkFailure: {
                return software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.NETWORK_FAILURE;
            }
        }
        return software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.INTERNAL_FAILURE;
    }

    private software.amazon.awssdk.services.cloudformation.model.OperationStatus translate(OperationStatus operationStatus) {
        switch (operationStatus) {
            case SUCCESS: {
                return software.amazon.awssdk.services.cloudformation.model.OperationStatus.SUCCESS;
            }
            case FAILED: {
                return software.amazon.awssdk.services.cloudformation.model.OperationStatus.FAILED;
            }
            case IN_PROGRESS: {
                return software.amazon.awssdk.services.cloudformation.model.OperationStatus.IN_PROGRESS;
            }
            case PENDING: {
                return software.amazon.awssdk.services.cloudformation.model.OperationStatus.PENDING;
            }
        }
        return software.amazon.awssdk.services.cloudformation.model.OperationStatus.FAILED;
    }
}

