/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudformation.proxy;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import software.amazon.cloudformation.Action;
import software.amazon.cloudformation.metrics.MetricsPublisher;
import software.amazon.cloudformation.proxy.HandlerErrorCode;

public class MetricsPublisherProxy {
    private final List<MetricsPublisher> metricsPublishers = new ArrayList<MetricsPublisher>();

    public void addMetricsPublisher(MetricsPublisher metricsPublisher) {
        this.metricsPublishers.add(metricsPublisher);
    }

    public void publishExceptionMetric(Instant timestamp, Action action, Throwable e, HandlerErrorCode handlerErrorCode) {
        this.metricsPublishers.stream().forEach(metricsPublisher -> metricsPublisher.publishExceptionMetric(timestamp, action, e, handlerErrorCode));
    }

    public void publishExceptionByErrorCodeAndCountBulkMetrics(Instant timestamp, Action action, HandlerErrorCode handlerErrorCode) {
        this.metricsPublishers.stream().forEach(metricsPublisher -> metricsPublisher.publishExceptionByErrorCodeAndCountBulkMetrics(timestamp, action, handlerErrorCode));
    }

    public void publishInvocationMetric(Instant timestamp, Action action) {
        this.metricsPublishers.stream().forEach(metricsPublisher -> metricsPublisher.publishInvocationMetric(timestamp, action));
    }

    public void publishDurationMetric(Instant timestamp, Action action, long milliseconds) {
        this.metricsPublishers.stream().forEach(metricsPublisher -> metricsPublisher.publishDurationMetric(timestamp, action, milliseconds));
    }

    public void publishProviderLogDeliveryExceptionMetric(Instant timestamp, Throwable exception) {
        this.metricsPublishers.stream().forEach(metricsPublisher -> metricsPublisher.publishProviderLogDeliveryExceptionMetric(timestamp, exception));
    }
}

