/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudformation.proxy;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import software.amazon.cloudformation.proxy.HandlerErrorCode;
import software.amazon.cloudformation.proxy.OperationStatus;

public class ProgressEvent<ResourceT, CallbackT> {
    private OperationStatus status;
    private HandlerErrorCode errorCode;
    private String message;
    private CallbackT callbackContext;
    private int callbackDelaySeconds;
    private ResourceT resourceModel;
    private List<ResourceT> resourceModels;
    private String nextToken;

    public static <ResourceT, CallbackT> ProgressEvent<ResourceT, CallbackT> defaultFailureHandler(Throwable e, HandlerErrorCode handlerErrorCode) {
        return ProgressEvent.failed(null, null, handlerErrorCode, e.getMessage());
    }

    public static <ResourceT, CallbackT> ProgressEvent<ResourceT, CallbackT> failed(ResourceT model, CallbackT cxt, HandlerErrorCode code, String message) {
        ProgressEvent<ResourceT, CallbackT> event = ProgressEvent.progress(model, cxt);
        event.setStatus(OperationStatus.FAILED);
        event.setErrorCode(code);
        event.setMessage(message);
        return event;
    }

    public static <ResourceT, CallbackT> ProgressEvent<ResourceT, CallbackT> defaultInProgressHandler(CallbackT callbackContext, int callbackDelaySeconds, ResourceT resourceModel) {
        return ProgressEvent.builder().callbackContext(callbackContext).callbackDelaySeconds(callbackDelaySeconds).resourceModel(resourceModel).status(OperationStatus.IN_PROGRESS).build();
    }

    public static <ResourceT, CallbackT> ProgressEvent<ResourceT, CallbackT> progress(ResourceT model, CallbackT cxt) {
        return ProgressEvent.builder().callbackContext(cxt).resourceModel(model).status(OperationStatus.IN_PROGRESS).build();
    }

    public static <ResourceT, CallbackT> ProgressEvent<ResourceT, CallbackT> defaultSuccessHandler(ResourceT resourceModel) {
        return ProgressEvent.success(resourceModel, null);
    }

    public static <ResourceT, CallbackT> ProgressEvent<ResourceT, CallbackT> success(ResourceT model, CallbackT cxt) {
        ProgressEvent<ResourceT, CallbackT> event = ProgressEvent.progress(model, cxt);
        event.setStatus(OperationStatus.SUCCESS);
        return event;
    }

    public ProgressEvent<ResourceT, CallbackT> onSuccess(Function<ProgressEvent<ResourceT, CallbackT>, ProgressEvent<ResourceT, CallbackT>> func) {
        return this.status != null && this.status == OperationStatus.SUCCESS ? func.apply(this) : this;
    }

    @JsonIgnore
    public boolean isFailed() {
        return this.status == OperationStatus.FAILED;
    }

    @JsonIgnore
    public boolean isInProgress() {
        return this.status == OperationStatus.IN_PROGRESS;
    }

    @JsonIgnore
    public boolean canContinueProgress() {
        return this.status == OperationStatus.IN_PROGRESS && this.callbackDelaySeconds == 0;
    }

    public ProgressEvent<ResourceT, CallbackT> then(Function<ProgressEvent<ResourceT, CallbackT>, ProgressEvent<ResourceT, CallbackT>> func) {
        return this.canContinueProgress() ? func.apply(this) : this;
    }

    @JsonIgnore
    public boolean isSuccess() {
        return this.status == OperationStatus.SUCCESS;
    }

    @JsonIgnore
    public boolean isInProgressCallbackDelay() {
        return this.status == OperationStatus.IN_PROGRESS && this.callbackDelaySeconds > 0;
    }

    @Generated
    public static <ResourceT, CallbackT> ProgressEventBuilder<ResourceT, CallbackT> builder() {
        return new ProgressEventBuilder();
    }

    @Generated
    public OperationStatus getStatus() {
        return this.status;
    }

    @Generated
    public HandlerErrorCode getErrorCode() {
        return this.errorCode;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public CallbackT getCallbackContext() {
        return this.callbackContext;
    }

    @Generated
    public int getCallbackDelaySeconds() {
        return this.callbackDelaySeconds;
    }

    @Generated
    public ResourceT getResourceModel() {
        return this.resourceModel;
    }

    @Generated
    public List<ResourceT> getResourceModels() {
        return this.resourceModels;
    }

    @Generated
    public String getNextToken() {
        return this.nextToken;
    }

    @Generated
    public void setStatus(OperationStatus status) {
        this.status = status;
    }

    @Generated
    public void setErrorCode(HandlerErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setCallbackContext(CallbackT callbackContext) {
        this.callbackContext = callbackContext;
    }

    @Generated
    public void setCallbackDelaySeconds(int callbackDelaySeconds) {
        this.callbackDelaySeconds = callbackDelaySeconds;
    }

    @Generated
    public void setResourceModel(ResourceT resourceModel) {
        this.resourceModel = resourceModel;
    }

    @Generated
    public void setResourceModels(List<ResourceT> resourceModels) {
        this.resourceModels = resourceModels;
    }

    @Generated
    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProgressEvent)) {
            return false;
        }
        ProgressEvent other = (ProgressEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OperationStatus this$status = this.getStatus();
        OperationStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        HandlerErrorCode this$errorCode = this.getErrorCode();
        HandlerErrorCode other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !((Object)((Object)this$errorCode)).equals((Object)other$errorCode)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        CallbackT this$callbackContext = this.getCallbackContext();
        CallbackT other$callbackContext = other.getCallbackContext();
        if (this$callbackContext == null ? other$callbackContext != null : !this$callbackContext.equals(other$callbackContext)) {
            return false;
        }
        if (this.getCallbackDelaySeconds() != other.getCallbackDelaySeconds()) {
            return false;
        }
        ResourceT this$resourceModel = this.getResourceModel();
        ResourceT other$resourceModel = other.getResourceModel();
        if (this$resourceModel == null ? other$resourceModel != null : !this$resourceModel.equals(other$resourceModel)) {
            return false;
        }
        List<ResourceT> this$resourceModels = this.getResourceModels();
        List<ResourceT> other$resourceModels = other.getResourceModels();
        if (this$resourceModels == null ? other$resourceModels != null : !((Object)this$resourceModels).equals(other$resourceModels)) {
            return false;
        }
        String this$nextToken = this.getNextToken();
        String other$nextToken = other.getNextToken();
        return !(this$nextToken == null ? other$nextToken != null : !this$nextToken.equals(other$nextToken));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProgressEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OperationStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        HandlerErrorCode $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : ((Object)((Object)$errorCode)).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        CallbackT $callbackContext = this.getCallbackContext();
        result = result * 59 + ($callbackContext == null ? 43 : $callbackContext.hashCode());
        result = result * 59 + this.getCallbackDelaySeconds();
        ResourceT $resourceModel = this.getResourceModel();
        result = result * 59 + ($resourceModel == null ? 43 : $resourceModel.hashCode());
        List<ResourceT> $resourceModels = this.getResourceModels();
        result = result * 59 + ($resourceModels == null ? 43 : ((Object)$resourceModels).hashCode());
        String $nextToken = this.getNextToken();
        result = result * 59 + ($nextToken == null ? 43 : $nextToken.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ProgressEvent(status=" + (Object)((Object)this.getStatus()) + ", errorCode=" + (Object)((Object)this.getErrorCode()) + ", message=" + this.getMessage() + ", callbackContext=" + this.getCallbackContext() + ", callbackDelaySeconds=" + this.getCallbackDelaySeconds() + ", resourceModel=" + this.getResourceModel() + ", resourceModels=" + this.getResourceModels() + ", nextToken=" + this.getNextToken() + ")";
    }

    @Generated
    public ProgressEvent(OperationStatus status, HandlerErrorCode errorCode, String message, CallbackT callbackContext, int callbackDelaySeconds, ResourceT resourceModel, List<ResourceT> resourceModels, String nextToken) {
        this.status = status;
        this.errorCode = errorCode;
        this.message = message;
        this.callbackContext = callbackContext;
        this.callbackDelaySeconds = callbackDelaySeconds;
        this.resourceModel = resourceModel;
        this.resourceModels = resourceModels;
        this.nextToken = nextToken;
    }

    @Generated
    public ProgressEvent() {
    }

    @Generated
    public static class ProgressEventBuilder<ResourceT, CallbackT> {
        @Generated
        private OperationStatus status;
        @Generated
        private HandlerErrorCode errorCode;
        @Generated
        private String message;
        @Generated
        private CallbackT callbackContext;
        @Generated
        private int callbackDelaySeconds;
        @Generated
        private ResourceT resourceModel;
        @Generated
        private List<ResourceT> resourceModels;
        @Generated
        private String nextToken;

        @Generated
        ProgressEventBuilder() {
        }

        @Generated
        public ProgressEventBuilder<ResourceT, CallbackT> status(OperationStatus status) {
            this.status = status;
            return this;
        }

        @Generated
        public ProgressEventBuilder<ResourceT, CallbackT> errorCode(HandlerErrorCode errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Generated
        public ProgressEventBuilder<ResourceT, CallbackT> message(String message) {
            this.message = message;
            return this;
        }

        @Generated
        public ProgressEventBuilder<ResourceT, CallbackT> callbackContext(CallbackT callbackContext) {
            this.callbackContext = callbackContext;
            return this;
        }

        @Generated
        public ProgressEventBuilder<ResourceT, CallbackT> callbackDelaySeconds(int callbackDelaySeconds) {
            this.callbackDelaySeconds = callbackDelaySeconds;
            return this;
        }

        @Generated
        public ProgressEventBuilder<ResourceT, CallbackT> resourceModel(ResourceT resourceModel) {
            this.resourceModel = resourceModel;
            return this;
        }

        @Generated
        public ProgressEventBuilder<ResourceT, CallbackT> resourceModels(List<ResourceT> resourceModels) {
            this.resourceModels = resourceModels;
            return this;
        }

        @Generated
        public ProgressEventBuilder<ResourceT, CallbackT> nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Generated
        public ProgressEvent<ResourceT, CallbackT> build() {
            return new ProgressEvent<ResourceT, CallbackT>(this.status, this.errorCode, this.message, this.callbackContext, this.callbackDelaySeconds, this.resourceModel, this.resourceModels, this.nextToken);
        }

        @Generated
        public String toString() {
            return "ProgressEvent.ProgressEventBuilder(status=" + (Object)((Object)this.status) + ", errorCode=" + (Object)((Object)this.errorCode) + ", message=" + this.message + ", callbackContext=" + this.callbackContext + ", callbackDelaySeconds=" + this.callbackDelaySeconds + ", resourceModel=" + this.resourceModel + ", resourceModels=" + this.resourceModels + ", nextToken=" + this.nextToken + ")";
        }
    }
}

