/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudformation.proxy;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;
import software.amazon.cloudformation.proxy.CallChain;

@ThreadSafe
public class StdCallbackContext {
    @JsonDeserialize(using=Deserializer.class)
    @JsonSerialize(using=Serializer.class)
    private Map<String, Object> callGraphs = Collections.synchronizedMap(new LinkedHashMap(10));

    public <M, R> Function<M, R> request(String callGraph, Function<M, R> func) {
        return m -> this.callGraphs.computeIfAbsent(callGraph + ".request", ign -> func.apply(m));
    }

    public <R> R evictRequestRecord(String callGraph) {
        return (R)this.callGraphs.remove(callGraph + ".request");
    }

    public <R, C, RT> BiFunction<R, C, RT> response(String callGraph, BiFunction<R, C, RT> func) {
        return (r, c) -> this.callGraphs.computeIfAbsent(callGraph + ".response", ign -> func.apply(r, c));
    }

    public Map<String, Object> callGraphs() {
        return Collections.unmodifiableMap(this.callGraphs);
    }

    public <ResponseT> ResponseT response(String callGraph) {
        return (ResponseT)this.callGraphs.get(callGraph + ".response");
    }

    public <RequestT> RequestT findFirstRequestByContains(String contains) {
        return (RequestT)this.findFirst(key -> key.contains(contains) && key.endsWith(".request"));
    }

    public <RequestT> List<RequestT> findAllRequestByContains(String contains) {
        return this.findAll(key -> key.contains(contains) && key.endsWith(".request"));
    }

    public <ResponseT> ResponseT findFirstResponseByContains(String contains) {
        return (ResponseT)this.findFirst(key -> key.contains(contains) && key.endsWith(".response"));
    }

    public <ResponseT> List<ResponseT> findAllResponseByContains(String contains) {
        return this.findAll(key -> key.contains(contains) && key.endsWith(".response"));
    }

    Object findFirst(Predicate<String> contains) {
        Objects.requireNonNull(contains);
        return this.callGraphs.entrySet().stream().filter(e -> contains.test((String)e.getKey())).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    List<Object> findAll(Predicate<String> contains) {
        Objects.requireNonNull(contains);
        return this.callGraphs.entrySet().stream().filter(e -> contains.test((String)e.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    <RequestT, ResponseT, ClientT, ModelT, CallbackT extends StdCallbackContext> CallChain.Callback<RequestT, ResponseT, ClientT, ModelT, CallbackT, Boolean> stabilize(String callGraph, CallChain.Callback<RequestT, ResponseT, ClientT, ModelT, CallbackT, Boolean> callback) {
        return (request1, response1, client, model, context) -> {
            String key = callGraph + ".stabilize";
            Boolean result = (Boolean)this.callGraphs.getOrDefault(key, Boolean.FALSE);
            if (!result.booleanValue() && (result = (Boolean)callback.invoke(request1, response1, client, model, context)).booleanValue()) {
                this.callGraphs.put(key, Boolean.TRUE);
            }
            return result;
        };
    }

    public int attempts(String callGraph) {
        return (Integer)this.callGraphs.computeIfAbsent(callGraph + ".attempts", ign -> 1);
    }

    public void attempts(String callGraph, int attempts) {
        this.callGraphs.put(callGraph + ".attempts", attempts);
    }

    @VisibleForTesting
    void setCallGraphs(LinkedHashMap<String, Object> graphs) {
        this.callGraphs = Collections.synchronizedMap(new LinkedHashMap<String, Object>(graphs));
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StdCallbackContext)) {
            return false;
        }
        StdCallbackContext other = (StdCallbackContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Object> this$callGraphs = this.callGraphs;
        Map<String, Object> other$callGraphs = other.callGraphs;
        return !(this$callGraphs == null ? other$callGraphs != null : !((Object)this$callGraphs).equals(other$callGraphs));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StdCallbackContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Object> $callGraphs = this.callGraphs;
        result = result * 59 + ($callGraphs == null ? 43 : ((Object)$callGraphs).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "StdCallbackContext(callGraphs=" + this.callGraphs + ")";
    }

    public static class Deserializer
    extends JsonDeserializer<Map<String, Object>> {
        public Map<String, Object> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return this.readMap(LinkedHashMap.class, p, ctxt);
        }

        private Map<String, Object> readMap(Class<?> type, JsonParser p, DeserializationContext ctxt) throws IOException {
            if (!p.isExpectedStartObjectToken()) {
                throw new JsonParseException(p, "Expected start of object for Map got " + p.currentToken());
            }
            try {
                Map value = (Map)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                JsonToken next = p.nextToken();
                while (next != JsonToken.END_OBJECT) {
                    if (next != JsonToken.FIELD_NAME) {
                        throw new JsonParseException(p, "Key was not present " + next);
                    }
                    String key = p.currentName();
                    p.nextToken();
                    Object val = this.readObject(p, ctxt);
                    value.put(key, val);
                    next = p.nextToken();
                }
                return value;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new JsonMappingException((Closeable)p, "Can not create empty map for class " + type + " @ " + p.getCurrentLocation(), (Throwable)e);
            }
        }

        private Object readObject(JsonParser p, DeserializationContext ctxt) throws IOException, NoSuchMethodException, InvocationTargetException {
            Object val = null;
            JsonToken next = p.currentToken();
            switch (next) {
                case VALUE_TRUE: 
                case VALUE_FALSE: {
                    val = p.getValueAsBoolean();
                    break;
                }
                case VALUE_STRING: {
                    val = p.getText();
                    break;
                }
                case VALUE_NUMBER_FLOAT: 
                case VALUE_NUMBER_INT: {
                    val = p.getNumberValue();
                    break;
                }
                case START_ARRAY: {
                    val = this.readEncoded(p, ctxt);
                    break;
                }
                default: {
                    throw new JsonParseException(p, "Object encoding not understood " + next);
                }
            }
            return val;
        }

        private Object readEncoded(JsonParser p, DeserializationContext ctxt) throws IOException {
            if (!p.isExpectedStartArrayToken()) {
                throw new JsonParseException(p, "Expected array for encoded object got " + p.currentToken());
            }
            Object value = null;
            JsonToken next = p.nextToken();
            if (next != JsonToken.VALUE_STRING) {
                throw new JsonParseException(p, "Encoded Class value not present " + next);
            }
            String typeName = p.getText();
            p.nextToken();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = ((Object)((Object)this)).getClass().getClassLoader();
            }
            try {
                Class<?> type = loader.loadClass(typeName);
                if (Collection.class.isAssignableFrom(type)) {
                    value = this.readCollection(type, p, ctxt);
                } else if (Map.class.isAssignableFrom(type)) {
                    value = this.readMap(type, p, ctxt);
                } else {
                    JsonDeserializer deser = ctxt.findRootValueDeserializer(ctxt.constructType(type));
                    value = deser.deserialize(p, ctxt);
                }
            }
            catch (ClassNotFoundException e) {
                throw new JsonParseException(p, "Type name encoded " + typeName + " could not be loaded", (Throwable)e);
            }
            if (p.nextToken() != JsonToken.END_ARRAY) {
                throw new JsonParseException(p, "Encoded expected end of ARRAY marker " + p.currentToken());
            }
            return value;
        }

        private Object readCollection(Class<?> type, JsonParser p, DeserializationContext ctxt) throws IOException {
            if (!p.isExpectedStartArrayToken()) {
                throw new JsonParseException(p, "Expected array for encoded object got " + p.currentToken());
            }
            try {
                Collection value = (Collection)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                p.nextToken();
                do {
                    Object val = this.readObject(p, ctxt);
                    value.add(val);
                } while (p.nextToken() != JsonToken.END_ARRAY);
                return value;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IOException("Can not create empty constructor collection class " + type + " @ " + p.getCurrentLocation(), e);
            }
        }
    }

    public static class Serializer
    extends JsonSerializer<Map<String, Object>> {
        public void serialize(Map<String, Object> value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            this.writeMap(value, gen, serializers);
        }

        private void writeObject(Object val, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (val == null) {
                gen.writeNull();
                return;
            }
            if (val instanceof String || val instanceof Number || val instanceof Boolean) {
                gen.writeObject(val);
                return;
            }
            gen.writeStartArray();
            Class<?> type = val.getClass();
            gen.writeString(type.getName());
            if (val instanceof Collection) {
                this.writeCollection((Collection)val, gen, serializers);
            } else if (val instanceof Map) {
                Map map = (Map)val;
                this.writeMap(map, gen, serializers);
            } else {
                JsonSerializer serializer = serializers.findValueSerializer(type);
                serializer.serialize(val, gen, serializers);
            }
            gen.writeEndArray();
        }

        private void writeCollection(Collection<?> collection, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartArray();
            for (Object each : collection) {
                this.writeObject(each, gen, serializers);
            }
            gen.writeEndArray();
        }

        private void writeMap(Map<?, ?> value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            for (Map.Entry<?, ?> each : value.entrySet()) {
                Object key = each.getKey();
                if (!(key instanceof String)) {
                    throw new JsonGenerationException("Expected string key got " + key.getClass(), gen);
                }
                gen.writeFieldName((String)each.getKey());
                this.writeObject(each.getValue(), gen, serializers);
            }
            gen.writeEndObject();
        }
    }
}

