/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudformation.proxy;

import com.google.common.util.concurrent.Uninterruptibles;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import software.amazon.cloudformation.proxy.ProgressEvent;

public interface WaitStrategy {
    public <ModelT, CallbackT> ProgressEvent<ModelT, CallbackT> await(long var1, Duration var3, CallbackT var4, ModelT var5);

    public static WaitStrategy newLocalLoopAwaitStrategy(final Supplier<Long> remainingTimeToExecute) {
        return new WaitStrategy(){

            @Override
            public <ModelT, CallbackT> ProgressEvent<ModelT, CallbackT> await(long operationElapsedTime, Duration next, CallbackT context, ModelT model) {
                long localWait;
                long remainingTime = (Long)remainingTimeToExecute.get();
                if (remainingTime > (localWait = next.toMillis() + 2L * operationElapsedTime + 100L)) {
                    Uninterruptibles.sleepUninterruptibly((long)next.getSeconds(), (TimeUnit)TimeUnit.SECONDS);
                    return null;
                }
                return ProgressEvent.defaultInProgressHandler(context, (int)next.getSeconds(), model);
            }
        };
    }

    public static WaitStrategy scheduleForCallbackStrategy() {
        return new WaitStrategy(){

            @Override
            public <ModelT, CallbackT> ProgressEvent<ModelT, CallbackT> await(long operationElapsedTime, Duration next, CallbackT context, ModelT model) {
                return ProgressEvent.defaultInProgressHandler(context, (int)next.getSeconds(), model);
            }
        };
    }
}

