/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudformation.proxy.aws;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.ser.Serializers;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.utils.builder.SdkBuilder;
import software.amazon.cloudformation.proxy.aws.SdkPojoDeserializer;
import software.amazon.cloudformation.proxy.aws.SdkPojoSerializer;

public class AWSServiceSerdeModule
extends Module {
    public String getModuleName() {
        return "AWSServiceSerializationDeserialization";
    }

    public Version version() {
        return Version.unknownVersion();
    }

    public void setupModule(Module.SetupContext context) {
        context.addSerializers((Serializers)new AWSSerializers());
        context.addDeserializers((Deserializers)new AWSDeserializers());
    }

    public static class AWSDeserializers
    extends Deserializers.Base {
        public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
            if (SdkPojo.class.isAssignableFrom(type.getRawClass()) && !SdkBuilder.class.isAssignableFrom(type.getRawClass())) {
                return new SdkPojoDeserializer(type);
            }
            return null;
        }
    }

    public static class AWSSerializers
    extends Serializers.Base {
        public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
            if (SdkPojo.class.isAssignableFrom(type.getRawClass()) && !SdkBuilder.class.isAssignableFrom(type.getRawClass())) {
                return new SdkPojoSerializer();
            }
            return null;
        }
    }
}

