/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudformation.proxy.aws;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.utils.builder.SdkBuilder;

public class SdkPojoDeserializer
extends StdDeserializer<SdkPojo> {
    private static final long serialVersionUID = -1L;
    private final JavaType type;

    public SdkPojoDeserializer(JavaType type) {
        super(type);
        this.type = type;
    }

    public JavaType getValueType() {
        return this.type;
    }

    public SdkPojo deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        Class kclass = this.type.getRawClass();
        SdkPojo builder = this.createBuilder(p, kclass);
        return this.readPojo(builder, p, ctxt);
    }

    private SdkPojo readPojo(SdkPojo pojo, JsonParser p, DeserializationContext ctxt) throws IOException {
        if (!p.isExpectedStartObjectToken()) {
            throw new JsonMappingException((Closeable)p, "Expected to be in START_OBJECT got " + p.currentToken());
        }
        Map<String, SdkField<?>> fieldMap = this.getFields(pojo);
        JsonToken next = p.nextToken();
        ObjectMapper codec = (ObjectMapper)p.getCodec();
        while (next != JsonToken.END_OBJECT) {
            String fieldName = p.getCurrentName();
            SdkField<?> sdkField = fieldMap.get(fieldName);
            if (sdkField == null) {
                if (codec.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)) {
                    throw new JsonMappingException((Closeable)p, "Unknown property encountered " + fieldName);
                }
                next = p.nextToken();
                if (next == JsonToken.START_ARRAY || next == JsonToken.START_OBJECT) {
                    p.skipChildren();
                }
                next = p.nextToken();
                continue;
            }
            p.nextToken();
            Object value = this.readObject(sdkField, p, ctxt);
            sdkField.set((Object)pojo, value);
            next = p.nextToken();
        }
        return pojo instanceof SdkBuilder ? (SdkPojo)((SdkBuilder)pojo).build() : pojo;
    }

    private Object readObject(SdkField<?> field, JsonParser p, DeserializationContext ctxt) throws IOException {
        MarshallingType type = field.marshallingType();
        switch (p.currentToken()) {
            case VALUE_FALSE: 
            case VALUE_TRUE: {
                if (type.equals(MarshallingType.BOOLEAN)) {
                    return p.getBooleanValue();
                }
                throw new JsonMappingException((Closeable)p, "Type mismatch, expecting " + type + " got boolean field value");
            }
            case VALUE_NUMBER_FLOAT: 
            case VALUE_NUMBER_INT: {
                if (type.equals(MarshallingType.INTEGER)) {
                    return p.getIntValue();
                }
                if (type.equals(MarshallingType.LONG)) {
                    return p.getLongValue();
                }
                if (type.equals(MarshallingType.FLOAT)) {
                    return Float.valueOf(p.getFloatValue());
                }
                if (type.equals(MarshallingType.DOUBLE)) {
                    return p.getDoubleValue();
                }
                if (type.equals(MarshallingType.BIG_DECIMAL)) {
                    return p.getDecimalValue();
                }
                if (type.equals(MarshallingType.INSTANT)) {
                    JsonDeserializer deser = ctxt.findRootValueDeserializer(ctxt.constructType(Instant.class));
                    return deser.deserialize(p, ctxt);
                }
                throw new JsonMappingException((Closeable)p, "Type mismatch, expecting " + type + " got int/float/double/big_decimal/instant");
            }
            case VALUE_STRING: {
                if (type.equals(MarshallingType.STRING)) {
                    return p.getText();
                }
                if (type.equals(MarshallingType.SDK_BYTES)) {
                    byte[] bytes = p.getBinaryValue();
                    return SdkBytes.fromByteArray((byte[])bytes);
                }
                throw new JsonMappingException((Closeable)p, "Type mismatch, expecting " + type + " got string/bytes");
            }
            case START_OBJECT: {
                if (type.equals(MarshallingType.MAP)) {
                    return this.readMap(field, p, ctxt);
                }
                if (type.equals(MarshallingType.SDK_POJO)) {
                    return this.readPojo((SdkPojo)field.constructor().get(), p, ctxt);
                }
                throw new JsonMappingException((Closeable)p, "Type mismatch, expecting " + type + " got Map/SdkPojo");
            }
            case START_ARRAY: {
                if (type.equals(MarshallingType.LIST)) {
                    return this.readList(field, p, ctxt);
                }
                throw new JsonMappingException((Closeable)p, "Type mismatch, expecting " + type + " got List type");
            }
            case VALUE_NULL: {
                return null;
            }
        }
        throw new JsonMappingException((Closeable)p, "Can not map type " + type + " Token = " + p.currentToken());
    }

    private Map<String, Object> readMap(SdkField<?> field, JsonParser p, DeserializationContext ctxt) throws IOException {
        if (!p.isExpectedStartObjectToken()) {
            throw new JsonMappingException((Closeable)p, "Expected start of object token for Map got " + p.currentToken());
        }
        LinkedHashMap<String, Object> value = new LinkedHashMap<String, Object>();
        MapTrait trait = (MapTrait)field.getTrait(MapTrait.class);
        SdkField valueType = trait.valueFieldInfo();
        while (p.nextToken() != JsonToken.END_OBJECT) {
            if (p.currentToken() != JsonToken.FIELD_NAME) {
                throw new JsonMappingException((Closeable)p, "Expecting String key for map got " + p.currentToken());
            }
            String fieldName = p.getCurrentName();
            p.nextToken();
            value.put(fieldName, this.readObject(valueType, p, ctxt));
        }
        return value;
    }

    private List<Object> readList(SdkField<?> field, JsonParser p, DeserializationContext ctxt) throws IOException {
        if (!p.isExpectedStartArrayToken()) {
            throw new JsonMappingException((Closeable)p, "Expecting array start token got " + p.currentToken());
        }
        ListTrait trait = (ListTrait)field.getTrait(ListTrait.class);
        SdkField valueType = trait.memberFieldInfo();
        ArrayList<Object> value = new ArrayList<Object>();
        while (p.nextToken() != JsonToken.END_ARRAY) {
            value.add(this.readObject(valueType, p, ctxt));
        }
        return value;
    }

    public boolean isCachable() {
        return true;
    }

    private SdkPojo createBuilder(JsonParser parser, Class<? extends SdkPojo> kclass) throws IOException {
        try {
            Method method = kclass.getMethod("builder", new Class[0]);
            return (SdkPojo)method.invoke(kclass, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new JsonMappingException((Closeable)parser, "Could not create builder for SdkPojo " + kclass, (Throwable)e);
        }
    }

    private Map<String, SdkField<?>> getFields(SdkPojo pojo) {
        List sdkFields = pojo.sdkFields();
        HashMap fields = new HashMap(sdkFields.size());
        for (SdkField each : sdkFields) {
            fields.put(each.locationName(), each);
        }
        return fields;
    }

    @Generated
    public String toString() {
        return "SdkPojoDeserializer(type=" + this.type + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SdkPojoDeserializer)) {
            return false;
        }
        SdkPojoDeserializer other = (SdkPojoDeserializer)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JavaType this$type = this.type;
        JavaType other$type = other.type;
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SdkPojoDeserializer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        JavaType $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }
}

