/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudformation.proxy.aws;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import lombok.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.MapTrait;

public class SdkPojoSerializer
extends StdSerializer<SdkPojo> {
    private static final long serialVersionUID = -1L;

    public SdkPojoSerializer() {
        super(SdkPojo.class);
    }

    public void serialize(SdkPojo value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        this.writeSdkPojo(value, gen, serializers);
    }

    private void writeObject(Object value, SdkField<?> sdkField, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        MarshallingType type = sdkField.marshallingType();
        if (type.equals(MarshallingType.BOOLEAN)) {
            gen.writeBoolean(((Boolean)value).booleanValue());
        } else if (type.equals(MarshallingType.DOUBLE)) {
            gen.writeNumber(((Double)value).doubleValue());
        } else if (type.equals(MarshallingType.INTEGER)) {
            gen.writeNumber(((Integer)value).intValue());
        } else if (type.equals(MarshallingType.FLOAT)) {
            gen.writeNumber(((Float)value).floatValue());
        } else if (type.equals(MarshallingType.STRING)) {
            gen.writeString((String)value);
        } else if (type.equals(MarshallingType.BIG_DECIMAL)) {
            gen.writeNumber((BigDecimal)value);
        } else if (type.equals(MarshallingType.SDK_BYTES)) {
            gen.writeBinary(((SdkBytes)value).asByteArray());
        } else if (type.equals(MarshallingType.INSTANT)) {
            JsonSerializer serializer = serializers.findValueSerializer(Instant.class);
            serializer.serialize(value, gen, serializers);
        } else if (type.equals(MarshallingType.LONG)) {
            gen.writeNumber(((Long)value).longValue());
        } else if (type.equals(MarshallingType.SDK_POJO)) {
            this.writeSdkPojo((SdkPojo)value, gen, serializers);
        } else if (type.equals(MarshallingType.LIST)) {
            this.writeSdkList((Collection)value, sdkField, gen, serializers);
        } else if (type.equals(MarshallingType.MAP)) {
            this.writeSdkMap((Map)value, sdkField, gen, serializers);
        }
    }

    private void writeSdkPojo(SdkPojo value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value == null) {
            gen.writeNull();
            return;
        }
        JsonInclude.Value propertyInclusion = serializers.getConfig().getDefaultPropertyInclusion();
        boolean nonNull = propertyInclusion.getValueInclusion().equals((Object)JsonInclude.Include.NON_NULL);
        gen.writeStartObject();
        for (SdkField sdkField : value.sdkFields()) {
            String fieldName = sdkField.locationName();
            Object fieldValue = sdkField.getValueOrDefault((Object)value);
            if (nonNull && fieldValue == null) continue;
            gen.writeFieldName(fieldName);
            this.writeObject(fieldValue, sdkField, gen, serializers);
        }
        gen.writeEndObject();
    }

    private void writeSdkList(Collection<Object> collection, SdkField<?> sdkField, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (collection == null) {
            gen.writeNull();
            return;
        }
        gen.writeStartArray();
        ListTrait trait = (ListTrait)sdkField.getTrait(ListTrait.class);
        SdkField inner = trait.memberFieldInfo();
        for (Object each : collection) {
            this.writeObject(each, inner, gen, serializers);
        }
        gen.writeEndArray();
    }

    private void writeSdkMap(Map<String, Object> map, SdkField<?> sdkField, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (map == null) {
            gen.writeNull();
            return;
        }
        gen.writeStartObject();
        MapTrait trait = (MapTrait)sdkField.getTrait(MapTrait.class);
        SdkField valueType = trait.valueFieldInfo();
        for (Map.Entry<String, Object> each : map.entrySet()) {
            gen.writeFieldName(each.getKey());
            Object value = each.getValue();
            this.writeObject(value, valueType, gen, serializers);
        }
        gen.writeEndObject();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SdkPojoSerializer)) {
            return false;
        }
        SdkPojoSerializer other = (SdkPojoSerializer)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SdkPojoSerializer;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    public String toString() {
        return "SdkPojoSerializer()";
    }
}

