/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudformation.proxy.delay;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import software.amazon.cloudformation.proxy.Delay;
import software.amazon.cloudformation.proxy.delay.Builder;

public class Blended
implements Delay {
    private int index = 0;
    private final List<Delay> inOrder;

    private Blended(List<Delay> delays) {
        this.inOrder = delays;
    }

    public static BlendedBuilder of() {
        return new BlendedBuilder();
    }

    @Override
    public Duration nextDelay(int attempt) {
        Duration next = Duration.ZERO;
        while (this.index < this.inOrder.size() && (next = this.inOrder.get(this.index).nextDelay(attempt)) == Duration.ZERO) {
            ++this.index;
        }
        return next;
    }

    public static final class BlendedBuilder
    implements Builder<Blended> {
        private final List<Delay> inOrder = new ArrayList<Delay>();

        public BlendedBuilder add(Delay delay) {
            this.inOrder.add(delay);
            return this;
        }

        @Override
        public Blended build() {
            return new Blended(this.inOrder);
        }
    }
}

