/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudformation.proxy.delay;

import com.google.common.base.Preconditions;
import java.time.Duration;
import software.amazon.cloudformation.proxy.delay.AbstractDelay;
import software.amazon.cloudformation.proxy.delay.DelayBasedBuilder;

public class Constant
extends AbstractDelay {
    final Duration delay;

    Constant(Duration timeout, Duration delay) {
        super(timeout);
        Preconditions.checkArgument((delay != null && delay.toMillis() > 0L ? 1 : 0) != 0, (Object)"delay must be > 0");
        this.delay = delay;
    }

    public static Builder of() {
        return new Builder();
    }

    @Override
    public Duration nextDelay(int attempt) {
        return this.enforceBounds(this.delay.multipliedBy(attempt), this.delay);
    }

    public static final class Builder
    extends DelayBasedBuilder<Constant, Builder> {
        @Override
        public Constant build() {
            return new Constant(this.timeout, this.delay);
        }
    }
}

