/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudformation.proxy.delay;

import com.google.common.base.Preconditions;
import java.time.Duration;
import software.amazon.cloudformation.proxy.delay.MinDelayAbstractBase;
import software.amazon.cloudformation.proxy.delay.MinDelayBasedBuilder;

public class Exponential
extends MinDelayAbstractBase {
    final int powerBy;
    private Duration accrued = Duration.ZERO;

    private Exponential(Duration timeout, Duration minDelay, int powerBy) {
        super(timeout, minDelay);
        Preconditions.checkArgument((powerBy >= 2 ? 1 : 0) != 0, (Object)"powerBy >= 2");
        this.powerBy = powerBy;
    }

    public static Builder of() {
        return new Builder();
    }

    @Override
    public Duration nextDelay(int attempt) {
        long next = Math.round(Math.pow(this.powerBy, attempt));
        Duration nextDelay = Duration.ofSeconds(next);
        this.accrued = this.accrued.plus(nextDelay);
        return this.enforceBounds(this.accrued, nextDelay);
    }

    public static final class Builder
    extends MinDelayBasedBuilder<Exponential, Builder> {
        private int powerBy = 2;

        public Builder powerBy(int powerBy) {
            this.powerBy = powerBy;
            return this;
        }

        @Override
        public Exponential build() {
            return new Exponential(this.timeout, this.minDelay, this.powerBy);
        }
    }
}

