/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudformation.proxy.delay;

import com.google.common.base.Preconditions;
import java.time.Duration;
import software.amazon.cloudformation.proxy.delay.AbstractDelay;

abstract class MinDelayAbstractBase
extends AbstractDelay {
    final Duration minDelay;

    MinDelayAbstractBase(Duration timeout, Duration minDelay) {
        super(timeout);
        Preconditions.checkArgument((minDelay != null && minDelay.toMillis() >= 0L ? 1 : 0) != 0, (Object)"minDelay must be > 0");
        Preconditions.checkArgument((minDelay.compareTo(timeout) < 0 ? 1 : 0) != 0, (Object)"minDelay < timeout");
        this.minDelay = minDelay;
    }

    @Override
    protected Duration enforceBounds(Duration boundsCheck, Duration delayTime) {
        if (boundsCheck.compareTo(this.minDelay) < 0) {
            return this.minDelay;
        }
        return super.enforceBounds(boundsCheck, delayTime);
    }
}

