/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudformation.proxy.delay;

import com.google.common.base.Preconditions;
import java.time.Duration;
import software.amazon.cloudformation.proxy.delay.Constant;
import software.amazon.cloudformation.proxy.delay.DelayBasedBuilder;

public class MultipleOf
extends Constant {
    Duration accrued = Duration.ZERO;
    final int multiple;

    MultipleOf(Duration timeout, Duration delay, int multiple) {
        super(timeout, delay);
        Preconditions.checkArgument((multiple > 1 ? 1 : 0) != 0, (Object)"multiple must be > 1");
        this.multiple = multiple;
    }

    public static Builder multipleOf() {
        return new Builder();
    }

    @Override
    public Duration nextDelay(int attempt) {
        if (attempt < 2) {
            this.accrued = this.delay;
            return this.delay;
        }
        Duration next = this.delay.multipliedBy((long)(attempt - 1) * (long)this.multiple);
        this.accrued = this.accrued.plus(next);
        return this.enforceBounds(this.accrued, next);
    }

    public static class Builder
    extends DelayBasedBuilder<MultipleOf, Builder> {
        int multiple = 2;

        public Builder multiple(int multiple) {
            this.multiple = multiple;
            return this;
        }

        @Override
        public MultipleOf build() {
            return new MultipleOf(this.timeout, this.delay, this.multiple);
        }
    }
}

