/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudformation.resource;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Random;
import java.util.regex.Pattern;
import org.apache.commons.lang3.RandomStringUtils;

public class IdentifierUtils {
    private static final int GENERATED_PHYSICALID_MAXLEN = 40;
    private static final int GUID_LENGTH = 12;
    private static final int MIN_PHYSICAL_RESOURCE_ID_LENGTH = 15;
    private static final int MIN_PREFERRED_LENGTH = 17;
    private static final Splitter STACKID_SPLITTER = Splitter.on((char)'/');
    private static final Pattern STACK_ARN_PATTERN = Pattern.compile("^[a-z0-9-:]*stack/[-a-z0-9A-Z/]*");
    private static final Pattern STACK_NAME_PATTERN = Pattern.compile("^[-a-z0-9A-Z]*");

    private IdentifierUtils() {
    }

    public static String generateResourceIdentifier(String logicalResourceId, String clientRequestToken) {
        return IdentifierUtils.generateResourceIdentifier(logicalResourceId, clientRequestToken, 40);
    }

    public static String generateResourceIdentifier(String logicalResourceId, String clientRequestToken, int maxLength) {
        int maxLogicalIdLength = maxLength - 13;
        int endIndex = Math.min(logicalResourceId.length(), maxLogicalIdLength);
        StringBuilder sb = new StringBuilder();
        if (endIndex > 0) {
            sb.append(logicalResourceId.substring(0, endIndex)).append("-");
        }
        return sb.append(RandomStringUtils.random((int)12, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)new Random(clientRequestToken.hashCode()))).toString();
    }

    public static String generateResourceIdentifier(String stackId, String logicalResourceId, String clientRequestToken, int maxLength) {
        if (maxLength < 15) {
            throw new IllegalArgumentException("Cannot generate resource IDs shorter than 15 characters.");
        }
        String stackName = stackId;
        if (IdentifierUtils.isStackArn(stackId)) {
            stackName = (String)STACKID_SPLITTER.splitToList((CharSequence)stackId).get(1);
        }
        if (!IdentifierUtils.isValidStackName(stackName)) {
            throw new IllegalArgumentException(String.format("%s is not a valid Stack name", stackName));
        }
        String cleanStackName = stackName.replaceFirst("^-+", "").replaceAll("-{2,}", "-");
        boolean separate = maxLength > 17;
        int freeCharacters = maxLength - 13 - (separate ? 1 : 0);
        int[] requestedLengths = new int[]{cleanStackName.length(), logicalResourceId.length()};
        int[] availableLengths = IdentifierUtils.fairSplit(freeCharacters, requestedLengths);
        int charsForStackName = availableLengths[0];
        int charsForResrcName = availableLengths[1];
        StringBuilder prefix = new StringBuilder();
        prefix.append(cleanStackName, 0, charsForStackName);
        if (separate) {
            prefix.append("-");
        }
        prefix.append(logicalResourceId, 0, charsForResrcName);
        return IdentifierUtils.generateResourceIdentifier(prefix.toString(), clientRequestToken, maxLength);
    }

    private static boolean isStackArn(String stackId) {
        return STACK_ARN_PATTERN.matcher(stackId).matches() && Iterables.size((Iterable)STACKID_SPLITTER.split((CharSequence)stackId)) == 3;
    }

    private static boolean isValidStackName(String stackName) {
        return STACK_NAME_PATTERN.matcher(stackName).matches();
    }

    private static int[] fairSplit(int cap, int[] buckets) {
        int remaining = cap;
        int[] allocated = new int[buckets.length];
        Arrays.fill(allocated, 0);
        while (remaining > 0) {
            int maxAllocation = remaining < buckets.length ? 1 : remaining / buckets.length;
            int bucketSatisfied = 0;
            int i = -1;
            while (++i < buckets.length) {
                if (allocated[i] < buckets[i]) {
                    int incrementalAllocation = Math.min(maxAllocation, buckets[i] - allocated[i]);
                    int n = i;
                    allocated[n] = allocated[n] + incrementalAllocation;
                    remaining -= incrementalAllocation;
                } else {
                    ++bucketSatisfied;
                }
                if (remaining > 0 && bucketSatisfied != buckets.length) continue;
                return allocated;
            }
        }
        return allocated;
    }
}

