/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudformation.resource;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import software.amazon.cloudformation.proxy.aws.AWSServiceSerdeModule;

public class Serializer {
    public static final String COMPRESSED = "__COMPRESSED__";
    private static final String COMPRESSION_METHOD = "__COMPRESSION_METHOD__";
    private static final String COMPRESSION_GZIP_BASE64 = "gzip_base64";
    private static final ObjectMapper OBJECT_MAPPER;
    private static final ObjectMapper STRICT_OBJECT_MAPPER;
    private static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE;

    public <T> String serialize(T modelObject) throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsString(modelObject);
    }

    public <T> String compress(String modelInput) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            try (GZIPOutputStream gzip = new GZIPOutputStream(byteArrayOutputStream);){
                gzip.write(modelInput.getBytes(StandardCharsets.UTF_8));
            }
            map.put(COMPRESSED, Base64.encodeBase64String((byte[])byteArrayOutputStream.toByteArray()));
            map.put(COMPRESSION_METHOD, COMPRESSION_GZIP_BASE64);
        }
        return OBJECT_MAPPER.writeValueAsString(map);
    }

    public <T> T deserialize(String s, TypeReference<T> reference) throws IOException {
        return (T)OBJECT_MAPPER.readValue(s, reference);
    }

    /*
     * Exception decompiling
     */
    public String decompress(String s) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public <T> T deserializeStrict(String s, TypeReference<T> reference) throws IOException {
        return (T)STRICT_OBJECT_MAPPER.readValue(s, reference);
    }

    static {
        MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
        STRICT_OBJECT_MAPPER = new ObjectMapper();
        STRICT_OBJECT_MAPPER.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, true);
        STRICT_OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        STRICT_OBJECT_MAPPER.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
        STRICT_OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
        STRICT_OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
        STRICT_OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        STRICT_OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        STRICT_OBJECT_MAPPER.registerModule((Module)new AWSServiceSerdeModule());
        STRICT_OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
        OBJECT_MAPPER = new ObjectMapper();
        OBJECT_MAPPER.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, true);
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        OBJECT_MAPPER.registerModule((Module)new AWSServiceSerdeModule());
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
    }
}

