/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudformation.scheduler;

import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import software.amazon.awssdk.services.cloudwatchevents.CloudWatchEventsClient;
import software.amazon.awssdk.services.cloudwatchevents.model.DeleteRuleRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.PutRuleRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.PutTargetsRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.RemoveTargetsRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.RuleState;
import software.amazon.awssdk.services.cloudwatchevents.model.Target;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.cloudformation.exceptions.TerminalException;
import software.amazon.cloudformation.injection.CloudWatchEventsProvider;
import software.amazon.cloudformation.proxy.HandlerRequest;
import software.amazon.cloudformation.proxy.Logger;
import software.amazon.cloudformation.proxy.RequestContext;
import software.amazon.cloudformation.resource.Serializer;
import software.amazon.cloudformation.scheduler.CronHelper;

public class CloudWatchScheduler {
    private final CloudWatchEventsProvider cloudWatchEventsProvider;
    private final Logger loggerProxy;
    private final CronHelper cronHelper;
    private final Serializer serializer;
    private CloudWatchEventsClient client;

    public CloudWatchScheduler(CloudWatchEventsProvider cloudWatchEventsProvider, Logger loggerProxy, Serializer serializer) {
        this(cloudWatchEventsProvider, loggerProxy, new CronHelper(), serializer);
    }

    public CloudWatchScheduler(CloudWatchEventsProvider cloudWatchEventsProvider, Logger loggerProxy, CronHelper cronHelper, Serializer serializer) {
        this.cloudWatchEventsProvider = cloudWatchEventsProvider;
        this.loggerProxy = loggerProxy;
        this.cronHelper = cronHelper;
        this.serializer = Objects.requireNonNull(serializer);
    }

    public void refreshClient() {
        this.client = this.cloudWatchEventsProvider.get();
    }

    public <ResourceT, CallbackT, ConfigurationT> void rescheduleAfterMinutes(String functionArn, int minutesFromNow, HandlerRequest<ResourceT, CallbackT, ConfigurationT> handlerRequest) {
        String jsonRequest;
        assert (this.client != null) : "CloudWatchEventsClient was not initialised. You must call refreshClient() first.";
        String cronRule = this.cronHelper.generateOneTimeCronExpression(Math.max(minutesFromNow, 1));
        UUID rescheduleId = UUID.randomUUID();
        String ruleName = String.format("reinvoke-handler-%s", rescheduleId);
        String targetId = String.format("reinvoke-target-%s", rescheduleId);
        RequestContext<CallbackT> requestContext = handlerRequest.getRequestContext();
        requestContext.setCloudWatchEventsRuleName(ruleName);
        requestContext.setCloudWatchEventsTargetId(targetId);
        try {
            jsonRequest = this.serializer.compress(this.serializer.serialize(handlerRequest));
        }
        catch (IOException e) {
            throw new TerminalException("Unable to serialize the request for callback", e);
        }
        this.log(String.format("Scheduling re-invoke at %s (%s)%n", cronRule, rescheduleId));
        PutRuleRequest putRuleRequest = (PutRuleRequest)PutRuleRequest.builder().name(ruleName).scheduleExpression(cronRule).state(RuleState.ENABLED).build();
        this.client.putRule(putRuleRequest);
        Target target = (Target)Target.builder().arn(functionArn).id(targetId).input(jsonRequest).build();
        PutTargetsRequest putTargetsRequest = (PutTargetsRequest)PutTargetsRequest.builder().targets(new Target[]{target}).rule(putRuleRequest.name()).build();
        this.client.putTargets(putTargetsRequest);
    }

    public void cleanupCloudWatchEvents(String cloudWatchEventsRuleName, String cloudWatchEventsTargetId) {
        assert (this.client != null) : "CloudWatchEventsClient was not initialised. You must call refreshClient() first.";
        try {
            if (!StringUtils.isBlank((CharSequence)cloudWatchEventsTargetId)) {
                RemoveTargetsRequest removeTargetsRequest = (RemoveTargetsRequest)RemoveTargetsRequest.builder().ids(new String[]{cloudWatchEventsTargetId}).rule(cloudWatchEventsRuleName).build();
                this.client.removeTargets(removeTargetsRequest);
            }
        }
        catch (Throwable e) {
            this.log(String.format("Error cleaning CloudWatchEvents Target (targetId=%s): %s", cloudWatchEventsTargetId, e.getMessage()));
        }
        try {
            if (!StringUtils.isBlank((CharSequence)cloudWatchEventsRuleName)) {
                DeleteRuleRequest deleteRuleRequest = (DeleteRuleRequest)DeleteRuleRequest.builder().name(cloudWatchEventsRuleName).build();
                this.client.deleteRule(deleteRuleRequest);
            }
        }
        catch (Throwable e) {
            this.log(String.format("Error cleaning CloudWatchEvents (ruleName=%s): %s", cloudWatchEventsRuleName, e.getMessage()));
        }
    }

    private void log(String message) {
        if (this.loggerProxy != null) {
            this.loggerProxy.log(message);
        }
    }

    @Generated
    public CloudWatchEventsProvider getCloudWatchEventsProvider() {
        return this.cloudWatchEventsProvider;
    }

    @Generated
    public Logger getLoggerProxy() {
        return this.loggerProxy;
    }

    @Generated
    public CronHelper getCronHelper() {
        return this.cronHelper;
    }

    @Generated
    public Serializer getSerializer() {
        return this.serializer;
    }

    @Generated
    public CloudWatchEventsClient getClient() {
        return this.client;
    }

    @Generated
    public void setClient(CloudWatchEventsClient client) {
        this.client = client;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CloudWatchScheduler)) {
            return false;
        }
        CloudWatchScheduler other = (CloudWatchScheduler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CloudWatchEventsProvider this$cloudWatchEventsProvider = this.getCloudWatchEventsProvider();
        CloudWatchEventsProvider other$cloudWatchEventsProvider = other.getCloudWatchEventsProvider();
        if (this$cloudWatchEventsProvider == null ? other$cloudWatchEventsProvider != null : !this$cloudWatchEventsProvider.equals(other$cloudWatchEventsProvider)) {
            return false;
        }
        Logger this$loggerProxy = this.getLoggerProxy();
        Logger other$loggerProxy = other.getLoggerProxy();
        if (this$loggerProxy == null ? other$loggerProxy != null : !this$loggerProxy.equals(other$loggerProxy)) {
            return false;
        }
        CronHelper this$cronHelper = this.getCronHelper();
        CronHelper other$cronHelper = other.getCronHelper();
        if (this$cronHelper == null ? other$cronHelper != null : !this$cronHelper.equals(other$cronHelper)) {
            return false;
        }
        Serializer this$serializer = this.getSerializer();
        Serializer other$serializer = other.getSerializer();
        if (this$serializer == null ? other$serializer != null : !this$serializer.equals(other$serializer)) {
            return false;
        }
        CloudWatchEventsClient this$client = this.getClient();
        CloudWatchEventsClient other$client = other.getClient();
        return !(this$client == null ? other$client != null : !this$client.equals(other$client));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CloudWatchScheduler;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CloudWatchEventsProvider $cloudWatchEventsProvider = this.getCloudWatchEventsProvider();
        result = result * 59 + ($cloudWatchEventsProvider == null ? 43 : $cloudWatchEventsProvider.hashCode());
        Logger $loggerProxy = this.getLoggerProxy();
        result = result * 59 + ($loggerProxy == null ? 43 : $loggerProxy.hashCode());
        CronHelper $cronHelper = this.getCronHelper();
        result = result * 59 + ($cronHelper == null ? 43 : $cronHelper.hashCode());
        Serializer $serializer = this.getSerializer();
        result = result * 59 + ($serializer == null ? 43 : $serializer.hashCode());
        CloudWatchEventsClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CloudWatchScheduler(cloudWatchEventsProvider=" + this.getCloudWatchEventsProvider() + ", loggerProxy=" + this.getLoggerProxy() + ", cronHelper=" + this.getCronHelper() + ", serializer=" + this.getSerializer() + ", client=" + this.getClient() + ")";
    }
}

