/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudformation.scheduler;

import java.time.Clock;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public class CronHelper {
    private final Clock clock;

    public CronHelper() {
        this.clock = Clock.systemUTC();
    }

    public CronHelper(Clock clock) {
        this.clock = clock;
    }

    public String generateOneTimeCronExpression(int minutesFromNow) {
        Instant instant = Instant.now(this.clock).plusSeconds(60L * (long)(minutesFromNow + 1));
        OffsetDateTime odt = instant.atOffset(ZoneOffset.UTC);
        return DateTimeFormatter.ofPattern("'cron('m H d M ? u')'").format(odt);
    }
}

