/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter;

import io.opentelemetry.javaagent.shaded.instrumentation.api.config.Config;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.NetClientAttributesExtractor;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.Map;
import javax.annotation.Nullable;

public final class PeerServiceAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private static final Map<String, String> JAVAAGENT_PEER_SERVICE_MAPPING = Config.get().getMap("otel.instrumentation.common.peer-service-mapping");
    private final Map<String, String> peerServiceMapping;
    private final NetClientAttributesExtractor<REQUEST, RESPONSE> netClientAttributesExtractor;

    PeerServiceAttributesExtractor(Map<String, String> peerServiceMapping, NetClientAttributesExtractor<REQUEST, RESPONSE> netClientAttributesExtractor) {
        this.peerServiceMapping = peerServiceMapping;
        this.netClientAttributesExtractor = netClientAttributesExtractor;
    }

    public static <REQUEST, RESPONSE> PeerServiceAttributesExtractor<REQUEST, RESPONSE> create(NetClientAttributesExtractor<REQUEST, RESPONSE> netAttributesExtractor) {
        return new PeerServiceAttributesExtractor<REQUEST, RESPONSE>(JAVAAGENT_PEER_SERVICE_MAPPING, netAttributesExtractor);
    }

    @Override
    public void onStart(AttributesBuilder attributes, REQUEST request) {
    }

    @Override
    public void onEnd(AttributesBuilder attributes, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        String peerName = this.netClientAttributesExtractor.peerName(request, response);
        String peerService = this.mapToPeerService(peerName);
        if (peerService == null) {
            String peerIp = this.netClientAttributesExtractor.peerIp(request, response);
            peerService = this.mapToPeerService(peerIp);
        }
        if (peerService != null) {
            attributes.put(SemanticAttributes.PEER_SERVICE, peerService);
        }
    }

    private String mapToPeerService(String endpoint) {
        if (endpoint == null) {
            return null;
        }
        return this.peerServiceMapping.get(endpoint);
    }
}

