/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http;

import javax.annotation.Nullable;

final class ForwarderHeaderParser {
    @Nullable
    static String extractForwarded(String forwarded) {
        int start = forwarded.toLowerCase().indexOf("for=");
        if (start < 0) {
            return null;
        }
        if ((start += 4) >= forwarded.length() - 1) {
            return null;
        }
        return ForwarderHeaderParser.extractIpAddress(forwarded, start);
    }

    @Nullable
    static String extractForwardedFor(String forwarded) {
        return ForwarderHeaderParser.extractIpAddress(forwarded, 0);
    }

    @Nullable
    private static String extractIpAddress(String forwarded, int start) {
        if (forwarded.length() == start) {
            return null;
        }
        if (forwarded.charAt(start) == '\"') {
            return ForwarderHeaderParser.extractIpAddress(forwarded, start + 1);
        }
        if (forwarded.charAt(start) == '[') {
            int end = forwarded.indexOf(93, start + 1);
            if (end == -1) {
                return null;
            }
            return forwarded.substring(start + 1, end);
        }
        boolean inIpv4 = false;
        for (int i = start; i < forwarded.length() - 1; ++i) {
            char c = forwarded.charAt(i);
            if (c == '.') {
                inIpv4 = true;
                continue;
            }
            if (c != ',' && c != ';' && c != '\"' && (!inIpv4 || c != ':')) continue;
            if (i == start) {
                return null;
            }
            return forwarded.substring(start, i);
        }
        return forwarded.substring(start);
    }

    private ForwarderHeaderParser() {
    }
}

