/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.timestream.jdbc;

import com.amazonaws.services.timestreamquery.model.ColumnInfo;
import com.amazonaws.services.timestreamquery.model.Datum;
import com.amazonaws.services.timestreamquery.model.Row;
import com.amazonaws.services.timestreamquery.model.Type;
import com.google.common.collect.ImmutableList;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.timestream.jdbc.TimestreamArray;
import software.amazon.timestream.jdbc.TimestreamBaseResultSet;
import software.amazon.timestream.jdbc.TimestreamDataType;
import software.amazon.timestream.jdbc.TimestreamStruct;

public class TimestreamArrayResultSet
extends TimestreamBaseResultSet {
    private final List<Row> arrayResultSet = new ArrayList<Row>();
    private final TimestreamDataType timestreamDataType;
    private final Type baseType;

    TimestreamArrayResultSet(List<Object> array, Type baseType) throws SQLException {
        super(null, 1000);
        this.baseType = baseType;
        this.timestreamDataType = TimestreamDataType.fromType(baseType);
        this.rsMeta = this.createColumnMetadata((List<ColumnInfo>)ImmutableList.of((Object)TimestreamDataType.createColumnInfo(TimestreamDataType.INTEGER, "INDEX"), (Object)TimestreamDataType.createColumnInfo(new ColumnInfo(), baseType, "VALUE")));
        this.populateCurrentRows(array);
    }

    @Override
    protected void doClose() {
    }

    @Override
    protected boolean doNextPage() throws SQLException {
        this.verifyOpen();
        return false;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.verifyOpen();
        return this.getRow() > this.arrayResultSet.size();
    }

    @Override
    public boolean isLast() throws SQLException {
        this.verifyOpen();
        return !this.rowItr.hasNext();
    }

    /*
     * WARNING - void declaration
     */
    private void populateCurrentRows(List<Object> array) throws SQLException {
        block5: for (int i = 0; i < array.size(); ++i) {
            Datum indexDatum = new Datum().withScalarValue(String.valueOf(i + 1));
            switch (this.timestreamDataType) {
                case ROW: {
                    this.arrayResultSet.add(new Row().withData(new Datum[]{indexDatum, new Datum().withRowValue(new Row().withData(((TimestreamStruct)array.get(i)).getStruct()))}));
                    continue block5;
                }
                case TIMESERIES: {
                    this.arrayResultSet.add(new Row().withData(new Datum[]{indexDatum, new Datum().withTimeSeriesValue((Collection)((List)array.get(i)))}));
                    continue block5;
                }
                case ARRAY: {
                    ArrayList<Datum> datumList = new ArrayList<Datum>();
                    datumList.add(indexDatum);
                    for (Object object : array) {
                        void var6_6;
                        if (object instanceof TimestreamArray) {
                            List<Object> list = ((TimestreamArray)object).getArrayList();
                        }
                        ArrayList<Datum> arrayValueList = new ArrayList<Datum>();
                        for (Object val : (List)var6_6) {
                            arrayValueList.add(TimestreamDataType.createDatum(new Datum(), val, this.baseType.getArrayColumnInfo().getType()));
                        }
                        datumList.add(new Datum().withArrayValue(arrayValueList));
                    }
                    this.arrayResultSet.add(new Row().withData(datumList));
                    continue block5;
                }
                default: {
                    this.arrayResultSet.add(new Row().withData(new Datum[]{indexDatum, new Datum().withScalarValue(String.valueOf(array.get(i)))}));
                }
            }
        }
        this.rowItr = this.arrayResultSet.iterator();
    }
}

