/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.timestream.jdbc;

import com.amazonaws.services.timestreamquery.model.ColumnInfo;
import com.amazonaws.services.timestreamquery.model.Datum;
import com.amazonaws.services.timestreamquery.model.Row;
import com.google.common.collect.ImmutableList;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.timestream.jdbc.TimestreamBaseResultSet;
import software.amazon.timestream.jdbc.TimestreamConnection;
import software.amazon.timestream.jdbc.TimestreamDataType;
import software.amazon.timestream.jdbc.TimestreamStatement;

public class TimestreamDatabasesResultSet
extends TimestreamBaseResultSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimestreamDatabasesResultSet.class);
    private static final List<ColumnInfo> COLUMNS = ImmutableList.of((Object)TimestreamDataType.createColumnInfo(TimestreamDataType.VARCHAR, "TABLE_CAT"));
    private boolean isAfterLast = false;

    TimestreamDatabasesResultSet(TimestreamConnection connection) throws SQLException {
        super(null, 20);
        this.rsMeta = this.createColumnMetadata(COLUMNS);
        this.populateCurrentRows(connection);
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.verifyOpen();
        return this.isAfterLast;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.verifyOpen();
        LOGGER.debug("Checking whether the last row of this TimestreamDatabasesResultSet has been reached.");
        return !this.isAfterLast && !this.rowItr.hasNext();
    }

    @Override
    protected void doClose() {
        LOGGER.debug("Closed is called on this TimestreamDatabasesResultSet, do nothing as the result set has already been closed.");
    }

    @Override
    protected boolean doNextPage() {
        LOGGER.debug("Attempting to retrieve the next page of results. There are no more pages, return false.");
        this.isAfterLast = true;
        return false;
    }

    private void populateCurrentRows(TimestreamConnection connection) throws SQLException {
        ArrayList<String> databases = new ArrayList<String>();
        try (TimestreamStatement statement = connection.createStatement();){
            LOGGER.debug("Retrieving a list of databases.");
            try (ResultSet rs = statement.executeQuery("SHOW DATABASES");){
                while (rs.next()) {
                    databases.add(rs.getString(1));
                }
            }
        }
        LOGGER.debug("Retrieved {} databases.", (Object)databases.size());
        this.rowItr = databases.stream().map(d -> new Datum().withScalarValue(d)).map(d -> new Row().withData(new Datum[]{d})).iterator();
    }
}

