/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.timestream.jdbc;

import java.sql.Connection;
import java.util.LinkedList;
import java.util.List;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.timestream.jdbc.TimestreamConnection;

public class TimestreamPooledConnection
implements PooledConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimestreamPooledConnection.class);
    private final List<ConnectionEventListener> connectionEventListeners = new LinkedList<ConnectionEventListener>();
    private final TimestreamConnection timestreamConnection;

    TimestreamPooledConnection(TimestreamConnection connection) {
        this.timestreamConnection = connection;
    }

    @Override
    public Connection getConnection() {
        return this.timestreamConnection;
    }

    @Override
    public void close() {
        LOGGER.debug("Notify all connection listeners this PooledConnection object is closed.");
        ConnectionEvent event = new ConnectionEvent(this, null);
        this.connectionEventListeners.forEach(l -> l.connectionClosed(event));
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        LOGGER.debug("Add a ConnectionEventListener to this PooledConnection.");
        this.connectionEventListeners.add(listener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        LOGGER.debug("Remove the ConnectionEventListener attached to this PooledConnection.");
        this.connectionEventListeners.remove(listener);
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        LOGGER.debug("addStatementEventListener is called on the current PooledConnection object.");
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        LOGGER.debug("removeStatementEventListener is called on the current PooledConnection object.");
    }
}

