/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.timestream.jdbc;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.AssumeRoleWithSAMLRequest;
import com.amazonaws.services.securitytoken.model.Credentials;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.SQLException;
import java.util.Map;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.timestream.jdbc.TimestreamConnectionProperty;

abstract class TimestreamSAMLCredentialsProvider {
    protected static final Logger LOGGER = LoggerFactory.getLogger(TimestreamSAMLCredentialsProvider.class);
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    protected final String userName;
    protected final String password;
    protected final String roleARN;
    protected final String idpARN;
    protected final CloseableHttpClient httpClient;

    TimestreamSAMLCredentialsProvider(CloseableHttpClient httpClient, Map<String, String> fieldsMap) {
        this.userName = fieldsMap.get(TimestreamConnectionProperty.IDP_USERNAME.getConnectionProperty());
        this.password = fieldsMap.get(TimestreamConnectionProperty.IDP_PASSWORD.getConnectionProperty());
        this.roleARN = fieldsMap.get(TimestreamConnectionProperty.AWS_ROLE_ARN.getConnectionProperty());
        this.idpARN = fieldsMap.get(TimestreamConnectionProperty.IDP_ARN.getConnectionProperty());
        this.httpClient = httpClient;
    }

    AWSCredentialsProvider createCredentialsProvider() throws SQLException {
        Credentials credentials = this.createSAMLRequestAndFetchCredentials();
        String accessKeyID = credentials.getAccessKeyId();
        String secretAccessKey = credentials.getSecretAccessKey();
        String sessionToken = credentials.getSessionToken();
        return new AWSStaticCredentialsProvider((AWSCredentials)new BasicSessionCredentials(accessKeyID, secretAccessKey, sessionToken));
    }

    protected abstract String getSAMLAssertion() throws SQLException;

    protected Credentials fetchCredentialsWithSAMLAssertion(AssumeRoleWithSAMLRequest samlRequest) {
        LOGGER.debug("Fetching the AWS credentials with the SAML assertion.");
        return AWSSecurityTokenServiceClientBuilder.defaultClient().assumeRoleWithSAML(samlRequest).getCredentials();
    }

    private Credentials createSAMLRequestAndFetchCredentials() throws SQLException {
        LOGGER.debug("Constructing an AssumeRoleWithSAMLRequest.");
        AssumeRoleWithSAMLRequest samlRequest = new AssumeRoleWithSAMLRequest().withRoleArn(this.roleARN).withSAMLAssertion(this.getSAMLAssertion()).withPrincipalArn(this.idpARN);
        return this.fetchCredentialsWithSAMLAssertion(samlRequest);
    }
}

