/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.timestream.jdbc;

import com.amazonaws.services.timestreamquery.model.ColumnInfo;
import com.amazonaws.services.timestreamquery.model.Datum;
import com.amazonaws.services.timestreamquery.model.Row;
import com.amazonaws.services.timestreamquery.model.Type;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.timestream.jdbc.Conversions;
import software.amazon.timestream.jdbc.Error;
import software.amazon.timestream.jdbc.JdbcType;
import software.amazon.timestream.jdbc.TimestreamArray;
import software.amazon.timestream.jdbc.TimestreamBaseResultSet;
import software.amazon.timestream.jdbc.TimestreamDataType;

public class TimestreamStruct
implements Struct {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimestreamStruct.class);
    private final List<Datum> struct;
    private final TimestreamBaseResultSet parentResultSet;
    private final List<TimestreamDataType> baseTypeList;
    private final List<Type> typeList;
    private final Map<String, Class<?>> conversionMap;

    TimestreamStruct(List<Datum> struct, List<ColumnInfo> columnInfos, TimestreamBaseResultSet parentResultSet) {
        this(struct, columnInfos, parentResultSet, new HashMap());
    }

    TimestreamStruct(List<Datum> struct, List<ColumnInfo> columnInfos, TimestreamBaseResultSet parentResultSet, Map<String, Class<?>> conversionMap) {
        this.struct = struct;
        this.parentResultSet = parentResultSet;
        this.conversionMap = conversionMap;
        this.baseTypeList = columnInfos.parallelStream().map(columnInfo -> TimestreamDataType.fromType(columnInfo.getType())).collect(Collectors.toList());
        this.typeList = columnInfos.parallelStream().map(ColumnInfo::getType).collect(Collectors.toList());
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        this.verifyOpen();
        return Row.class.getName();
    }

    @Override
    public Object[] getAttributes() throws SQLException {
        this.verifyOpen();
        return this.parseRow(this.struct).toArray();
    }

    @Override
    public Object[] getAttributes(Map<String, Class<?>> map) throws SQLException {
        this.verifyOpen();
        return this.parseRow(this.struct, this.baseTypeList, map).toArray();
    }

    private List<Object> parseRow(List<Datum> row) throws SQLException {
        return this.parseRow(row, this.baseTypeList, this.conversionMap);
    }

    private List<Object> parseRow(List<Datum> row, List<TimestreamDataType> baseTypeList, Map<String, Class<?>> map) throws SQLException {
        ArrayList<Object> rowList = new ArrayList<Object>();
        ArrayList<JdbcType> targetTypeList = new ArrayList<JdbcType>();
        for (TimestreamDataType timestreamDataType : baseTypeList) {
            Class<?> targetClass = map.get(timestreamDataType.name());
            JdbcType targetType = targetClass != null ? TimestreamDataType.convertClassNameToJdbcType(targetClass.getName()) : timestreamDataType.getJdbcType();
            targetTypeList.add(targetType);
        }
        int i = 0;
        block5: for (Datum datum : row) {
            JdbcType targetType;
            TimestreamDataType baseType;
            if (baseTypeList.size() == 1) {
                baseType = baseTypeList.get(0);
                targetType = (JdbcType)((Object)targetTypeList.get(0));
            } else {
                baseType = baseTypeList.get(i);
                targetType = (JdbcType)((Object)targetTypeList.get(i));
            }
            switch (baseType) {
                case ARRAY: {
                    TimestreamArray timestreamArray = new TimestreamArray(datum.getArrayValue(), this.typeList.get(i).getArrayColumnInfo().getType(), this.parentResultSet, map);
                    if (targetType == JdbcType.VARCHAR) {
                        rowList.add(String.valueOf(timestreamArray.getArrayList()));
                        continue block5;
                    }
                    List<Object> resultList = TimestreamArray.populateArrayListToDatum(timestreamArray.getArrayList(), timestreamArray);
                    TimestreamArray timestreamArray2 = new TimestreamArray(resultList, this.typeList.get(i).getArrayColumnInfo().getType(), this.parentResultSet, map);
                    rowList.add(timestreamArray2);
                    break;
                }
                case ROW: {
                    TimestreamStruct timestreamStruct = new TimestreamStruct(datum.getRowValue().getData(), this.typeList.get(i).getRowColumnInfo(), this.parentResultSet, map);
                    if (targetType == JdbcType.VARCHAR) {
                        ArrayList<Datum> data = new ArrayList<Datum>();
                        for (Object attribute : timestreamStruct.getAttributes()) {
                            data.add(new Datum().withScalarValue(attribute.toString()));
                        }
                        Object object = Conversions.convert(baseType, targetType, new Datum().withRowValue(new Row().withData(data)), this.parentResultSet::addWarning);
                        rowList.add(object);
                        continue block5;
                    }
                    List<Datum> convertedDatumList = TimestreamStruct.populateObjectToDatum(timestreamStruct.getAttributes());
                    TimestreamStruct timestreamStruct2 = new TimestreamStruct(convertedDatumList, this.typeList.get(i).getRowColumnInfo(), this.parentResultSet, map);
                    rowList.add(timestreamStruct2);
                    break;
                }
                default: {
                    rowList.add(Conversions.convert(baseType, targetType, datum, this.parentResultSet::addWarning));
                }
            }
            ++i;
        }
        return rowList;
    }

    static List<Datum> populateObjectToDatum(Object[] attributes) throws SQLException {
        ArrayList<Datum> resultList = new ArrayList<Datum>();
        for (Object attribute : attributes) {
            if (attribute instanceof TimestreamStruct) {
                resultList.add(new Datum().withRowValue(new Row().withData(((TimestreamStruct)attribute).getStruct())));
                continue;
            }
            if (attribute instanceof TimestreamArray) {
                if (JdbcType.JAVA_OBJECT.name().equals(((TimestreamArray)attribute).getBaseTypeName())) {
                    resultList.add(new Datum().withArrayValue(new Datum[]{(Datum)((TimestreamArray)attribute).getTimestreamArray().get(0)}));
                    continue;
                }
                List<Object> nestedArray = TimestreamArray.populateArrayListToDatum(((TimestreamArray)attribute).getArrayList(), (TimestreamArray)attribute);
                resultList.add(new Datum().withArrayValue(nestedArray));
                continue;
            }
            if (attribute instanceof ArrayList) {
                resultList.add(new Datum().withTimeSeriesValue((Collection)((List)attribute)));
                continue;
            }
            resultList.add(new Datum().withScalarValue(attribute.toString()));
        }
        return resultList;
    }

    List<Datum> getStruct() {
        return this.struct;
    }

    private void verifyOpen() throws SQLException {
        if (this.parentResultSet.isClosed()) {
            throw Error.createSQLException(LOGGER, Error.RESULT_SET_CLOSED, new Object[0]);
        }
    }

    public String toString() {
        String str;
        try {
            str = (String)Conversions.convert(TimestreamDataType.ROW, JdbcType.VARCHAR, new Datum().withRowValue(new Row().withData(this.struct)), this.parentResultSet::addWarning);
        }
        catch (SQLException sqlException) {
            LOGGER.warn("Unable to convert row to a string, {}.", (Object)sqlException.getMessage());
            str = this.struct.toString();
        }
        return str;
    }
}

