/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.samples.connectors.timestream;

import com.amazonaws.samples.connectors.timestream.TimestreamSinkConfig;
import com.amazonaws.samples.connectors.timestream.WriteRequestFailureHandler;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsErrorCode;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryFailedException;
import software.amazon.awssdk.core.exception.ApiCallAttemptTimeoutException;
import software.amazon.awssdk.core.exception.ApiCallTimeoutException;
import software.amazon.awssdk.core.exception.RetryableException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkInterruptedException;
import software.amazon.awssdk.crt.http.HttpException;
import software.amazon.awssdk.services.timestreamwrite.model.AccessDeniedException;
import software.amazon.awssdk.services.timestreamwrite.model.ConflictException;
import software.amazon.awssdk.services.timestreamwrite.model.InternalServerException;
import software.amazon.awssdk.services.timestreamwrite.model.InvalidEndpointException;
import software.amazon.awssdk.services.timestreamwrite.model.Record;
import software.amazon.awssdk.services.timestreamwrite.model.RejectedRecord;
import software.amazon.awssdk.services.timestreamwrite.model.RejectedRecordsException;
import software.amazon.awssdk.services.timestreamwrite.model.ResourceNotFoundException;
import software.amazon.awssdk.services.timestreamwrite.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.timestreamwrite.model.ThrottlingException;
import software.amazon.awssdk.services.timestreamwrite.model.ValidationException;
import software.amazon.awssdk.services.timestreamwrite.model.WriteRecordsRequest;

public class DefaultWriteRequestFailureHandler
implements WriteRequestFailureHandler {
    private static final long serialVersionUID = -818223387498623035L;
    private static final Set<String> RETRYABLE_ERROR_CODES = Set.of("InternalFailure", "ServiceUnavailable");
    private static final Set<Integer> RETRYABLE_HTTP_STATUS_CODES = Set.of(Integer.valueOf(500), Integer.valueOf(502), Integer.valueOf(503), Integer.valueOf(509));
    private static final Logger LOG = LoggerFactory.getLogger(DefaultWriteRequestFailureHandler.class);
    private boolean printFailedRequests;
    private boolean failProcessingOnErrorDefault;
    private boolean failProcessingOnValidationException;
    private boolean failProcessingOnRejectedRecordsException;
    Consumer<Exception> fatalExceptionConsumer;
    final transient HashMap<Class<? extends Throwable>, ExceptionConsumer> exceptionTypeToExceptionHandleMethod = new HashMap();

    public DefaultWriteRequestFailureHandler() {
        this.exceptionTypeToExceptionHandleMethod.put(RejectedRecordsException.class, this::handleRejectedRecordsException);
        this.exceptionTypeToExceptionHandleMethod.put(ValidationException.class, this::handleValidationException);
        this.exceptionTypeToExceptionHandleMethod.put(AccessDeniedException.class, this::handleDefaultException);
        this.exceptionTypeToExceptionHandleMethod.put(ConflictException.class, this::handleDefaultException);
        this.exceptionTypeToExceptionHandleMethod.put(InvalidEndpointException.class, this::handleDefaultException);
        this.exceptionTypeToExceptionHandleMethod.put(ResourceNotFoundException.class, this::handleDefaultException);
        this.exceptionTypeToExceptionHandleMethod.put(ServiceQuotaExceededException.class, this::handleDefaultException);
    }

    private void handleValidationException(List<Record> records, WriteRecordsRequest writeRecordsRequest, Exception e, Consumer<List<Record>> retryOrSuccessCompletionConsumer, Consumer<List<Record>> dropCompletionConsumer) {
        LOG.error("Validation of WriteRecordsRequest failed.", (Throwable)e);
        if (this.printFailedRequests) {
            LOG.info("\tWriteRecordsRequest Data: -> {}", (Object)writeRecordsRequest);
        }
        if (this.failProcessingOnValidationException) {
            LOG.info("'failProcessingOnValidationException' is {}, therefore failing without retry.", (Object)this.failProcessingOnValidationException);
            this.fatalExceptionConsumer.accept(e);
        } else {
            LOG.info("'failProcessingOnValidationException' is {}, therefore dropping records..", (Object)this.failProcessingOnValidationException);
            dropCompletionConsumer.accept(records);
            retryOrSuccessCompletionConsumer.accept(Collections.emptyList());
        }
    }

    void handleRetryableException(List<Record> records, WriteRecordsRequest writeRecordsRequest, Exception e, Consumer<List<Record>> retryOrSuccessCompletionConsumer, Consumer<List<Record>> dropCompletionConsumer) {
        if (e instanceof AwsServiceException) {
            AwsServiceException se = (AwsServiceException)e;
            LOG.error("Retryable '{}' occurred while inserting to Timestream. Records insertion will be retried. Details: Status Code: {}, Request ID: {}", new Object[]{e.getClass().getSimpleName(), se.statusCode(), se.requestId()});
        } else {
            LOG.error("Retryable '{}' occurred while inserting to Timestream. Records insertion will be retried.", (Object)e.getClass().getSimpleName());
        }
        retryOrSuccessCompletionConsumer.accept(records);
    }

    void handleRejectedRecordsException(List<Record> records, WriteRecordsRequest writeRecordsRequest, Exception e, Consumer<List<Record>> retryOrSuccessCompletionConsumer, Consumer<List<Record>> dropCompletionConsumer) {
        RejectedRecordsException rre = (RejectedRecordsException)e;
        List rejectedRecords = rre.rejectedRecords();
        LOG.warn("Timestream rejected {} records.", (Object)rejectedRecords.size());
        if (this.printFailedRequests) {
            LOG.info("\tRejected Record Common Attributes Data: -> {}", (Object)writeRecordsRequest.commonAttributes());
        }
        ArrayList<Record> rejectedOriginalRecords = new ArrayList<Record>(rejectedRecords.size());
        for (RejectedRecord rejectedRecord : rejectedRecords) {
            int index = rejectedRecord.recordIndex();
            LOG.warn("\tRejected Record: -> {}", (Object)rejectedRecord);
            Record originalRecord = (Record)writeRecordsRequest.records().get(index);
            rejectedOriginalRecords.add(originalRecord);
            if (this.printFailedRequests) {
                LOG.info("\tRejected Record Data: -> {}", (Object)originalRecord);
            }
            LOG.warn("\tRejected Record Reason: -> {}", (Object)rejectedRecord.reason());
        }
        if (this.failProcessingOnRejectedRecordsException) {
            LOG.info("'failProcessingOnRejectedRecordsException' is {}, therefore failing without retry.", (Object)this.failProcessingOnRejectedRecordsException);
            this.fatalExceptionConsumer.accept(e);
        } else {
            LOG.info("'failProcessingOnRejectedRecordsException' is {}, therefore dropping records..", (Object)this.failProcessingOnRejectedRecordsException);
            dropCompletionConsumer.accept(rejectedOriginalRecords);
            retryOrSuccessCompletionConsumer.accept(Collections.emptyList());
        }
    }

    void handleDefaultException(List<Record> records, WriteRecordsRequest writeRecordsRequest, Exception e, Consumer<List<Record>> retryOrSuccessCompletionConsumer, Consumer<List<Record>> dropCompletionConsumer) {
        Class<?> exceptionClass = e.getClass();
        if (this.exceptionTypeToExceptionHandleMethod.containsKey(exceptionClass)) {
            LOG.error("Error occurred while inserting to Timestream: {}: {}", (Object)exceptionClass.getSimpleName(), (Object)e.getMessage());
        } else {
            LOG.error("Unknown error occurred while inserting to Timestream. Error: ", (Throwable)e);
        }
        if (this.printFailedRequests) {
            LOG.info("\tData causing failure: -> {}", (Object)writeRecordsRequest);
        }
        if (this.failProcessingOnErrorDefault) {
            LOG.info("'failProcessingOnErrorDefault' is {}, therefore failing without retry.", (Object)this.failProcessingOnErrorDefault);
            this.fatalExceptionConsumer.accept(e);
        } else {
            LOG.info("'failProcessingOnErrorDefault' is {}, therefore dropping records..", (Object)this.failProcessingOnErrorDefault);
            dropCompletionConsumer.accept(records);
            retryOrSuccessCompletionConsumer.accept(Collections.emptyList());
        }
    }

    @Override
    public void open(Consumer<Exception> fatalExceptionConsumer, TimestreamSinkConfig.FailureHandlerConfig failureHandlerConfig) {
        this.fatalExceptionConsumer = fatalExceptionConsumer;
        this.printFailedRequests = failureHandlerConfig.isPrintFailedRequests();
        this.failProcessingOnErrorDefault = failureHandlerConfig.isFailProcessingOnErrorDefault();
        this.failProcessingOnValidationException = failureHandlerConfig.isFailProcessingOnValidationException();
        this.failProcessingOnRejectedRecordsException = failureHandlerConfig.isFailProcessingOnRejectedRecordsException();
    }

    @Override
    public void onWriteError(List<Record> requestEntries, WriteRecordsRequest writeRecordsRequest, Exception exception, Consumer<List<Record>> retryOrSuccessCompletionConsumer, Consumer<List<Record>> dropCompletionConsumer) {
        Class<?> exceptionClass = exception.getClass();
        LOG.debug("Sending WriteRecordsRequest failed. Starting handling exception: {}", (Object)exceptionClass.getName());
        if (DefaultWriteRequestFailureHandler.checkIsRetryableException(exception)) {
            this.handleRetryableException(requestEntries, writeRecordsRequest, exception, retryOrSuccessCompletionConsumer, dropCompletionConsumer);
        } else if (this.exceptionTypeToExceptionHandleMethod.containsKey(exceptionClass)) {
            LOG.debug("Found designated exception handler method.");
            this.exceptionTypeToExceptionHandleMethod.get(exceptionClass).accept(requestEntries, writeRecordsRequest, exception, retryOrSuccessCompletionConsumer, dropCompletionConsumer);
        } else {
            LOG.debug("No designated exception handler method found. Launching the default handler.");
            this.handleDefaultException(requestEntries, writeRecordsRequest, exception, retryOrSuccessCompletionConsumer, dropCompletionConsumer);
        }
    }

    protected static boolean checkIsRetryableException(@NonNull Exception e) {
        AwsServiceException awsServiceException;
        if (e == null) {
            throw new NullPointerException("e is marked non-null but is null");
        }
        if (e instanceof InternalServerException || e instanceof ThrottlingException) {
            return true;
        }
        if (e instanceof AwsServiceException && (awsServiceException = (AwsServiceException)e).awsErrorDetails() != null && (AwsErrorCode.isRetryableErrorCode((String)awsServiceException.awsErrorDetails().errorCode()) || AwsErrorCode.isThrottlingErrorCode((String)awsServiceException.awsErrorDetails().errorCode()) || RETRYABLE_ERROR_CODES.contains(awsServiceException.awsErrorDetails().errorCode()) || awsServiceException.awsErrorDetails().sdkHttpResponse() != null && RETRYABLE_HTTP_STATUS_CODES.contains(awsServiceException.awsErrorDetails().sdkHttpResponse().statusCode()))) {
            return true;
        }
        return DefaultWriteRequestFailureHandler.isRetryableException(e) || e instanceof SdkException && ((SdkException)e).retryable();
    }

    private static boolean isRetryableException(Throwable t) {
        if (t instanceof SdkClientException && t.getCause() != null) {
            return DefaultWriteRequestFailureHandler.isRetryableException(t.getCause());
        }
        if (t instanceof EndpointDiscoveryFailedException && t.getCause() != null) {
            return DefaultWriteRequestFailureHandler.isRetryableException(t.getCause());
        }
        return t instanceof IOException || t.getCause() != null && t.getCause() instanceof TimeoutException || t instanceof HttpException || t instanceof ApiCallTimeoutException || t instanceof ApiCallAttemptTimeoutException || t instanceof RetryableException || t instanceof SdkInterruptedException || t instanceof SocketTimeoutException || t instanceof SocketException;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultWriteRequestFailureHandler that = (DefaultWriteRequestFailureHandler)o;
        return this.printFailedRequests == that.printFailedRequests && this.failProcessingOnErrorDefault == that.failProcessingOnErrorDefault && this.failProcessingOnValidationException == that.failProcessingOnValidationException && this.failProcessingOnRejectedRecordsException == that.failProcessingOnRejectedRecordsException && Objects.equals(this.fatalExceptionConsumer, that.fatalExceptionConsumer) && Objects.equals(this.exceptionTypeToExceptionHandleMethod, that.exceptionTypeToExceptionHandleMethod);
    }

    public int hashCode() {
        return Objects.hash(this.printFailedRequests, this.failProcessingOnErrorDefault, this.failProcessingOnValidationException, this.failProcessingOnRejectedRecordsException, this.fatalExceptionConsumer, this.exceptionTypeToExceptionHandleMethod);
    }

    @FunctionalInterface
    public static interface ExceptionConsumer {
        public void accept(List<Record> var1, WriteRecordsRequest var2, Exception var3, Consumer<List<Record>> var4, Consumer<List<Record>> var5);
    }
}

