/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.samples.connectors.timestream;

import com.amazonaws.samples.connectors.timestream.BatchConverter;
import com.amazonaws.samples.connectors.timestream.TimestreamSinkConfig;
import com.amazonaws.samples.connectors.timestream.TimestreamSinkWriter;
import com.amazonaws.samples.connectors.timestream.metrics.CloudWatchEmittedMetricGroupHelper;
import imported.vnext.org.apache.flink.connector.base.sink.sink.AsyncSinkBase;
import imported.vnext.org.apache.flink.connector.base.sink.sink.writer.ElementConverter;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.connector.sink.Sink;
import org.apache.flink.api.connector.sink.SinkWriter;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.timestreamwrite.model.Record;

@PublicEvolving
public class TimestreamSink<InputT>
extends AsyncSinkBase<InputT, Record> {
    private static final Logger LOG = LoggerFactory.getLogger(TimestreamSink.class);
    protected static final int MAX_BATCH_SIZE_IN_BYTES = Integer.MAX_VALUE;
    protected static final int MAX_RECORD_SIZE_IN_BYTES = Integer.MAX_VALUE;
    private final BatchConverter batchConverter;
    private final TimestreamSinkConfig timestreamSinkConfig;

    public TimestreamSink(ElementConverter<InputT, Record> elementConverter, BatchConverter batchConverter, TimestreamSinkConfig timestreamSinkConfig) {
        super(elementConverter, timestreamSinkConfig.getMaxBatchSize(), timestreamSinkConfig.getMaxInFlightRequests(), timestreamSinkConfig.getMaxBufferedRequests(), Integer.MAX_VALUE, timestreamSinkConfig.getMaxTimeInBufferMS(), Integer.MAX_VALUE);
        this.batchConverter = batchConverter;
        this.timestreamSinkConfig = timestreamSinkConfig;
        LOG.debug("Initialized TimestreamSink class");
    }

    public SinkWriter<InputT, Void, Collection<Record>> createWriter(Sink.InitContext context, List<Collection<Record>> states) {
        LOG.debug("Creating a new TimestreamSinkWriter...");
        CloudWatchEmittedMetricGroupHelper.StaticEmitSinkMetricsToCloudWatch = this.timestreamSinkConfig.isEmitSinkMetricsToCloudWatch();
        return new TimestreamSinkWriter(this.getElementConverter(), this.batchConverter, context, this.timestreamSinkConfig);
    }

    public Optional<SimpleVersionedSerializer<Collection<Record>>> getWriterStateSerializer() {
        return Optional.empty();
    }
}

