/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.samples.connectors.timestream.metrics;

import com.amazonaws.samples.connectors.timestream.TimestreamModelUtils;
import com.amazonaws.samples.connectors.timestream.metrics.TimestreamSinkMetricGroup;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.timestreamwrite.model.Record;
import software.amazon.awssdk.services.timestreamwrite.model.WriteRecordsRequest;

public class MetricsCollector {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsCollector.class);
    private final TimestreamSinkMetricGroup metricGroup;

    public MetricsCollector(TimestreamSinkMetricGroup metricGroup) {
        this.metricGroup = metricGroup;
    }

    public void collectSuccessMetrics(WriteRecordsRequest request) {
        int noRecords = TimestreamModelUtils.countRecordsInWriteRecordsRequest(request);
        LOG.debug("Ingested successfully {} records...", (Object)noRecords);
        this.metricGroup.getNumWritesSuccess().inc();
        this.metricGroup.getNumRecordsSuccess().inc((long)noRecords);
    }

    public void collectExceptionMetrics(Exception exception) {
        String simpleExceptionName = exception.getClass().getSimpleName();
        this.metricGroup.incrementExceptionCounter(simpleExceptionName);
    }

    public void collectRetries(Collection<Record> records) {
        this.metricGroup.getNumWritesNonSDKRetries().inc();
        if (records.size() == 0) {
            LOG.debug("No records to be retried.");
        } else {
            LOG.info("Non AWS SDK retry on {} records", (Object)records.size());
        }
    }

    public void collectDropped(Collection<Record> droppedRecords, WriteRecordsRequest origRequest) {
        this.metricGroup.getNumRecordsDrop().inc((long)droppedRecords.size());
        int succRecordsCount = Math.max(0, TimestreamModelUtils.countRecordsInWriteRecordsRequest(origRequest) - droppedRecords.size());
        this.metricGroup.getNumRecordsSuccess().inc((long)succRecordsCount);
        if (succRecordsCount > 0) {
            this.metricGroup.getNumWritesSuccess().inc();
        }
        LOG.info("Successfully ingested {} records & dropped {} records.", (Object)succRecordsCount, (Object)droppedRecords.size());
    }

    public void collectPreWriteMetrics(WriteRecordsRequest writeRecordsRequest) {
        this.metricGroup.setNumOfRecordsPerWriteRecordRequest(TimestreamModelUtils.countRecordsInWriteRecordsRequest(writeRecordsRequest));
        this.metricGroup.setNumOfMeasuresPerWriteRecordRequest(TimestreamModelUtils.countMeasuresInWriteRecordsRequest(writeRecordsRequest));
        this.metricGroup.setNumOfCommonAttributesDimensionsPerWriteRecordRequest(TimestreamModelUtils.countCommonAttributesDimensionsPerWriteRecordRequest(writeRecordsRequest));
    }
}

