/*
 * Decompiled with CFR 0.152.
 */
package imported.vnext.org.apache.flink.connector.base.sink.sink.writer;

import java.util.AbstractMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.function.ThrowingRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class ForwardCompatibleMailboxExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(ForwardCompatibleMailboxExecutor.class);
    private final ConcurrentLinkedQueue<AbstractMap.SimpleImmutableEntry<String, ThrowingRunnable<? extends Exception>>> mailQueue = new ConcurrentLinkedQueue();

    public void tryYield() {
        AbstractMap.SimpleImmutableEntry<String, ThrowingRunnable<? extends Exception>> poll = this.mailQueue.poll();
        while (poll != null) {
            LOG.debug(poll.getKey());
            poll.getValue().run();
            poll = this.mailQueue.poll();
        }
    }

    public void execute(ThrowingRunnable<? extends Exception> command, String descriptionFormat, Object ... descriptionArgs) {
        this.mailQueue.add(new AbstractMap.SimpleImmutableEntry<String, ThrowingRunnable<? extends Exception>>(String.format(descriptionFormat, descriptionArgs), command));
    }
}

