/*
 * Decompiled with CFR 0.152.
 */
package imported.vnext.org.apache.flink.connector.base.sink.sink.writer;

import lombok.Generated;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;

@Internal
public class SinkMetricGroup {
    @VisibleForTesting
    static final String SINK_METRIC_GROUP = "asyncSink";
    @VisibleForTesting
    static final String CURRENT_SEND_TIME_GAUGE = "currentSendTime";
    @VisibleForTesting
    static final String NUM_RECORDS_OUT_COUNTER = "numRecordsOut";
    @VisibleForTesting
    static final String NUM_BYTES_OUT_COUNTER = "numBytesOut";
    @VisibleForTesting
    static final String IN_FLIGHT_REQUESTS_GAUGE = "inFlightRequests";
    @VisibleForTesting
    static final String BUFFERED_RECORDS_GAUGE = "bufferedRecords";
    @VisibleForTesting
    static final String MILLIS_TIME_BETWEEN_FLUSHES_GAUGE = "millisTimeBetweenFlushes";
    private final MetricGroup sinkGroup;
    private final Counter numRecordsOutCounter;
    private final Counter numBytesOutCounter;
    private Gauge<Long> currentSendTimeGauge;
    private Gauge<Long> inFlightRequestsGauge;
    private Gauge<Long> bufferedRecordsGauge;
    private Gauge<Long> millisTimeBetweenFlushesGauge;

    public SinkMetricGroup(MetricGroup metricGroup) {
        this.sinkGroup = metricGroup.addGroup(SINK_METRIC_GROUP);
        this.numRecordsOutCounter = this.sinkGroup.counter(NUM_RECORDS_OUT_COUNTER);
        this.numBytesOutCounter = this.sinkGroup.counter(NUM_BYTES_OUT_COUNTER);
    }

    public void setCurrentSendTimeGauge(Gauge<Long> currentSendTimeGauge) {
        this.sinkGroup.gauge(CURRENT_SEND_TIME_GAUGE, currentSendTimeGauge);
        this.currentSendTimeGauge = currentSendTimeGauge;
    }

    public void setInFlightRequestsGauge(Gauge<Long> inFlightRequestsGauge) {
        this.sinkGroup.gauge(IN_FLIGHT_REQUESTS_GAUGE, inFlightRequestsGauge);
        this.inFlightRequestsGauge = inFlightRequestsGauge;
    }

    public void setBufferedRecordsGauge(Gauge<Long> bufferedRecordsGauge) {
        this.sinkGroup.gauge(BUFFERED_RECORDS_GAUGE, bufferedRecordsGauge);
        this.bufferedRecordsGauge = bufferedRecordsGauge;
    }

    public void setMillisTimeBetweenFlushesGauge(Gauge<Long> millisTimeBetweenFlushesGauge) {
        this.sinkGroup.gauge(MILLIS_TIME_BETWEEN_FLUSHES_GAUGE, millisTimeBetweenFlushesGauge);
        this.millisTimeBetweenFlushesGauge = millisTimeBetweenFlushesGauge;
    }

    @Generated
    public Counter getNumRecordsOutCounter() {
        return this.numRecordsOutCounter;
    }

    @Generated
    public Counter getNumBytesOutCounter() {
        return this.numBytesOutCounter;
    }

    @Generated
    public Gauge<Long> getCurrentSendTimeGauge() {
        return this.currentSendTimeGauge;
    }

    @Generated
    public Gauge<Long> getInFlightRequestsGauge() {
        return this.inFlightRequestsGauge;
    }

    @Generated
    public Gauge<Long> getBufferedRecordsGauge() {
        return this.bufferedRecordsGauge;
    }

    @Generated
    public Gauge<Long> getMillisTimeBetweenFlushesGauge() {
        return this.millisTimeBetweenFlushesGauge;
    }
}

