/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins;

import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.JdbcConnection;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.IMonitor;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.Log;

public class MonitorConnectionContext {
    private final int failureDetectionIntervalMillis;
    private final int failureDetectionTimeMillis;
    private final int failureDetectionCount;
    private final Log log;
    private final JdbcConnection connectionToAbort;
    private final IMonitor monitor;
    private volatile boolean activeContext = true;
    private volatile boolean nodeUnhealthy = false;
    private long startMonitorTimeNano;
    private long expectedActiveMonitoringStartTimeNano;
    private long invalidNodeStartTimeNano;
    private int failureCount;

    public MonitorConnectionContext(IMonitor monitor, JdbcConnection connectionToAbort, Log log, int failureDetectionTimeMillis, int failureDetectionIntervalMillis, int failureDetectionCount) {
        this.monitor = monitor;
        this.connectionToAbort = connectionToAbort;
        this.log = log;
        this.failureDetectionTimeMillis = failureDetectionTimeMillis;
        this.failureDetectionIntervalMillis = failureDetectionIntervalMillis;
        this.failureDetectionCount = failureDetectionCount;
    }

    void setStartMonitorTimeNano(long startMonitorTimeNano) {
        this.startMonitorTimeNano = startMonitorTimeNano;
        this.expectedActiveMonitoringStartTimeNano = startMonitorTimeNano + TimeUnit.MILLISECONDS.toNanos(this.failureDetectionTimeMillis);
    }

    public int getFailureDetectionTimeMillis() {
        return this.failureDetectionTimeMillis;
    }

    public int getFailureDetectionIntervalMillis() {
        return this.failureDetectionIntervalMillis;
    }

    public int getFailureDetectionCount() {
        return this.failureDetectionCount;
    }

    public long getExpectedActiveMonitoringStartTimeNano() {
        return this.expectedActiveMonitoringStartTimeNano;
    }

    public IMonitor getMonitor() {
        return this.monitor;
    }

    int getFailureCount() {
        return this.failureCount;
    }

    void setFailureCount(int failureCount) {
        this.failureCount = failureCount;
    }

    void setInvalidNodeStartTimeNano(long invalidNodeStartTimeNano) {
        this.invalidNodeStartTimeNano = invalidNodeStartTimeNano;
    }

    void resetInvalidNodeStartTime() {
        this.invalidNodeStartTimeNano = 0L;
    }

    boolean isInvalidNodeStartTimeDefined() {
        return this.invalidNodeStartTimeNano > 0L;
    }

    long getInvalidNodeStartTimeNano() {
        return this.invalidNodeStartTimeNano;
    }

    public boolean isNodeUnhealthy() {
        return this.nodeUnhealthy;
    }

    void setNodeUnhealthy(boolean nodeUnhealthy) {
        this.nodeUnhealthy = nodeUnhealthy;
    }

    public boolean isActiveContext() {
        return this.activeContext;
    }

    public void setInactive() {
        this.activeContext = false;
    }

    void abortConnection() {
        if (this.connectionToAbort == null || !this.activeContext) {
            return;
        }
        try {
            this.connectionToAbort.abortInternal();
        }
        catch (SQLException sqlEx) {
            this.log.logTrace(String.format("[MonitorConnectionContext] Exception during aborting connection: %s", sqlEx.getMessage()));
        }
    }

    public void updateConnectionStatus(String nodeName, long statusCheckStartNano, long statusCheckEndNano, boolean isValid) {
        if (!this.activeContext) {
            return;
        }
        long totalElapsedTimeNano = statusCheckEndNano - this.startMonitorTimeNano;
        if (totalElapsedTimeNano > TimeUnit.MILLISECONDS.toNanos(this.failureDetectionTimeMillis)) {
            this.setConnectionValid(nodeName, isValid, statusCheckStartNano, statusCheckEndNano);
        }
    }

    void setConnectionValid(String nodeName, boolean connectionValid, long statusCheckStartNano, long statusCheckEndNano) {
        if (!connectionValid) {
            long maxInvalidNodeDurationMillis;
            long invalidNodeDurationNano;
            ++this.failureCount;
            if (!this.isInvalidNodeStartTimeDefined()) {
                this.setInvalidNodeStartTimeNano(statusCheckStartNano);
            }
            if ((invalidNodeDurationNano = statusCheckEndNano - this.getInvalidNodeStartTimeNano()) >= TimeUnit.MILLISECONDS.toNanos(maxInvalidNodeDurationMillis = (long)this.getFailureDetectionIntervalMillis() * (long)Math.max(0, this.getFailureDetectionCount()))) {
                this.log.logTrace(String.format("[MonitorConnectionContext] node '%s' is *dead*.", nodeName));
                this.setNodeUnhealthy(true);
                this.abortConnection();
                return;
            }
            this.log.logTrace(String.format("[MonitorConnectionContext] node '%s' is not *responding* (%d).", nodeName, this.getFailureCount()));
            return;
        }
        this.setFailureCount(0);
        this.resetInvalidNodeStartTime();
        this.setNodeUnhealthy(false);
        this.log.logTrace(String.format("[MonitorConnectionContext] node '%s' is *alive*.", nodeName));
    }
}

