package grpc.cache_client.pubsub;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * For working with topics in a cache.
 * Momento topics are conceptually located on a cache. They are best-effort multicast.
 * To use them, create a cache then start subscribing and publishing!
 * Momento topic subscriptions try to give you information about the quality of the
 *   stream you are receiving. For example, you might miss messages if your network
 *   is slow, or if some intermediate switch fails, or due to rate limiting. It is
 *   also possible, though we try to avoid it, that messages could briefly come out
 *   of order between subscribers.
 *   We try to tell you when things like this happen via a Discontinuity in your
 *   subscription stream. If you do not care about occasional discontinuities then
 *   don't bother handling them! You might still want to log them just in case ;-)
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.53.0)",
    comments = "Source: cachepubsub.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class PubsubGrpc {

  private PubsubGrpc() {}

  public static final String SERVICE_NAME = "cache_client.pubsub.Pubsub";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<grpc.cache_client.pubsub._PublishRequest,
      grpc.common._Empty> getPublishMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Publish",
      requestType = grpc.cache_client.pubsub._PublishRequest.class,
      responseType = grpc.common._Empty.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<grpc.cache_client.pubsub._PublishRequest,
      grpc.common._Empty> getPublishMethod() {
    io.grpc.MethodDescriptor<grpc.cache_client.pubsub._PublishRequest, grpc.common._Empty> getPublishMethod;
    if ((getPublishMethod = PubsubGrpc.getPublishMethod) == null) {
      synchronized (PubsubGrpc.class) {
        if ((getPublishMethod = PubsubGrpc.getPublishMethod) == null) {
          PubsubGrpc.getPublishMethod = getPublishMethod =
              io.grpc.MethodDescriptor.<grpc.cache_client.pubsub._PublishRequest, grpc.common._Empty>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Publish"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  grpc.cache_client.pubsub._PublishRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  grpc.common._Empty.getDefaultInstance()))
              .setSchemaDescriptor(new PubsubMethodDescriptorSupplier("Publish"))
              .build();
        }
      }
    }
    return getPublishMethod;
  }

  private static volatile io.grpc.MethodDescriptor<grpc.cache_client.pubsub._SubscriptionRequest,
      grpc.cache_client.pubsub._SubscriptionItem> getSubscribeMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Subscribe",
      requestType = grpc.cache_client.pubsub._SubscriptionRequest.class,
      responseType = grpc.cache_client.pubsub._SubscriptionItem.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<grpc.cache_client.pubsub._SubscriptionRequest,
      grpc.cache_client.pubsub._SubscriptionItem> getSubscribeMethod() {
    io.grpc.MethodDescriptor<grpc.cache_client.pubsub._SubscriptionRequest, grpc.cache_client.pubsub._SubscriptionItem> getSubscribeMethod;
    if ((getSubscribeMethod = PubsubGrpc.getSubscribeMethod) == null) {
      synchronized (PubsubGrpc.class) {
        if ((getSubscribeMethod = PubsubGrpc.getSubscribeMethod) == null) {
          PubsubGrpc.getSubscribeMethod = getSubscribeMethod =
              io.grpc.MethodDescriptor.<grpc.cache_client.pubsub._SubscriptionRequest, grpc.cache_client.pubsub._SubscriptionItem>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Subscribe"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  grpc.cache_client.pubsub._SubscriptionRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  grpc.cache_client.pubsub._SubscriptionItem.getDefaultInstance()))
              .setSchemaDescriptor(new PubsubMethodDescriptorSupplier("Subscribe"))
              .build();
        }
      }
    }
    return getSubscribeMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static PubsubStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<PubsubStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<PubsubStub>() {
        @java.lang.Override
        public PubsubStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new PubsubStub(channel, callOptions);
        }
      };
    return PubsubStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static PubsubBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<PubsubBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<PubsubBlockingStub>() {
        @java.lang.Override
        public PubsubBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new PubsubBlockingStub(channel, callOptions);
        }
      };
    return PubsubBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static PubsubFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<PubsubFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<PubsubFutureStub>() {
        @java.lang.Override
        public PubsubFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new PubsubFutureStub(channel, callOptions);
        }
      };
    return PubsubFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * For working with topics in a cache.
   * Momento topics are conceptually located on a cache. They are best-effort multicast.
   * To use them, create a cache then start subscribing and publishing!
   * Momento topic subscriptions try to give you information about the quality of the
   *   stream you are receiving. For example, you might miss messages if your network
   *   is slow, or if some intermediate switch fails, or due to rate limiting. It is
   *   also possible, though we try to avoid it, that messages could briefly come out
   *   of order between subscribers.
   *   We try to tell you when things like this happen via a Discontinuity in your
   *   subscription stream. If you do not care about occasional discontinuities then
   *   don't bother handling them! You might still want to log them just in case ;-)
   * </pre>
   */
  public static abstract class PubsubImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Publish a message to a topic.
     * If a topic has no subscribers, then the effect of Publish MAY be either of:
     * * It is dropped and the topic is nonexistent.
     * * It is accepted to the topic as the next message.
     * Publish() does not wait for subscribers to accept. It returns Ok upon accepting
     * the topic value. It also returns Ok if there are no subscribers and the value
     * happens to be dropped. Publish() can not guarantee delivery in theory but in
     * practice it should almost always deliver to subscribers.
     * REQUIRES HEADER authorization: Momento auth token
     * </pre>
     */
    public void publish(grpc.cache_client.pubsub._PublishRequest request,
        io.grpc.stub.StreamObserver<grpc.common._Empty> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getPublishMethod(), responseObserver);
    }

    /**
     * <pre>
     * Subscribe to notifications from a topic.
     * You will receive a stream of values and (hopefully occasional) discontinuities.
     * Values will appear as copies of the payloads you Publish() to the topic.
     * REQUIRES HEADER authorization: Momento auth token
     * </pre>
     */
    public void subscribe(grpc.cache_client.pubsub._SubscriptionRequest request,
        io.grpc.stub.StreamObserver<grpc.cache_client.pubsub._SubscriptionItem> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getSubscribeMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getPublishMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                grpc.cache_client.pubsub._PublishRequest,
                grpc.common._Empty>(
                  this, METHODID_PUBLISH)))
          .addMethod(
            getSubscribeMethod(),
            io.grpc.stub.ServerCalls.asyncServerStreamingCall(
              new MethodHandlers<
                grpc.cache_client.pubsub._SubscriptionRequest,
                grpc.cache_client.pubsub._SubscriptionItem>(
                  this, METHODID_SUBSCRIBE)))
          .build();
    }
  }

  /**
   * <pre>
   * For working with topics in a cache.
   * Momento topics are conceptually located on a cache. They are best-effort multicast.
   * To use them, create a cache then start subscribing and publishing!
   * Momento topic subscriptions try to give you information about the quality of the
   *   stream you are receiving. For example, you might miss messages if your network
   *   is slow, or if some intermediate switch fails, or due to rate limiting. It is
   *   also possible, though we try to avoid it, that messages could briefly come out
   *   of order between subscribers.
   *   We try to tell you when things like this happen via a Discontinuity in your
   *   subscription stream. If you do not care about occasional discontinuities then
   *   don't bother handling them! You might still want to log them just in case ;-)
   * </pre>
   */
  public static final class PubsubStub extends io.grpc.stub.AbstractAsyncStub<PubsubStub> {
    private PubsubStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected PubsubStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new PubsubStub(channel, callOptions);
    }

    /**
     * <pre>
     * Publish a message to a topic.
     * If a topic has no subscribers, then the effect of Publish MAY be either of:
     * * It is dropped and the topic is nonexistent.
     * * It is accepted to the topic as the next message.
     * Publish() does not wait for subscribers to accept. It returns Ok upon accepting
     * the topic value. It also returns Ok if there are no subscribers and the value
     * happens to be dropped. Publish() can not guarantee delivery in theory but in
     * practice it should almost always deliver to subscribers.
     * REQUIRES HEADER authorization: Momento auth token
     * </pre>
     */
    public void publish(grpc.cache_client.pubsub._PublishRequest request,
        io.grpc.stub.StreamObserver<grpc.common._Empty> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getPublishMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Subscribe to notifications from a topic.
     * You will receive a stream of values and (hopefully occasional) discontinuities.
     * Values will appear as copies of the payloads you Publish() to the topic.
     * REQUIRES HEADER authorization: Momento auth token
     * </pre>
     */
    public void subscribe(grpc.cache_client.pubsub._SubscriptionRequest request,
        io.grpc.stub.StreamObserver<grpc.cache_client.pubsub._SubscriptionItem> responseObserver) {
      io.grpc.stub.ClientCalls.asyncServerStreamingCall(
          getChannel().newCall(getSubscribeMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * For working with topics in a cache.
   * Momento topics are conceptually located on a cache. They are best-effort multicast.
   * To use them, create a cache then start subscribing and publishing!
   * Momento topic subscriptions try to give you information about the quality of the
   *   stream you are receiving. For example, you might miss messages if your network
   *   is slow, or if some intermediate switch fails, or due to rate limiting. It is
   *   also possible, though we try to avoid it, that messages could briefly come out
   *   of order between subscribers.
   *   We try to tell you when things like this happen via a Discontinuity in your
   *   subscription stream. If you do not care about occasional discontinuities then
   *   don't bother handling them! You might still want to log them just in case ;-)
   * </pre>
   */
  public static final class PubsubBlockingStub extends io.grpc.stub.AbstractBlockingStub<PubsubBlockingStub> {
    private PubsubBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected PubsubBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new PubsubBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Publish a message to a topic.
     * If a topic has no subscribers, then the effect of Publish MAY be either of:
     * * It is dropped and the topic is nonexistent.
     * * It is accepted to the topic as the next message.
     * Publish() does not wait for subscribers to accept. It returns Ok upon accepting
     * the topic value. It also returns Ok if there are no subscribers and the value
     * happens to be dropped. Publish() can not guarantee delivery in theory but in
     * practice it should almost always deliver to subscribers.
     * REQUIRES HEADER authorization: Momento auth token
     * </pre>
     */
    public grpc.common._Empty publish(grpc.cache_client.pubsub._PublishRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getPublishMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Subscribe to notifications from a topic.
     * You will receive a stream of values and (hopefully occasional) discontinuities.
     * Values will appear as copies of the payloads you Publish() to the topic.
     * REQUIRES HEADER authorization: Momento auth token
     * </pre>
     */
    public java.util.Iterator<grpc.cache_client.pubsub._SubscriptionItem> subscribe(
        grpc.cache_client.pubsub._SubscriptionRequest request) {
      return io.grpc.stub.ClientCalls.blockingServerStreamingCall(
          getChannel(), getSubscribeMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * For working with topics in a cache.
   * Momento topics are conceptually located on a cache. They are best-effort multicast.
   * To use them, create a cache then start subscribing and publishing!
   * Momento topic subscriptions try to give you information about the quality of the
   *   stream you are receiving. For example, you might miss messages if your network
   *   is slow, or if some intermediate switch fails, or due to rate limiting. It is
   *   also possible, though we try to avoid it, that messages could briefly come out
   *   of order between subscribers.
   *   We try to tell you when things like this happen via a Discontinuity in your
   *   subscription stream. If you do not care about occasional discontinuities then
   *   don't bother handling them! You might still want to log them just in case ;-)
   * </pre>
   */
  public static final class PubsubFutureStub extends io.grpc.stub.AbstractFutureStub<PubsubFutureStub> {
    private PubsubFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected PubsubFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new PubsubFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Publish a message to a topic.
     * If a topic has no subscribers, then the effect of Publish MAY be either of:
     * * It is dropped and the topic is nonexistent.
     * * It is accepted to the topic as the next message.
     * Publish() does not wait for subscribers to accept. It returns Ok upon accepting
     * the topic value. It also returns Ok if there are no subscribers and the value
     * happens to be dropped. Publish() can not guarantee delivery in theory but in
     * practice it should almost always deliver to subscribers.
     * REQUIRES HEADER authorization: Momento auth token
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<grpc.common._Empty> publish(
        grpc.cache_client.pubsub._PublishRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getPublishMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_PUBLISH = 0;
  private static final int METHODID_SUBSCRIBE = 1;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final PubsubImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(PubsubImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_PUBLISH:
          serviceImpl.publish((grpc.cache_client.pubsub._PublishRequest) request,
              (io.grpc.stub.StreamObserver<grpc.common._Empty>) responseObserver);
          break;
        case METHODID_SUBSCRIBE:
          serviceImpl.subscribe((grpc.cache_client.pubsub._SubscriptionRequest) request,
              (io.grpc.stub.StreamObserver<grpc.cache_client.pubsub._SubscriptionItem>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class PubsubBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    PubsubBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return grpc.cache_client.pubsub.Cachepubsub.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("Pubsub");
    }
  }

  private static final class PubsubFileDescriptorSupplier
      extends PubsubBaseDescriptorSupplier {
    PubsubFileDescriptorSupplier() {}
  }

  private static final class PubsubMethodDescriptorSupplier
      extends PubsubBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    PubsubMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (PubsubGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new PubsubFileDescriptorSupplier())
              .addMethod(getPublishMethod())
              .addMethod(getSubscribeMethod())
              .build();
        }
      }
    }
    return result;
  }
}
