package grpc.webhook;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * A Webhook is a mechanism to consume messages on a Topic.
 * The primary purpose of webhooks in Momento is to enable
 * Lambda to be a subscriber to the messages sent on a topic.
 * Secondarily, webhooks open us up to a whole lot of integrations
 * (slack, discord, event bridge, etc).
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.53.0)",
    comments = "Source: webhook.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class WebhookGrpc {

  private WebhookGrpc() {}

  public static final String SERVICE_NAME = "webhook.Webhook";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<grpc.webhook._PutWebhookRequest,
      grpc.webhook._PutWebhookResponse> getPutWebhookMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "PutWebhook",
      requestType = grpc.webhook._PutWebhookRequest.class,
      responseType = grpc.webhook._PutWebhookResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<grpc.webhook._PutWebhookRequest,
      grpc.webhook._PutWebhookResponse> getPutWebhookMethod() {
    io.grpc.MethodDescriptor<grpc.webhook._PutWebhookRequest, grpc.webhook._PutWebhookResponse> getPutWebhookMethod;
    if ((getPutWebhookMethod = WebhookGrpc.getPutWebhookMethod) == null) {
      synchronized (WebhookGrpc.class) {
        if ((getPutWebhookMethod = WebhookGrpc.getPutWebhookMethod) == null) {
          WebhookGrpc.getPutWebhookMethod = getPutWebhookMethod =
              io.grpc.MethodDescriptor.<grpc.webhook._PutWebhookRequest, grpc.webhook._PutWebhookResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "PutWebhook"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  grpc.webhook._PutWebhookRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  grpc.webhook._PutWebhookResponse.getDefaultInstance()))
              .setSchemaDescriptor(new WebhookMethodDescriptorSupplier("PutWebhook"))
              .build();
        }
      }
    }
    return getPutWebhookMethod;
  }

  private static volatile io.grpc.MethodDescriptor<grpc.webhook._DeleteWebhookRequest,
      grpc.webhook._DeleteWebhookResponse> getDeleteWebhookMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DeleteWebhook",
      requestType = grpc.webhook._DeleteWebhookRequest.class,
      responseType = grpc.webhook._DeleteWebhookResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<grpc.webhook._DeleteWebhookRequest,
      grpc.webhook._DeleteWebhookResponse> getDeleteWebhookMethod() {
    io.grpc.MethodDescriptor<grpc.webhook._DeleteWebhookRequest, grpc.webhook._DeleteWebhookResponse> getDeleteWebhookMethod;
    if ((getDeleteWebhookMethod = WebhookGrpc.getDeleteWebhookMethod) == null) {
      synchronized (WebhookGrpc.class) {
        if ((getDeleteWebhookMethod = WebhookGrpc.getDeleteWebhookMethod) == null) {
          WebhookGrpc.getDeleteWebhookMethod = getDeleteWebhookMethod =
              io.grpc.MethodDescriptor.<grpc.webhook._DeleteWebhookRequest, grpc.webhook._DeleteWebhookResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "DeleteWebhook"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  grpc.webhook._DeleteWebhookRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  grpc.webhook._DeleteWebhookResponse.getDefaultInstance()))
              .setSchemaDescriptor(new WebhookMethodDescriptorSupplier("DeleteWebhook"))
              .build();
        }
      }
    }
    return getDeleteWebhookMethod;
  }

  private static volatile io.grpc.MethodDescriptor<grpc.webhook._ListWebhookRequest,
      grpc.webhook._ListWebhooksResponse> getListWebhooksMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ListWebhooks",
      requestType = grpc.webhook._ListWebhookRequest.class,
      responseType = grpc.webhook._ListWebhooksResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<grpc.webhook._ListWebhookRequest,
      grpc.webhook._ListWebhooksResponse> getListWebhooksMethod() {
    io.grpc.MethodDescriptor<grpc.webhook._ListWebhookRequest, grpc.webhook._ListWebhooksResponse> getListWebhooksMethod;
    if ((getListWebhooksMethod = WebhookGrpc.getListWebhooksMethod) == null) {
      synchronized (WebhookGrpc.class) {
        if ((getListWebhooksMethod = WebhookGrpc.getListWebhooksMethod) == null) {
          WebhookGrpc.getListWebhooksMethod = getListWebhooksMethod =
              io.grpc.MethodDescriptor.<grpc.webhook._ListWebhookRequest, grpc.webhook._ListWebhooksResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ListWebhooks"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  grpc.webhook._ListWebhookRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  grpc.webhook._ListWebhooksResponse.getDefaultInstance()))
              .setSchemaDescriptor(new WebhookMethodDescriptorSupplier("ListWebhooks"))
              .build();
        }
      }
    }
    return getListWebhooksMethod;
  }

  private static volatile io.grpc.MethodDescriptor<grpc.webhook._GetWebhookSecretRequest,
      grpc.webhook._GetWebhookSecretResponse> getGetWebhookSecretMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetWebhookSecret",
      requestType = grpc.webhook._GetWebhookSecretRequest.class,
      responseType = grpc.webhook._GetWebhookSecretResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<grpc.webhook._GetWebhookSecretRequest,
      grpc.webhook._GetWebhookSecretResponse> getGetWebhookSecretMethod() {
    io.grpc.MethodDescriptor<grpc.webhook._GetWebhookSecretRequest, grpc.webhook._GetWebhookSecretResponse> getGetWebhookSecretMethod;
    if ((getGetWebhookSecretMethod = WebhookGrpc.getGetWebhookSecretMethod) == null) {
      synchronized (WebhookGrpc.class) {
        if ((getGetWebhookSecretMethod = WebhookGrpc.getGetWebhookSecretMethod) == null) {
          WebhookGrpc.getGetWebhookSecretMethod = getGetWebhookSecretMethod =
              io.grpc.MethodDescriptor.<grpc.webhook._GetWebhookSecretRequest, grpc.webhook._GetWebhookSecretResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetWebhookSecret"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  grpc.webhook._GetWebhookSecretRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  grpc.webhook._GetWebhookSecretResponse.getDefaultInstance()))
              .setSchemaDescriptor(new WebhookMethodDescriptorSupplier("GetWebhookSecret"))
              .build();
        }
      }
    }
    return getGetWebhookSecretMethod;
  }

  private static volatile io.grpc.MethodDescriptor<grpc.webhook._RotateWebhookSecretRequest,
      grpc.webhook._RotateWebhookSecretResponse> getRotateWebhookSecretMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "RotateWebhookSecret",
      requestType = grpc.webhook._RotateWebhookSecretRequest.class,
      responseType = grpc.webhook._RotateWebhookSecretResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<grpc.webhook._RotateWebhookSecretRequest,
      grpc.webhook._RotateWebhookSecretResponse> getRotateWebhookSecretMethod() {
    io.grpc.MethodDescriptor<grpc.webhook._RotateWebhookSecretRequest, grpc.webhook._RotateWebhookSecretResponse> getRotateWebhookSecretMethod;
    if ((getRotateWebhookSecretMethod = WebhookGrpc.getRotateWebhookSecretMethod) == null) {
      synchronized (WebhookGrpc.class) {
        if ((getRotateWebhookSecretMethod = WebhookGrpc.getRotateWebhookSecretMethod) == null) {
          WebhookGrpc.getRotateWebhookSecretMethod = getRotateWebhookSecretMethod =
              io.grpc.MethodDescriptor.<grpc.webhook._RotateWebhookSecretRequest, grpc.webhook._RotateWebhookSecretResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "RotateWebhookSecret"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  grpc.webhook._RotateWebhookSecretRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  grpc.webhook._RotateWebhookSecretResponse.getDefaultInstance()))
              .setSchemaDescriptor(new WebhookMethodDescriptorSupplier("RotateWebhookSecret"))
              .build();
        }
      }
    }
    return getRotateWebhookSecretMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static WebhookStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<WebhookStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<WebhookStub>() {
        @java.lang.Override
        public WebhookStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new WebhookStub(channel, callOptions);
        }
      };
    return WebhookStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static WebhookBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<WebhookBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<WebhookBlockingStub>() {
        @java.lang.Override
        public WebhookBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new WebhookBlockingStub(channel, callOptions);
        }
      };
    return WebhookBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static WebhookFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<WebhookFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<WebhookFutureStub>() {
        @java.lang.Override
        public WebhookFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new WebhookFutureStub(channel, callOptions);
        }
      };
    return WebhookFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * A Webhook is a mechanism to consume messages on a Topic.
   * The primary purpose of webhooks in Momento is to enable
   * Lambda to be a subscriber to the messages sent on a topic.
   * Secondarily, webhooks open us up to a whole lot of integrations
   * (slack, discord, event bridge, etc).
   * </pre>
   */
  public static abstract class WebhookImplBase implements io.grpc.BindableService {

    /**
     */
    public void putWebhook(grpc.webhook._PutWebhookRequest request,
        io.grpc.stub.StreamObserver<grpc.webhook._PutWebhookResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getPutWebhookMethod(), responseObserver);
    }

    /**
     */
    public void deleteWebhook(grpc.webhook._DeleteWebhookRequest request,
        io.grpc.stub.StreamObserver<grpc.webhook._DeleteWebhookResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getDeleteWebhookMethod(), responseObserver);
    }

    /**
     */
    public void listWebhooks(grpc.webhook._ListWebhookRequest request,
        io.grpc.stub.StreamObserver<grpc.webhook._ListWebhooksResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getListWebhooksMethod(), responseObserver);
    }

    /**
     */
    public void getWebhookSecret(grpc.webhook._GetWebhookSecretRequest request,
        io.grpc.stub.StreamObserver<grpc.webhook._GetWebhookSecretResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetWebhookSecretMethod(), responseObserver);
    }

    /**
     */
    public void rotateWebhookSecret(grpc.webhook._RotateWebhookSecretRequest request,
        io.grpc.stub.StreamObserver<grpc.webhook._RotateWebhookSecretResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getRotateWebhookSecretMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getPutWebhookMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                grpc.webhook._PutWebhookRequest,
                grpc.webhook._PutWebhookResponse>(
                  this, METHODID_PUT_WEBHOOK)))
          .addMethod(
            getDeleteWebhookMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                grpc.webhook._DeleteWebhookRequest,
                grpc.webhook._DeleteWebhookResponse>(
                  this, METHODID_DELETE_WEBHOOK)))
          .addMethod(
            getListWebhooksMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                grpc.webhook._ListWebhookRequest,
                grpc.webhook._ListWebhooksResponse>(
                  this, METHODID_LIST_WEBHOOKS)))
          .addMethod(
            getGetWebhookSecretMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                grpc.webhook._GetWebhookSecretRequest,
                grpc.webhook._GetWebhookSecretResponse>(
                  this, METHODID_GET_WEBHOOK_SECRET)))
          .addMethod(
            getRotateWebhookSecretMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                grpc.webhook._RotateWebhookSecretRequest,
                grpc.webhook._RotateWebhookSecretResponse>(
                  this, METHODID_ROTATE_WEBHOOK_SECRET)))
          .build();
    }
  }

  /**
   * <pre>
   * A Webhook is a mechanism to consume messages on a Topic.
   * The primary purpose of webhooks in Momento is to enable
   * Lambda to be a subscriber to the messages sent on a topic.
   * Secondarily, webhooks open us up to a whole lot of integrations
   * (slack, discord, event bridge, etc).
   * </pre>
   */
  public static final class WebhookStub extends io.grpc.stub.AbstractAsyncStub<WebhookStub> {
    private WebhookStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected WebhookStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new WebhookStub(channel, callOptions);
    }

    /**
     */
    public void putWebhook(grpc.webhook._PutWebhookRequest request,
        io.grpc.stub.StreamObserver<grpc.webhook._PutWebhookResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getPutWebhookMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     */
    public void deleteWebhook(grpc.webhook._DeleteWebhookRequest request,
        io.grpc.stub.StreamObserver<grpc.webhook._DeleteWebhookResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getDeleteWebhookMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     */
    public void listWebhooks(grpc.webhook._ListWebhookRequest request,
        io.grpc.stub.StreamObserver<grpc.webhook._ListWebhooksResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getListWebhooksMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     */
    public void getWebhookSecret(grpc.webhook._GetWebhookSecretRequest request,
        io.grpc.stub.StreamObserver<grpc.webhook._GetWebhookSecretResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetWebhookSecretMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     */
    public void rotateWebhookSecret(grpc.webhook._RotateWebhookSecretRequest request,
        io.grpc.stub.StreamObserver<grpc.webhook._RotateWebhookSecretResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getRotateWebhookSecretMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * A Webhook is a mechanism to consume messages on a Topic.
   * The primary purpose of webhooks in Momento is to enable
   * Lambda to be a subscriber to the messages sent on a topic.
   * Secondarily, webhooks open us up to a whole lot of integrations
   * (slack, discord, event bridge, etc).
   * </pre>
   */
  public static final class WebhookBlockingStub extends io.grpc.stub.AbstractBlockingStub<WebhookBlockingStub> {
    private WebhookBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected WebhookBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new WebhookBlockingStub(channel, callOptions);
    }

    /**
     */
    public grpc.webhook._PutWebhookResponse putWebhook(grpc.webhook._PutWebhookRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getPutWebhookMethod(), getCallOptions(), request);
    }

    /**
     */
    public grpc.webhook._DeleteWebhookResponse deleteWebhook(grpc.webhook._DeleteWebhookRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getDeleteWebhookMethod(), getCallOptions(), request);
    }

    /**
     */
    public grpc.webhook._ListWebhooksResponse listWebhooks(grpc.webhook._ListWebhookRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getListWebhooksMethod(), getCallOptions(), request);
    }

    /**
     */
    public grpc.webhook._GetWebhookSecretResponse getWebhookSecret(grpc.webhook._GetWebhookSecretRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetWebhookSecretMethod(), getCallOptions(), request);
    }

    /**
     */
    public grpc.webhook._RotateWebhookSecretResponse rotateWebhookSecret(grpc.webhook._RotateWebhookSecretRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getRotateWebhookSecretMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * A Webhook is a mechanism to consume messages on a Topic.
   * The primary purpose of webhooks in Momento is to enable
   * Lambda to be a subscriber to the messages sent on a topic.
   * Secondarily, webhooks open us up to a whole lot of integrations
   * (slack, discord, event bridge, etc).
   * </pre>
   */
  public static final class WebhookFutureStub extends io.grpc.stub.AbstractFutureStub<WebhookFutureStub> {
    private WebhookFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected WebhookFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new WebhookFutureStub(channel, callOptions);
    }

    /**
     */
    public com.google.common.util.concurrent.ListenableFuture<grpc.webhook._PutWebhookResponse> putWebhook(
        grpc.webhook._PutWebhookRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getPutWebhookMethod(), getCallOptions()), request);
    }

    /**
     */
    public com.google.common.util.concurrent.ListenableFuture<grpc.webhook._DeleteWebhookResponse> deleteWebhook(
        grpc.webhook._DeleteWebhookRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getDeleteWebhookMethod(), getCallOptions()), request);
    }

    /**
     */
    public com.google.common.util.concurrent.ListenableFuture<grpc.webhook._ListWebhooksResponse> listWebhooks(
        grpc.webhook._ListWebhookRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getListWebhooksMethod(), getCallOptions()), request);
    }

    /**
     */
    public com.google.common.util.concurrent.ListenableFuture<grpc.webhook._GetWebhookSecretResponse> getWebhookSecret(
        grpc.webhook._GetWebhookSecretRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetWebhookSecretMethod(), getCallOptions()), request);
    }

    /**
     */
    public com.google.common.util.concurrent.ListenableFuture<grpc.webhook._RotateWebhookSecretResponse> rotateWebhookSecret(
        grpc.webhook._RotateWebhookSecretRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getRotateWebhookSecretMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_PUT_WEBHOOK = 0;
  private static final int METHODID_DELETE_WEBHOOK = 1;
  private static final int METHODID_LIST_WEBHOOKS = 2;
  private static final int METHODID_GET_WEBHOOK_SECRET = 3;
  private static final int METHODID_ROTATE_WEBHOOK_SECRET = 4;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final WebhookImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(WebhookImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_PUT_WEBHOOK:
          serviceImpl.putWebhook((grpc.webhook._PutWebhookRequest) request,
              (io.grpc.stub.StreamObserver<grpc.webhook._PutWebhookResponse>) responseObserver);
          break;
        case METHODID_DELETE_WEBHOOK:
          serviceImpl.deleteWebhook((grpc.webhook._DeleteWebhookRequest) request,
              (io.grpc.stub.StreamObserver<grpc.webhook._DeleteWebhookResponse>) responseObserver);
          break;
        case METHODID_LIST_WEBHOOKS:
          serviceImpl.listWebhooks((grpc.webhook._ListWebhookRequest) request,
              (io.grpc.stub.StreamObserver<grpc.webhook._ListWebhooksResponse>) responseObserver);
          break;
        case METHODID_GET_WEBHOOK_SECRET:
          serviceImpl.getWebhookSecret((grpc.webhook._GetWebhookSecretRequest) request,
              (io.grpc.stub.StreamObserver<grpc.webhook._GetWebhookSecretResponse>) responseObserver);
          break;
        case METHODID_ROTATE_WEBHOOK_SECRET:
          serviceImpl.rotateWebhookSecret((grpc.webhook._RotateWebhookSecretRequest) request,
              (io.grpc.stub.StreamObserver<grpc.webhook._RotateWebhookSecretResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class WebhookBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    WebhookBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return grpc.webhook.WebhookOuterClass.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("Webhook");
    }
  }

  private static final class WebhookFileDescriptorSupplier
      extends WebhookBaseDescriptorSupplier {
    WebhookFileDescriptorSupplier() {}
  }

  private static final class WebhookMethodDescriptorSupplier
      extends WebhookBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    WebhookMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (WebhookGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new WebhookFileDescriptorSupplier())
              .addMethod(getPutWebhookMethod())
              .addMethod(getDeleteWebhookMethod())
              .addMethod(getListWebhooksMethod())
              .addMethod(getGetWebhookSecretMethod())
              .addMethod(getRotateWebhookSecretMethod())
              .build();
        }
      }
    }
    return result;
  }
}
