package grpc.leaderboard;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * Like a sorted set, but for leaderboards!
 * Elements in a leaderboard are keyed by an ID, which is an unsigned 64 bit integer.
 * Scores are single-precision floating point numbers.
 * Each ID can have only 1 score.
 * For batchy, multi-element apis, limits are 8192 elements per api call.
 * Scores are IEEE 754 single-precision floating point numbers. This has a few
 * implications you should be aware of, but the one most likely to affect you is that
 * below -16777216 and above 16777216, not all integers are able to be represented.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.53.0)",
    comments = "Source: leaderboard.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class LeaderboardGrpc {

  private LeaderboardGrpc() {}

  public static final String SERVICE_NAME = "leaderboard.Leaderboard";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<grpc.leaderboard._DeleteLeaderboardRequest,
      grpc.leaderboard._Empty> getDeleteLeaderboardMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DeleteLeaderboard",
      requestType = grpc.leaderboard._DeleteLeaderboardRequest.class,
      responseType = grpc.leaderboard._Empty.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<grpc.leaderboard._DeleteLeaderboardRequest,
      grpc.leaderboard._Empty> getDeleteLeaderboardMethod() {
    io.grpc.MethodDescriptor<grpc.leaderboard._DeleteLeaderboardRequest, grpc.leaderboard._Empty> getDeleteLeaderboardMethod;
    if ((getDeleteLeaderboardMethod = LeaderboardGrpc.getDeleteLeaderboardMethod) == null) {
      synchronized (LeaderboardGrpc.class) {
        if ((getDeleteLeaderboardMethod = LeaderboardGrpc.getDeleteLeaderboardMethod) == null) {
          LeaderboardGrpc.getDeleteLeaderboardMethod = getDeleteLeaderboardMethod =
              io.grpc.MethodDescriptor.<grpc.leaderboard._DeleteLeaderboardRequest, grpc.leaderboard._Empty>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "DeleteLeaderboard"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  grpc.leaderboard._DeleteLeaderboardRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  grpc.leaderboard._Empty.getDefaultInstance()))
              .setSchemaDescriptor(new LeaderboardMethodDescriptorSupplier("DeleteLeaderboard"))
              .build();
        }
      }
    }
    return getDeleteLeaderboardMethod;
  }

  private static volatile io.grpc.MethodDescriptor<grpc.leaderboard._UpsertElementsRequest,
      grpc.leaderboard._Empty> getUpsertElementsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "UpsertElements",
      requestType = grpc.leaderboard._UpsertElementsRequest.class,
      responseType = grpc.leaderboard._Empty.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<grpc.leaderboard._UpsertElementsRequest,
      grpc.leaderboard._Empty> getUpsertElementsMethod() {
    io.grpc.MethodDescriptor<grpc.leaderboard._UpsertElementsRequest, grpc.leaderboard._Empty> getUpsertElementsMethod;
    if ((getUpsertElementsMethod = LeaderboardGrpc.getUpsertElementsMethod) == null) {
      synchronized (LeaderboardGrpc.class) {
        if ((getUpsertElementsMethod = LeaderboardGrpc.getUpsertElementsMethod) == null) {
          LeaderboardGrpc.getUpsertElementsMethod = getUpsertElementsMethod =
              io.grpc.MethodDescriptor.<grpc.leaderboard._UpsertElementsRequest, grpc.leaderboard._Empty>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "UpsertElements"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  grpc.leaderboard._UpsertElementsRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  grpc.leaderboard._Empty.getDefaultInstance()))
              .setSchemaDescriptor(new LeaderboardMethodDescriptorSupplier("UpsertElements"))
              .build();
        }
      }
    }
    return getUpsertElementsMethod;
  }

  private static volatile io.grpc.MethodDescriptor<grpc.leaderboard._RemoveElementsRequest,
      grpc.leaderboard._Empty> getRemoveElementsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "RemoveElements",
      requestType = grpc.leaderboard._RemoveElementsRequest.class,
      responseType = grpc.leaderboard._Empty.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<grpc.leaderboard._RemoveElementsRequest,
      grpc.leaderboard._Empty> getRemoveElementsMethod() {
    io.grpc.MethodDescriptor<grpc.leaderboard._RemoveElementsRequest, grpc.leaderboard._Empty> getRemoveElementsMethod;
    if ((getRemoveElementsMethod = LeaderboardGrpc.getRemoveElementsMethod) == null) {
      synchronized (LeaderboardGrpc.class) {
        if ((getRemoveElementsMethod = LeaderboardGrpc.getRemoveElementsMethod) == null) {
          LeaderboardGrpc.getRemoveElementsMethod = getRemoveElementsMethod =
              io.grpc.MethodDescriptor.<grpc.leaderboard._RemoveElementsRequest, grpc.leaderboard._Empty>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "RemoveElements"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  grpc.leaderboard._RemoveElementsRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  grpc.leaderboard._Empty.getDefaultInstance()))
              .setSchemaDescriptor(new LeaderboardMethodDescriptorSupplier("RemoveElements"))
              .build();
        }
      }
    }
    return getRemoveElementsMethod;
  }

  private static volatile io.grpc.MethodDescriptor<grpc.leaderboard._GetLeaderboardLengthRequest,
      grpc.leaderboard._GetLeaderboardLengthResponse> getGetLeaderboardLengthMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetLeaderboardLength",
      requestType = grpc.leaderboard._GetLeaderboardLengthRequest.class,
      responseType = grpc.leaderboard._GetLeaderboardLengthResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<grpc.leaderboard._GetLeaderboardLengthRequest,
      grpc.leaderboard._GetLeaderboardLengthResponse> getGetLeaderboardLengthMethod() {
    io.grpc.MethodDescriptor<grpc.leaderboard._GetLeaderboardLengthRequest, grpc.leaderboard._GetLeaderboardLengthResponse> getGetLeaderboardLengthMethod;
    if ((getGetLeaderboardLengthMethod = LeaderboardGrpc.getGetLeaderboardLengthMethod) == null) {
      synchronized (LeaderboardGrpc.class) {
        if ((getGetLeaderboardLengthMethod = LeaderboardGrpc.getGetLeaderboardLengthMethod) == null) {
          LeaderboardGrpc.getGetLeaderboardLengthMethod = getGetLeaderboardLengthMethod =
              io.grpc.MethodDescriptor.<grpc.leaderboard._GetLeaderboardLengthRequest, grpc.leaderboard._GetLeaderboardLengthResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetLeaderboardLength"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  grpc.leaderboard._GetLeaderboardLengthRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  grpc.leaderboard._GetLeaderboardLengthResponse.getDefaultInstance()))
              .setSchemaDescriptor(new LeaderboardMethodDescriptorSupplier("GetLeaderboardLength"))
              .build();
        }
      }
    }
    return getGetLeaderboardLengthMethod;
  }

  private static volatile io.grpc.MethodDescriptor<grpc.leaderboard._GetByRankRequest,
      grpc.leaderboard._GetByRankResponse> getGetByRankMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetByRank",
      requestType = grpc.leaderboard._GetByRankRequest.class,
      responseType = grpc.leaderboard._GetByRankResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<grpc.leaderboard._GetByRankRequest,
      grpc.leaderboard._GetByRankResponse> getGetByRankMethod() {
    io.grpc.MethodDescriptor<grpc.leaderboard._GetByRankRequest, grpc.leaderboard._GetByRankResponse> getGetByRankMethod;
    if ((getGetByRankMethod = LeaderboardGrpc.getGetByRankMethod) == null) {
      synchronized (LeaderboardGrpc.class) {
        if ((getGetByRankMethod = LeaderboardGrpc.getGetByRankMethod) == null) {
          LeaderboardGrpc.getGetByRankMethod = getGetByRankMethod =
              io.grpc.MethodDescriptor.<grpc.leaderboard._GetByRankRequest, grpc.leaderboard._GetByRankResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetByRank"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  grpc.leaderboard._GetByRankRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  grpc.leaderboard._GetByRankResponse.getDefaultInstance()))
              .setSchemaDescriptor(new LeaderboardMethodDescriptorSupplier("GetByRank"))
              .build();
        }
      }
    }
    return getGetByRankMethod;
  }

  private static volatile io.grpc.MethodDescriptor<grpc.leaderboard._GetRankRequest,
      grpc.leaderboard._GetRankResponse> getGetRankMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetRank",
      requestType = grpc.leaderboard._GetRankRequest.class,
      responseType = grpc.leaderboard._GetRankResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<grpc.leaderboard._GetRankRequest,
      grpc.leaderboard._GetRankResponse> getGetRankMethod() {
    io.grpc.MethodDescriptor<grpc.leaderboard._GetRankRequest, grpc.leaderboard._GetRankResponse> getGetRankMethod;
    if ((getGetRankMethod = LeaderboardGrpc.getGetRankMethod) == null) {
      synchronized (LeaderboardGrpc.class) {
        if ((getGetRankMethod = LeaderboardGrpc.getGetRankMethod) == null) {
          LeaderboardGrpc.getGetRankMethod = getGetRankMethod =
              io.grpc.MethodDescriptor.<grpc.leaderboard._GetRankRequest, grpc.leaderboard._GetRankResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetRank"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  grpc.leaderboard._GetRankRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  grpc.leaderboard._GetRankResponse.getDefaultInstance()))
              .setSchemaDescriptor(new LeaderboardMethodDescriptorSupplier("GetRank"))
              .build();
        }
      }
    }
    return getGetRankMethod;
  }

  private static volatile io.grpc.MethodDescriptor<grpc.leaderboard._GetByScoreRequest,
      grpc.leaderboard._GetByScoreResponse> getGetByScoreMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetByScore",
      requestType = grpc.leaderboard._GetByScoreRequest.class,
      responseType = grpc.leaderboard._GetByScoreResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<grpc.leaderboard._GetByScoreRequest,
      grpc.leaderboard._GetByScoreResponse> getGetByScoreMethod() {
    io.grpc.MethodDescriptor<grpc.leaderboard._GetByScoreRequest, grpc.leaderboard._GetByScoreResponse> getGetByScoreMethod;
    if ((getGetByScoreMethod = LeaderboardGrpc.getGetByScoreMethod) == null) {
      synchronized (LeaderboardGrpc.class) {
        if ((getGetByScoreMethod = LeaderboardGrpc.getGetByScoreMethod) == null) {
          LeaderboardGrpc.getGetByScoreMethod = getGetByScoreMethod =
              io.grpc.MethodDescriptor.<grpc.leaderboard._GetByScoreRequest, grpc.leaderboard._GetByScoreResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetByScore"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  grpc.leaderboard._GetByScoreRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  grpc.leaderboard._GetByScoreResponse.getDefaultInstance()))
              .setSchemaDescriptor(new LeaderboardMethodDescriptorSupplier("GetByScore"))
              .build();
        }
      }
    }
    return getGetByScoreMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static LeaderboardStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<LeaderboardStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<LeaderboardStub>() {
        @java.lang.Override
        public LeaderboardStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new LeaderboardStub(channel, callOptions);
        }
      };
    return LeaderboardStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static LeaderboardBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<LeaderboardBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<LeaderboardBlockingStub>() {
        @java.lang.Override
        public LeaderboardBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new LeaderboardBlockingStub(channel, callOptions);
        }
      };
    return LeaderboardBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static LeaderboardFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<LeaderboardFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<LeaderboardFutureStub>() {
        @java.lang.Override
        public LeaderboardFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new LeaderboardFutureStub(channel, callOptions);
        }
      };
    return LeaderboardFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * Like a sorted set, but for leaderboards!
   * Elements in a leaderboard are keyed by an ID, which is an unsigned 64 bit integer.
   * Scores are single-precision floating point numbers.
   * Each ID can have only 1 score.
   * For batchy, multi-element apis, limits are 8192 elements per api call.
   * Scores are IEEE 754 single-precision floating point numbers. This has a few
   * implications you should be aware of, but the one most likely to affect you is that
   * below -16777216 and above 16777216, not all integers are able to be represented.
   * </pre>
   */
  public static abstract class LeaderboardImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Deletes a leaderboard. After this call, you're not incurring storage cost for this leaderboard anymore.
     * </pre>
     */
    public void deleteLeaderboard(grpc.leaderboard._DeleteLeaderboardRequest request,
        io.grpc.stub.StreamObserver<grpc.leaderboard._Empty> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getDeleteLeaderboardMethod(), responseObserver);
    }

    /**
     * <pre>
     * Insert or update elements in a leaderboard. You can do up to 8192 elements per call.
     * There is no partial failure: Upsert succeeds or fails.
     * </pre>
     */
    public void upsertElements(grpc.leaderboard._UpsertElementsRequest request,
        io.grpc.stub.StreamObserver<grpc.leaderboard._Empty> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getUpsertElementsMethod(), responseObserver);
    }

    /**
     * <pre>
     * Remove up to 8192 elements at a time from a leaderboard. Elements are removed by id.
     * </pre>
     */
    public void removeElements(grpc.leaderboard._RemoveElementsRequest request,
        io.grpc.stub.StreamObserver<grpc.leaderboard._Empty> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getRemoveElementsMethod(), responseObserver);
    }

    /**
     * <pre>
     * Returns the length of a leaderboard in terms of ID count. 
     * </pre>
     */
    public void getLeaderboardLength(grpc.leaderboard._GetLeaderboardLengthRequest request,
        io.grpc.stub.StreamObserver<grpc.leaderboard._GetLeaderboardLengthResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetLeaderboardLengthMethod(), responseObserver);
    }

    /**
     * <pre>
     * Get a range of elements.
     * * Ordinal, 0-based rank.
     * * Range can span up to 8192 elements.
     * See RankRange for details about permissible ranges.
     * </pre>
     */
    public void getByRank(grpc.leaderboard._GetByRankRequest request,
        io.grpc.stub.StreamObserver<grpc.leaderboard._GetByRankResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetByRankMethod(), responseObserver);
    }

    /**
     * <pre>
     * Get the rank of a list of particular ids in the leaderboard.
     * * Ordinal, 0-based rank.
     * </pre>
     */
    public void getRank(grpc.leaderboard._GetRankRequest request,
        io.grpc.stub.StreamObserver<grpc.leaderboard._GetRankResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetRankMethod(), responseObserver);
    }

    /**
     * <pre>
     * Get a range of elements by a score range.
     * * Ordinal, 0-based rank.
     * You can request up to 8192 elements at a time. To page through many elements that all
     * fall into a score range you can repeatedly invoke this api with the offset parameter.
     * </pre>
     */
    public void getByScore(grpc.leaderboard._GetByScoreRequest request,
        io.grpc.stub.StreamObserver<grpc.leaderboard._GetByScoreResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetByScoreMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getDeleteLeaderboardMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                grpc.leaderboard._DeleteLeaderboardRequest,
                grpc.leaderboard._Empty>(
                  this, METHODID_DELETE_LEADERBOARD)))
          .addMethod(
            getUpsertElementsMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                grpc.leaderboard._UpsertElementsRequest,
                grpc.leaderboard._Empty>(
                  this, METHODID_UPSERT_ELEMENTS)))
          .addMethod(
            getRemoveElementsMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                grpc.leaderboard._RemoveElementsRequest,
                grpc.leaderboard._Empty>(
                  this, METHODID_REMOVE_ELEMENTS)))
          .addMethod(
            getGetLeaderboardLengthMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                grpc.leaderboard._GetLeaderboardLengthRequest,
                grpc.leaderboard._GetLeaderboardLengthResponse>(
                  this, METHODID_GET_LEADERBOARD_LENGTH)))
          .addMethod(
            getGetByRankMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                grpc.leaderboard._GetByRankRequest,
                grpc.leaderboard._GetByRankResponse>(
                  this, METHODID_GET_BY_RANK)))
          .addMethod(
            getGetRankMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                grpc.leaderboard._GetRankRequest,
                grpc.leaderboard._GetRankResponse>(
                  this, METHODID_GET_RANK)))
          .addMethod(
            getGetByScoreMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                grpc.leaderboard._GetByScoreRequest,
                grpc.leaderboard._GetByScoreResponse>(
                  this, METHODID_GET_BY_SCORE)))
          .build();
    }
  }

  /**
   * <pre>
   * Like a sorted set, but for leaderboards!
   * Elements in a leaderboard are keyed by an ID, which is an unsigned 64 bit integer.
   * Scores are single-precision floating point numbers.
   * Each ID can have only 1 score.
   * For batchy, multi-element apis, limits are 8192 elements per api call.
   * Scores are IEEE 754 single-precision floating point numbers. This has a few
   * implications you should be aware of, but the one most likely to affect you is that
   * below -16777216 and above 16777216, not all integers are able to be represented.
   * </pre>
   */
  public static final class LeaderboardStub extends io.grpc.stub.AbstractAsyncStub<LeaderboardStub> {
    private LeaderboardStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected LeaderboardStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new LeaderboardStub(channel, callOptions);
    }

    /**
     * <pre>
     * Deletes a leaderboard. After this call, you're not incurring storage cost for this leaderboard anymore.
     * </pre>
     */
    public void deleteLeaderboard(grpc.leaderboard._DeleteLeaderboardRequest request,
        io.grpc.stub.StreamObserver<grpc.leaderboard._Empty> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getDeleteLeaderboardMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Insert or update elements in a leaderboard. You can do up to 8192 elements per call.
     * There is no partial failure: Upsert succeeds or fails.
     * </pre>
     */
    public void upsertElements(grpc.leaderboard._UpsertElementsRequest request,
        io.grpc.stub.StreamObserver<grpc.leaderboard._Empty> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getUpsertElementsMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Remove up to 8192 elements at a time from a leaderboard. Elements are removed by id.
     * </pre>
     */
    public void removeElements(grpc.leaderboard._RemoveElementsRequest request,
        io.grpc.stub.StreamObserver<grpc.leaderboard._Empty> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getRemoveElementsMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Returns the length of a leaderboard in terms of ID count. 
     * </pre>
     */
    public void getLeaderboardLength(grpc.leaderboard._GetLeaderboardLengthRequest request,
        io.grpc.stub.StreamObserver<grpc.leaderboard._GetLeaderboardLengthResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetLeaderboardLengthMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Get a range of elements.
     * * Ordinal, 0-based rank.
     * * Range can span up to 8192 elements.
     * See RankRange for details about permissible ranges.
     * </pre>
     */
    public void getByRank(grpc.leaderboard._GetByRankRequest request,
        io.grpc.stub.StreamObserver<grpc.leaderboard._GetByRankResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetByRankMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Get the rank of a list of particular ids in the leaderboard.
     * * Ordinal, 0-based rank.
     * </pre>
     */
    public void getRank(grpc.leaderboard._GetRankRequest request,
        io.grpc.stub.StreamObserver<grpc.leaderboard._GetRankResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetRankMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Get a range of elements by a score range.
     * * Ordinal, 0-based rank.
     * You can request up to 8192 elements at a time. To page through many elements that all
     * fall into a score range you can repeatedly invoke this api with the offset parameter.
     * </pre>
     */
    public void getByScore(grpc.leaderboard._GetByScoreRequest request,
        io.grpc.stub.StreamObserver<grpc.leaderboard._GetByScoreResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetByScoreMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * Like a sorted set, but for leaderboards!
   * Elements in a leaderboard are keyed by an ID, which is an unsigned 64 bit integer.
   * Scores are single-precision floating point numbers.
   * Each ID can have only 1 score.
   * For batchy, multi-element apis, limits are 8192 elements per api call.
   * Scores are IEEE 754 single-precision floating point numbers. This has a few
   * implications you should be aware of, but the one most likely to affect you is that
   * below -16777216 and above 16777216, not all integers are able to be represented.
   * </pre>
   */
  public static final class LeaderboardBlockingStub extends io.grpc.stub.AbstractBlockingStub<LeaderboardBlockingStub> {
    private LeaderboardBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected LeaderboardBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new LeaderboardBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Deletes a leaderboard. After this call, you're not incurring storage cost for this leaderboard anymore.
     * </pre>
     */
    public grpc.leaderboard._Empty deleteLeaderboard(grpc.leaderboard._DeleteLeaderboardRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getDeleteLeaderboardMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Insert or update elements in a leaderboard. You can do up to 8192 elements per call.
     * There is no partial failure: Upsert succeeds or fails.
     * </pre>
     */
    public grpc.leaderboard._Empty upsertElements(grpc.leaderboard._UpsertElementsRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getUpsertElementsMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Remove up to 8192 elements at a time from a leaderboard. Elements are removed by id.
     * </pre>
     */
    public grpc.leaderboard._Empty removeElements(grpc.leaderboard._RemoveElementsRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getRemoveElementsMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Returns the length of a leaderboard in terms of ID count. 
     * </pre>
     */
    public grpc.leaderboard._GetLeaderboardLengthResponse getLeaderboardLength(grpc.leaderboard._GetLeaderboardLengthRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetLeaderboardLengthMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Get a range of elements.
     * * Ordinal, 0-based rank.
     * * Range can span up to 8192 elements.
     * See RankRange for details about permissible ranges.
     * </pre>
     */
    public grpc.leaderboard._GetByRankResponse getByRank(grpc.leaderboard._GetByRankRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetByRankMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Get the rank of a list of particular ids in the leaderboard.
     * * Ordinal, 0-based rank.
     * </pre>
     */
    public grpc.leaderboard._GetRankResponse getRank(grpc.leaderboard._GetRankRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetRankMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Get a range of elements by a score range.
     * * Ordinal, 0-based rank.
     * You can request up to 8192 elements at a time. To page through many elements that all
     * fall into a score range you can repeatedly invoke this api with the offset parameter.
     * </pre>
     */
    public grpc.leaderboard._GetByScoreResponse getByScore(grpc.leaderboard._GetByScoreRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetByScoreMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * Like a sorted set, but for leaderboards!
   * Elements in a leaderboard are keyed by an ID, which is an unsigned 64 bit integer.
   * Scores are single-precision floating point numbers.
   * Each ID can have only 1 score.
   * For batchy, multi-element apis, limits are 8192 elements per api call.
   * Scores are IEEE 754 single-precision floating point numbers. This has a few
   * implications you should be aware of, but the one most likely to affect you is that
   * below -16777216 and above 16777216, not all integers are able to be represented.
   * </pre>
   */
  public static final class LeaderboardFutureStub extends io.grpc.stub.AbstractFutureStub<LeaderboardFutureStub> {
    private LeaderboardFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected LeaderboardFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new LeaderboardFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Deletes a leaderboard. After this call, you're not incurring storage cost for this leaderboard anymore.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<grpc.leaderboard._Empty> deleteLeaderboard(
        grpc.leaderboard._DeleteLeaderboardRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getDeleteLeaderboardMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Insert or update elements in a leaderboard. You can do up to 8192 elements per call.
     * There is no partial failure: Upsert succeeds or fails.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<grpc.leaderboard._Empty> upsertElements(
        grpc.leaderboard._UpsertElementsRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getUpsertElementsMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Remove up to 8192 elements at a time from a leaderboard. Elements are removed by id.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<grpc.leaderboard._Empty> removeElements(
        grpc.leaderboard._RemoveElementsRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getRemoveElementsMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Returns the length of a leaderboard in terms of ID count. 
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<grpc.leaderboard._GetLeaderboardLengthResponse> getLeaderboardLength(
        grpc.leaderboard._GetLeaderboardLengthRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetLeaderboardLengthMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Get a range of elements.
     * * Ordinal, 0-based rank.
     * * Range can span up to 8192 elements.
     * See RankRange for details about permissible ranges.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<grpc.leaderboard._GetByRankResponse> getByRank(
        grpc.leaderboard._GetByRankRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetByRankMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Get the rank of a list of particular ids in the leaderboard.
     * * Ordinal, 0-based rank.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<grpc.leaderboard._GetRankResponse> getRank(
        grpc.leaderboard._GetRankRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetRankMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Get a range of elements by a score range.
     * * Ordinal, 0-based rank.
     * You can request up to 8192 elements at a time. To page through many elements that all
     * fall into a score range you can repeatedly invoke this api with the offset parameter.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<grpc.leaderboard._GetByScoreResponse> getByScore(
        grpc.leaderboard._GetByScoreRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetByScoreMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_DELETE_LEADERBOARD = 0;
  private static final int METHODID_UPSERT_ELEMENTS = 1;
  private static final int METHODID_REMOVE_ELEMENTS = 2;
  private static final int METHODID_GET_LEADERBOARD_LENGTH = 3;
  private static final int METHODID_GET_BY_RANK = 4;
  private static final int METHODID_GET_RANK = 5;
  private static final int METHODID_GET_BY_SCORE = 6;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final LeaderboardImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(LeaderboardImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_DELETE_LEADERBOARD:
          serviceImpl.deleteLeaderboard((grpc.leaderboard._DeleteLeaderboardRequest) request,
              (io.grpc.stub.StreamObserver<grpc.leaderboard._Empty>) responseObserver);
          break;
        case METHODID_UPSERT_ELEMENTS:
          serviceImpl.upsertElements((grpc.leaderboard._UpsertElementsRequest) request,
              (io.grpc.stub.StreamObserver<grpc.leaderboard._Empty>) responseObserver);
          break;
        case METHODID_REMOVE_ELEMENTS:
          serviceImpl.removeElements((grpc.leaderboard._RemoveElementsRequest) request,
              (io.grpc.stub.StreamObserver<grpc.leaderboard._Empty>) responseObserver);
          break;
        case METHODID_GET_LEADERBOARD_LENGTH:
          serviceImpl.getLeaderboardLength((grpc.leaderboard._GetLeaderboardLengthRequest) request,
              (io.grpc.stub.StreamObserver<grpc.leaderboard._GetLeaderboardLengthResponse>) responseObserver);
          break;
        case METHODID_GET_BY_RANK:
          serviceImpl.getByRank((grpc.leaderboard._GetByRankRequest) request,
              (io.grpc.stub.StreamObserver<grpc.leaderboard._GetByRankResponse>) responseObserver);
          break;
        case METHODID_GET_RANK:
          serviceImpl.getRank((grpc.leaderboard._GetRankRequest) request,
              (io.grpc.stub.StreamObserver<grpc.leaderboard._GetRankResponse>) responseObserver);
          break;
        case METHODID_GET_BY_SCORE:
          serviceImpl.getByScore((grpc.leaderboard._GetByScoreRequest) request,
              (io.grpc.stub.StreamObserver<grpc.leaderboard._GetByScoreResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class LeaderboardBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    LeaderboardBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return grpc.leaderboard.LeaderboardOuterClass.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("Leaderboard");
    }
  }

  private static final class LeaderboardFileDescriptorSupplier
      extends LeaderboardBaseDescriptorSupplier {
    LeaderboardFileDescriptorSupplier() {}
  }

  private static final class LeaderboardMethodDescriptorSupplier
      extends LeaderboardBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    LeaderboardMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (LeaderboardGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new LeaderboardFileDescriptorSupplier())
              .addMethod(getDeleteLeaderboardMethod())
              .addMethod(getUpsertElementsMethod())
              .addMethod(getRemoveElementsMethod())
              .addMethod(getGetLeaderboardLengthMethod())
              .addMethod(getGetByRankMethod())
              .addMethod(getGetRankMethod())
              .addMethod(getGetByScoreMethod())
              .build();
        }
      }
    }
    return result;
  }
}
