package com.etsy.sbt.checkstyle

/**
 * Enumeration of the different Checkstyle severity levels
 *
 * @author
 *   Andrew Johnson
 */
object CheckstyleSeverityLevel extends Enumeration {
  type CheckstyleSeverityLevel = Value

  val Ignore: CheckstyleSeverityLevel.Value = Value("ignore")
  val Info: CheckstyleSeverityLevel.Value = Value("info")
  val Warning: CheckstyleSeverityLevel.Value = Value("warning")
  val Error: CheckstyleSeverityLevel.Value = Value("error")
}
