/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.aws.kinesis.validation;

import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kinesis.model.GetRecordsResponse;
import software.amazon.awssdk.services.kinesis.model.Record;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;
import software.tnb.common.service.Validation;

public class KinesisValidation
implements Validation {
    private static final Logger LOG = LoggerFactory.getLogger(KinesisValidation.class);
    private final KinesisClient client;

    public KinesisValidation(KinesisClient client) {
        this.client = client;
    }

    public void createDataStream(String name) {
        LOG.debug("Creating Kinesis data stream {}", (Object)name);
        this.client.createStream(b -> b.streamName(name).shardCount(Integer.valueOf(1)));
    }

    public void waitForDataStream(String name) {
        LOG.debug("Waiting for Kinesis data stream {} to be ready", (Object)name);
        this.client.waiter().waitUntilStreamExists(builder -> builder.streamName(name));
        LOG.debug("Kinesis data stream {} is ready!", (Object)name);
    }

    public void deleteDataStream(String name) {
        LOG.debug("Deleting Kinesis data stream {}", (Object)name);
        this.client.deleteStream(b -> b.streamName(name));
    }

    public void sendMessage(String stream, String message, String partitionKey) {
        this.client.putRecord(b -> b.streamName(stream).partitionKey(partitionKey).data(SdkBytes.fromUtf8String((String)message)));
    }

    public List<Record> getRecords(String streamName) {
        List initialShardData = this.client.describeStream(b -> b.streamName(streamName)).streamDescription().shards();
        List initialShardIterators = initialShardData.stream().map(s -> this.client.getShardIterator(builder -> builder.shardId(s.shardId()).streamName(streamName).startingSequenceNumber(s.sequenceNumberRange().startingSequenceNumber()).shardIteratorType(ShardIteratorType.AT_SEQUENCE_NUMBER)).shardIterator()).collect(Collectors.toList());
        String shardIterator = (String)initialShardIterators.get(0);
        GetRecordsResponse recordResult = this.client.getRecords(b -> b.shardIterator(shardIterator).limit(Integer.valueOf(25)));
        return recordResult.records();
    }
}

