/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.aws.s3.service;

import java.net.URI;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.tnb.aws.common.account.AWSAccount;
import software.tnb.aws.common.service.AWSService;
import software.tnb.aws.s3.validation.S3Validation;
import software.tnb.common.account.AccountFactory;
import software.tnb.common.deployment.WithDockerImage;

public abstract class Minio
extends AWSService<AWSAccount, S3Client, S3Validation>
implements WithDockerImage {
    protected static final int CONTAINER_API_PORT = 9000;
    protected static final int CONTAINER_UI_PORT = 9001;

    public abstract String hostname();

    protected abstract String clientHostname();

    public AWSAccount account() {
        if (this.account == null) {
            LOG.debug("Creating new Minio account");
            this.account = (AWSAccount)AccountFactory.create(AWSAccount.class);
            this.account.setAccount_id("minio");
            this.account.setAccess_key("minio");
            this.account.setSecret_key("minio123");
        }
        return this.account;
    }

    protected S3Client client(Class<S3Client> clazz) {
        if (this.client == null) {
            this.client = (SdkClient)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().endpointOverride(URI.create(this.clientHostname()))).region(Region.of((String)this.account().region()))).credentialsProvider(() -> AwsBasicCredentials.create((String)this.account().accountId(), (String)this.account().secretKey()))).forcePathStyle(Boolean.valueOf(true))).build();
        }
        return (S3Client)this.client;
    }

    public String defaultImage() {
        return "quay.io/minio/minio:RELEASE.2022-09-17T00-09-45Z";
    }
}

